/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.filter.FormScope;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.Array;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDate;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFFileFilter;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.java.CustomObjectInputStream;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.server.LoggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.StoreService;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.io.DirFileUtils;
import coldfusion.tagext.io.DirectoryTag;
import coldfusion.tagext.io.FileListTable;
import coldfusion.tagext.io.FileStreamWrapper;
import coldfusion.tagext.io.FileTag;
import coldfusion.util.BOMReader;
import coldfusion.util.EncodingDetector;
import coldfusion.util.ExtensionFilter;
import coldfusion.util.FastHashtable;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import coldfusion.vfs.ApplicationRamFileSystemConfigBuilder;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFSFileSystemOptionFactory;
import coldfusion.vfs.VFSUtils;
import coldfusion.vfs.VFile;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.Part;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;

public class FileUtils {
    private static final String NO_EXTENSION = ":no-extension";
    private static final int COPY_BUFFER_LENGTH = 8192;
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String DEFAULT_CHARSET = FileUtils.getDefaultCharset();
    public static MimeTypes mimeTypes;
    public static final List<String> xtikaooxml;
    public static final List<String> xtikamsoffice;
    public static final String INVALID_FILE_TYPE = "INVALID_FILE_TYPE";
    public static final String EMPTY_FILE = "EMPTY_FILE";
    public static final String FILE_EXISTS = "FILE_EXISTS";
    public static final String FORM_FILE_NOT_FOUND = "FORM_FILE_NOT_FOUND";
    public static final String FILE_UPLOAD_FAILURE = "FILE_UPLOAD_FAILURE";
    public static final String INVALID_FILE_ATTRIBUTE = "INVALID_FILE_ATTRIBUTE";
    public static final String FILE_ATTRIBS_NOT_SET = "FILE_ATTRIBS_NOT_SET";
    public static final String TYPE_DIR = "dir";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_ALL = "all";
    public static final String LINE_SEPARATOR;
    private static final String WILDCARD = "*";
    private static final Boolean forceDelete;
    private static final boolean disallowEmptyFileUpload;
    private static final String ALLOWED_EXTENSION_FOR_PROPERTY_METHODS = "properties";

    public static void loadMimes() {
        mimeTypes = AccessController.doPrivileged(new PrivilegedAction<MimeTypes>(){

            @Override
            public MimeTypes run() {
                return TikaConfig.getDefaultConfig().getMimeRepository();
            }
        });
    }

    public static void createDirectory(String directory) {
        File dir = VFSFileFactory.getFileObject(directory);
        if (dir.isDirectory()) {
            throw new CannotCreateDirectoryException(directory);
        }
        if (dir.isFile()) {
            throw new DirectoryIsFileException(directory);
        }
        if (!dir.mkdirs()) {
            throw new CannotCreateDirectoryException(directory);
        }
    }

    public static long getDirectorySize(String directory) {
        File dir = VFSFileFactory.getFileObject(directory);
        if (!dir.isDirectory()) {
            throw new InvalidDirectoryException(directory);
        }
        if (!dir.canRead()) {
            throw new CannotReadDirectoryException(directory);
        }
        return FileUtils.recursiveDirectorySize(dir);
    }

    private static long recursiveDirectorySize(File dir) {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(null);
        }
        File[] listAll = dir.listFiles();
        long dirSize = 0L;
        if (listAll != null) {
            for (int i = 0; i < listAll.length; ++i) {
                if (listAll[i].isDirectory()) {
                    dirSize += FileUtils.recursiveDirectorySize(listAll[i]);
                    continue;
                }
                dirSize += listAll[i].length();
            }
        }
        return dirSize;
    }

    private static int getFileTypeToInteger(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return 0;
        }
        if ((type = type.trim()).equalsIgnoreCase(TYPE_DIR)) {
            return 1;
        }
        if (type.equalsIgnoreCase(TYPE_FILE)) {
            return 2;
        }
        if (type.equalsIgnoreCase(TYPE_ALL)) {
            return 0;
        }
        throw new DirectoryTag.InvalidTypeAttributeException(type);
    }

    public static Object listFiles(String directory, boolean recurse, String listInfo, Object filter, String sort) {
        return FileUtils.listFiles(directory, recurse, listInfo, filter, sort, null);
    }

    public static Object listFiles(String directory, boolean recurse, String listInfo, Object filter, String sort, String type) {
        int fileType = FileUtils.getFileTypeToInteger(type);
        File[] files = null;
        try {
            files = FileUtils.listFiles(directory, recurse, filter, sort);
        }
        catch (InvalidDirectoryException e) {
            files = new File[]{};
        }
        if ("query".equalsIgnoreCase(listInfo)) {
            FileListTable table = new FileListTable(directory, recurse);
            table.populate(files, false, fileType);
            return table;
        }
        ArrayList<String> names = new ArrayList<String>();
        boolean namesOnly = "name".equalsIgnoreCase(listInfo);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (fileType != 0 && (fileType == 1 && !files[i].isDirectory() || fileType == 2 && !files[i].isFile())) continue;
                if (namesOnly) {
                    names.add(files[i].getName());
                    continue;
                }
                names.add(files[i].getAbsolutePath());
            }
        }
        return names;
    }

    private static boolean isS3File(File dir) {
        if (dir instanceof VFile) {
            VFile vfile = (VFile)dir;
            StoreService storeService = ServiceFactory.getStoreService(false);
            if (storeService != null) {
                return storeService.isInstanceOfS3FileObject(vfile.getFileObject());
            }
        }
        return false;
    }

    public static File[] listFiles(String directory, boolean recurse, Object filter, String sort) {
        return FileUtils.listFiles(directory, recurse, filter, sort, false);
    }

    private static boolean _isDirectory(final File dir) {
        if (System.getSecurityManager() == null) {
            return dir.isDirectory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return dir.isDirectory();
            }
        });
    }

    public static File[] listFiles(String directory, boolean recurse, Object filter, String sort, boolean acceptDirectory) {
        File[] files;
        File dir;
        if (VFSFileFactory.checkIfVFile(directory) && directory.charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!FileUtils.isS3File(dir = VFSFileFactory.getFileObject(directory))) {
            if (!FileUtils._isDirectory(dir)) {
                throw new InvalidDirectoryException(directory);
            }
            if (!dir.canRead()) {
                throw new CannotReadDirectoryException(directory);
            }
        }
        FileFilter fileFilter = null;
        if (filter instanceof String) {
            String filterString = (String)filter;
            if (filterString.trim().length() == 0) {
                filter = null;
            }
            if (StringUtils.isNotBlank((CharSequence)filterString)) {
                fileFilter = new ExtensionFilter(filterString, acceptDirectory);
            }
        } else if (filter instanceof UDFMethod) {
            fileFilter = new UDFFileFilter((UDFMethod)filter);
        } else if (filter instanceof JavaProxy) {
            JavaProxy fileFilterJavaProxyObj = (JavaProxy)filter;
            Object fileFilterJavaObj = fileFilterJavaProxyObj.getObject();
            if (fileFilterJavaObj instanceof FileFilter) {
                fileFilter = (FileFilter)fileFilterJavaObj;
            }
        } else if (filter instanceof FileFilter) {
            fileFilter = (FileFilter)filter;
        } else if (filter instanceof List) {
            fileFilter = new ExtensionFilter(String.join((CharSequence)"|", (List)filter), acceptDirectory);
        } else if (filter != null) {
            throw new InvalidFileFilterException();
        }
        if (recurse) {
            ArrayList filelist = new ArrayList();
            FileUtils.recursiveGetFiles(filelist, dir, fileFilter);
            files = filelist.toArray(new File[filelist.size()]);
        } else {
            File[] fileArray = files = filter == null ? dir.listFiles() : dir.listFiles(fileFilter);
        }
        if (sort != null && sort.length() != 0 && files != null && files.length > 1) {
            MultiColumnSorter s = new MultiColumnSorter();
            StringTokenizer tokens = new StringTokenizer(sort.toUpperCase(), ",");
            while (tokens.hasMoreTokens()) {
                s.add(tokens.nextToken().trim());
            }
            Arrays.sort(files, s);
        }
        return files;
    }

    public static void recursiveGetFiles(List filelist, File dir, FileFilter filter) {
        File[] listAll = dir.listFiles();
        if (filter != null && listAll != null) {
            for (File f : listAll) {
                if (!filter.accept(f)) continue;
                filelist.add(f);
            }
        }
        if (listAll != null) {
            for (int i = 0; i < listAll.length; ++i) {
                if (filter == null) {
                    filelist.add(listAll[i]);
                }
                if (!listAll[i].isDirectory()) continue;
                FileUtils.recursiveGetFiles(filelist, listAll[i], filter);
            }
        }
    }

    public static void writePropertiesFile(String absFilePath, String key, Object value, String encoding) throws IOException {
        FileUtils.performCommonChecks(absFilePath, encoding);
        Properties properties = FileUtils.initializeProperties(absFilePath, encoding);
        properties.setProperty(key, Cast._String(value));
        FileUtils.writePropertiesToFile(properties, absFilePath, encoding);
    }

    public static void writePropertiesFile(String absFilePath, Map content, String encoding) throws IOException {
        FileUtils.performCommonChecks(absFilePath, encoding);
        Properties properties = FileUtils.initializeProperties(absFilePath, encoding);
        content.forEach((key, value) -> properties.setProperty((String)key, Cast._String(value)));
        FileUtils.writePropertiesToFile(properties, absFilePath, encoding);
    }

    private static void performCommonChecks(String absFilePath, String encoding) {
        FileUtils.verifyFile(absFilePath);
        FileUtils.isExtensionAllowed(absFilePath, ALLOWED_EXTENSION_FOR_PROPERTY_METHODS);
        Utils.checkEncoding(encoding);
    }

    private static void isExtensionAllowed(String absFilePath, String allowedExtensions) {
        boolean isExtensionAllowed = false;
        String extension = FileUtils.getFileExtension(absFilePath);
        if (allowedExtensions != null && !allowedExtensions.isEmpty() && extension != null) {
            String[] acceptExtensionsArray;
            for (String acceptExtension : acceptExtensionsArray = allowedExtensions.split(",")) {
                extension = extension.trim();
                if (!(acceptExtension = acceptExtension.trim()).equalsIgnoreCase(extension)) continue;
                isExtensionAllowed = true;
                break;
            }
        }
        if (!isExtensionAllowed) {
            throw new InvalidFileExtensionException(extension, allowedExtensions);
        }
    }

    private static String getFileExtension(String absFilePath) {
        String extension = "";
        int i = absFilePath.lastIndexOf(46);
        if (i > 0) {
            extension = absFilePath.substring(i + 1);
        }
        return extension;
    }

    private static Properties initializeProperties(String absFilePath, String encoding) throws IOException {
        Properties properties;
        File file = new File(absFilePath);
        if (file.exists() && file.isFile()) {
            properties = FileUtils.readPropertiesFile(absFilePath, encoding);
        } else {
            properties = new Properties();
            file.createNewFile();
        }
        return properties;
    }

    private static void writePropertiesToFile(Properties properties, String absFilePath, String encoding) throws IOException {
        try {
            File file = new File(absFilePath);
            OutputStream outputStream = VFSFileFactory.getOutputStream(file, true);
            properties.store(new OutputStreamWriter((OutputStream)new FileOutputStream(absFilePath), encoding), "File created by CF");
        }
        catch (IOException e) {
            CFLogs.APPLICATION_LOG.error(e);
            throw new RuntimeException(e);
        }
    }

    public static CaseSensitiveStruct readPropertiesFileInStruct(String filePath, String encoding) throws IOException {
        CaseSensitiveStruct result = new CaseSensitiveStruct();
        Properties properties = FileUtils.readPropertiesFile(filePath, encoding);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put(Cast._String(key), (Object)Cast._String(value))));
        return result;
    }

    public static Properties readPropertiesFile(String filePath, String encoding) throws IOException {
        Properties properties;
        File file;
        FileUtils.verifyFile(filePath);
        FileUtils.isExtensionAllowed(filePath, ALLOWED_EXTENSION_FOR_PROPERTY_METHODS);
        if (encoding != null && !encoding.isEmpty()) {
            Utils.checkEncoding(encoding);
        }
        if (!(file = VFSFileFactory.checkIfVFile(filePath) ? VFSFileFactory.getFileObject(filePath) : new File(filePath)).exists() || file.isDirectory()) {
            throw new java.io.FileNotFoundException(RB.getString(FileUtils.class, "FileNotFound", (Object)filePath));
        }
        EncodingDetector encodingDetectUtil = new EncodingDetector();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(VFSFileFactory.getInputStream(file));
             InputStreamReader streamReader = encodingDetectUtil.getReader(bufferedInputStream, DEFAULT_CHARSET, encoding);){
            properties = new Properties();
            properties.load(streamReader);
        }
        catch (java.io.FileNotFoundException fnfe) {
            CFLogs.APPLICATION_LOG.error(fnfe);
            throw new java.io.FileNotFoundException(RB.getString(FileUtils.class, "FileNotFound", (Object)filePath));
        }
        catch (IOException ioe) {
            CFLogs.APPLICATION_LOG.error(ioe);
            throw new IOException(ioe.getMessage() + " : " + filePath);
        }
        return properties;
    }

    public static void delete(File file) {
        if (VFSFileFactory.checkIfVFile(file.getAbsolutePath())) {
            if (!file.delete()) {
                throw new CouldNotDeleteFileException(file.getAbsolutePath());
            }
        } else {
            try {
                Files.delete(file.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (DirectoryNotEmptyException dirNotEmptyException) {
                throw new NonEmptyDirectoryCannotBeDeletedException(file.getAbsolutePath());
            }
            catch (IOException e) {
                if (forceDelete.booleanValue()) {
                    if (!file.delete()) {
                        throw new CouldNotDeleteFileException(file.getAbsolutePath());
                    }
                    return;
                }
                throw new KnownDeletetionException(e, file.getAbsolutePath());
            }
        }
    }

    public static void deleteDirectory(String directory, boolean recurse) {
        File dir = VFSFileFactory.getFileObject(directory);
        if (!dir.isDirectory()) {
            throw new InvalidDirectoryException(directory);
        }
        if (recurse) {
            FileUtils.recursiveRemoveDir(dir);
        } else {
            FileUtils.delete(dir);
        }
    }

    private static void recursiveRemoveDir(File directory) {
        String[] filelist = directory.list();
        for (int i = 0; i < filelist.length; ++i) {
            File tmpFile = VFSFileFactory.getFileObject(directory.getAbsolutePath(), filelist[i]);
            if (tmpFile.isDirectory()) {
                FileUtils.recursiveRemoveDir(tmpFile);
                continue;
            }
            if (!tmpFile.isFile()) continue;
            FileUtils.delete(tmpFile);
        }
        FileUtils.delete(directory);
    }

    public static void renameDirectory(String directory, String newdirectory) {
        File new_dir;
        File dir = VFSFileFactory.getFileObject(directory);
        if (!dir.exists()) {
            throw new InvalidDirectoryException(directory);
        }
        if (newdirectory.length() > 1 && (newdirectory.charAt(0) == '/' || newdirectory.charAt(1) == ':' || newdirectory.startsWith("\\") || VFSFileFactory.checkIfVFile(newdirectory))) {
            new_dir = VFSFileFactory.getFileObject(newdirectory);
        } else {
            String parentPath = dir.getParent();
            new_dir = VFSFileFactory.getFileObject(parentPath, VFSFileFactory.getFileObject(newdirectory).getPath());
        }
        if (new_dir.isDirectory()) {
            throw new NewDirectoryExistedException(newdirectory);
        }
        if (!dir.renameTo(new_dir)) {
            throw new DirectoryCannotBeRenamed(directory, new_dir.getPath());
        }
    }

    public static void copy(String source, String destination) {
        if (source.equalsIgnoreCase(destination)) {
            throw new FileTag.SourceEqualsDestinationException(source);
        }
        try {
            FileUtils.copyFile(source, destination);
        }
        catch (IOException e) {
            throw new FileCopyException(source, destination, e);
        }
    }

    public static Array uploadAll(String destination, String accept, String nameconflict, PageContext pageContext, boolean strict, boolean continueOnError, String errors) {
        return FileUtils.uploadAll(destination, accept, nameconflict, pageContext, strict, continueOnError, errors, false, null);
    }

    public static Array uploadAll(String destination, String accept, String nameconflict, PageContext pageContext, boolean strict, boolean continueOnError, String errors, boolean isBlocked, String acceptExtensions) {
        if (destination == null || destination.trim().length() == 0) {
            throw new DestinationNotDefinedException();
        }
        FormScope formScope = FormScope.getFormScope();
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String ctype = req.getContentType();
        if (ctype == null || !ctype.startsWith(MULTIPART_FORM_DATA)) {
            throw new CFFileNonMultipartException(ctype);
        }
        List partsArrayList = formScope.getPartsArray();
        Array resultArray = null;
        Array errorArray = null;
        boolean isErrorParamGiven = false;
        if (partsArrayList != null) {
            Iterator partsIterator = partsArrayList.iterator();
            resultArray = new Array();
            isErrorParamGiven = StringUtils.isNotBlank((CharSequence)errors);
            if (isErrorParamGiven) {
                errorArray = new Array();
            }
            String filefield = null;
            int tmpFileIndex = 0;
            ArrayList<String> processedFiledList = new ArrayList<String>();
            while (partsIterator.hasNext()) {
                FilePart filePart;
                Part part = (Part)partsIterator.next();
                if (!(part instanceof FilePart) || (filePart = (FilePart)part).getFileName() == null) continue;
                filefield = filePart.getName();
                if (processedFiledList.contains(filefield)) {
                    ++tmpFileIndex;
                } else {
                    processedFiledList.add(filefield);
                    tmpFileIndex = 0;
                }
                try {
                    Struct result = FileUtils.uploadFile(destination, filefield, !isBlocked ? accept : null, isBlocked ? accept : null, nameconflict, pageContext, strict, tmpFileIndex, acceptExtensions);
                    resultArray.add(result);
                }
                catch (EmptyFileUploadException e) {
                    if (continueOnError && errorArray != null) {
                        errorArray.add(e.getAsStruct());
                    }
                }
                catch (FileUploadException e) {
                    if (!continueOnError || !e.canSkip()) {
                        throw e;
                    }
                    if (errorArray != null) {
                        errorArray.add(e.getAsStruct());
                    }
                }
                catch (InvalidDestinationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeWrapper(e);
                }
                filefield = null;
            }
        }
        if (isErrorParamGiven) {
            pageContext.setAttribute(errors, errorArray);
        }
        return resultArray;
    }

    public static Struct upload(String destination, String filefield, String accept, String nameconflict, PageContext pageContext, boolean strict) throws FileNotFoundException, IOException {
        if (destination == null || destination.trim().length() == 0) {
            throw new DestinationNotDefinedException();
        }
        if (filefield != null && filefield.trim().length() == 0) {
            filefield = null;
        }
        return FileUtils.uploadFile(destination, filefield, accept, nameconflict, pageContext, strict, 0);
    }

    public static Struct upload(String destination, String filefield, String accept, String nameconflict, PageContext pageContext, boolean strict, boolean isBlocked, String acceptExtensions, boolean continueOnError, String errorVariable) throws FileNotFoundException, IOException {
        if (destination == null || destination.trim().length() == 0) {
            throw new DestinationNotDefinedException();
        }
        if (filefield != null && filefield.trim().length() == 0) {
            filefield = null;
        }
        boolean isErrorParamGiven = StringUtils.isNotBlank((CharSequence)errorVariable) && continueOnError;
        Array errorArray = null;
        Struct result = new Struct();
        if (isErrorParamGiven) {
            errorArray = new Array();
        }
        try {
            result = FileUtils.uploadFile(destination, filefield, !isBlocked ? accept : null, isBlocked ? accept : null, nameconflict, pageContext, strict, 0, acceptExtensions);
        }
        catch (EmptyFileUploadException e) {
            if (continueOnError && errorArray != null) {
                errorArray.add(e.getAsStruct());
            }
        }
        catch (FileUploadException e) {
            if (!continueOnError || !e.canSkip()) {
                throw e;
            }
            if (errorArray != null) {
                errorArray.add(e.getAsStruct());
            }
        }
        catch (InvalidDestinationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeWrapper(e);
        }
        if (isErrorParamGiven) {
            pageContext.setAttribute(errorVariable, (Object)errorArray);
        }
        return result;
    }

    public static Struct uploadFile(String destination, String filefield, String accept, String nameconflict, PageContext pageContext, boolean strict, int tmpFileIndex) throws FileNotFoundException, IOException {
        return FileUtils.uploadFile(destination, filefield, accept, null, nameconflict, pageContext, strict, tmpFileIndex, null);
    }

    public static Struct uploadFile(String destination, String filefield, String accept, String block, String nameconflict, PageContext pageContext, boolean strict, int tmpFileIndex, String acceptExtensions) throws FileNotFoundException, IOException {
        FormScope formScope = FormScope.getFormScope();
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String ctype = req.getContentType();
        if (ctype == null || !ctype.startsWith(MULTIPART_FORM_DATA)) {
            throw new CFFileNonMultipartException(ctype);
        }
        List partsArrayList = formScope.getPartsArray();
        boolean bFoundFile = false;
        String clientPath = "";
        String clientName = "";
        String clientExt = "";
        File serverFile = null;
        String serverDirectory = "";
        String serverFileName = "";
        String attemptedServerFileName = "";
        String serverExt = "";
        boolean fileExisted = false;
        boolean overWrite = false;
        boolean makeUnique = false;
        boolean wasSaved = false;
        String mimeType = null;
        if (partsArrayList != null) {
            Iterator partsIterator = partsArrayList.iterator();
            int partCount = 0;
            while (partsIterator.hasNext() && !bFoundFile) {
                Part part = (Part)partsIterator.next();
                String name = part.getName();
                clientExt = "";
                String formFieldName = "form." + name;
                if (!part.isFile() || part.getName() == null || filefield != null && !filefield.equalsIgnoreCase(formFieldName) && !filefield.equalsIgnoreCase(name)) continue;
                if (partCount < tmpFileIndex) {
                    ++partCount;
                    continue;
                }
                if (((FilePart)part).getFileName() != null) {
                    bFoundFile = true;
                    FilePart filePart = (FilePart)part;
                    String fileName = filePart.getFileName();
                    mimeType = filePart.getContentType();
                    String tempDir = Utils.getTempDir(pageContext);
                    if (destination.endsWith("\\") || destination.endsWith("/")) {
                        destination = destination.concat(fileName);
                    }
                    serverFile = FileUtils.determineDest(destination, tempDir, fileName);
                    clientPath = filePart.getFilePath();
                    int extIndex = -1;
                    clientPath = clientPath.lastIndexOf(File.separatorChar) >= 0 ? clientPath.substring(0, clientPath.lastIndexOf(File.separatorChar)) : "";
                    if (fileName.lastIndexOf(".") >= 0) {
                        extIndex = fileName.lastIndexOf(".", fileName.length());
                    }
                    if (extIndex != -1) {
                        clientExt = fileName.substring(extIndex + 1, fileName.length());
                    }
                    clientName = fileName;
                    if (extIndex != -1) {
                        clientName = clientName.substring(0, extIndex);
                    }
                    if (accept != null && accept.length() < 2 && !accept.equals(WILDCARD) && !accept.trim().equals("")) {
                        throw new InvalidValueException("accept");
                    }
                    if (block != null && block.length() < 2 && !block.equals(WILDCARD) && !block.trim().equals("")) {
                        throw new InvalidValueException("block");
                    }
                    if (accept == null || accept.trim().length() == 0) {
                        FileUtils.matchExtensions(null, clientExt, acceptExtensions, false);
                    }
                    if (!strict) {
                        if (block != null && block.length() >= 2) {
                            Boolean result = FileUtils.matchFileType(block, clientExt, mimeType);
                            if (result == null) {
                                throw new NoFileExtensionFileUploadsBlockedException();
                            }
                            if (result.booleanValue()) {
                                throw new BlockedUploadTypeException(block, mimeType.trim(), clientName, clientExt);
                            }
                        }
                        if (accept != null && accept.length() >= 2) {
                            if (FileUtils.matchFileType(accept, clientExt, mimeType) == Boolean.FALSE) {
                                throw new InvalidUploadTypeException(accept, mimeType.trim(), clientName, clientExt);
                            }
                            FileUtils.matchExtensions(accept, clientExt, acceptExtensions, true);
                        }
                    }
                    String serverFilePath = serverFile.getPath();
                    serverDirectory = serverFile.getParent();
                    serverFileName = serverFile.getName();
                    serverExt = "";
                    if (serverFileName.lastIndexOf(".") >= 0 && (extIndex = serverFileName.lastIndexOf(".", serverFileName.length())) != -1) {
                        serverExt = serverFileName.substring(extIndex + 1, serverFileName.length());
                    }
                    fileExisted = serverFile.exists();
                    boolean skip = false;
                    if (fileExisted) {
                        if (nameconflict == null || nameconflict.equalsIgnoreCase("error")) {
                            throw new FileOverwriteException(serverFilePath, clientName, clientExt);
                        }
                        overWrite = nameconflict.equalsIgnoreCase("overwrite");
                        skip = nameconflict.equalsIgnoreCase("skip");
                        makeUnique = nameconflict.equalsIgnoreCase("makeunique");
                    }
                    attemptedServerFileName = serverFile.getName();
                    if (makeUnique) {
                        serverFile = FileUtils.uniqueFile(serverFile, serverFileName, serverExt);
                        serverFileName = serverFile.getName();
                    }
                    FastHashtable tempfiles = formScope.getTempFiles();
                    String fileFieldName = filePart.getName().toUpperCase();
                    Object temp = tempfiles.get(fileFieldName);
                    File tempFile = null;
                    if (temp instanceof File) {
                        tempFile = (File)temp;
                    } else if (temp instanceof Array) {
                        tempFile = (File)((Array)temp).get(tmpFileIndex);
                    }
                    final String tempFilePath = tempFile.getAbsolutePath();
                    serverFilePath = serverFile.getPath();
                    if (disallowEmptyFileUpload) {
                        Boolean zeroLength;
                        final File tmpFile = new File(tempFilePath);
                        try {
                            zeroLength = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return tmpFile.length() == 0L;
                                }
                            });
                        }
                        catch (PrivilegedActionException ex) {
                            zeroLength = tmpFile.length() == 0L;
                        }
                        if (zeroLength.booleanValue()) {
                            throw new EmptyFileUploadException(fileName, clientName, clientExt);
                        }
                    }
                    if (strict) {
                        if (block != null && block.length() >= 2) {
                            mimeType = FileUtils.getMimeType(tempFilePath, true, serverFileName);
                            Boolean result = FileUtils.matchFileTypeStrict("block", mimeType, block, true, clientExt);
                            if (result == null) {
                                throw new NoFileExtensionFileUploadsBlockedException();
                            }
                            if (result.booleanValue()) {
                                throw new BlockedUploadTypeException(block, mimeType.trim(), clientName, clientExt);
                            }
                        }
                        if (accept != null && accept.length() >= 2) {
                            mimeType = FileUtils.getMimeType(tempFilePath, true, serverFileName);
                            if (FileUtils.matchFileTypeStrict("accept", mimeType, accept) == Boolean.FALSE) {
                                throw new InvalidUploadTypeException(accept, mimeType.trim(), clientName, clientExt);
                            }
                            FileUtils.matchExtensions(accept, clientExt, acceptExtensions, false);
                        }
                    }
                    if (skip) {
                        overWrite = false;
                        wasSaved = false;
                        continue;
                    }
                    if (!serverFile.exists() && !serverFile.getParentFile().exists()) {
                        throw new InvalidDestinationException(serverFilePath);
                    }
                    try {
                        final String sfPath = serverFilePath;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                FileUtils.copy(tempFilePath, sfPath);
                                return null;
                            }
                        });
                        wasSaved = true;
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        Exception ex = pae.getException();
                        LoggingService ls = ServiceFactory.getLoggingService();
                        if (!(ex instanceof IOException)) continue;
                        throw new FileUploadException(ex, clientName, clientExt, false);
                    }
                }
                throw new FormFileNotFoundException(filefield);
            }
        }
        if (!bFoundFile) {
            throw new FormFileNotFoundException(filefield);
        }
        String dot = "";
        if (clientExt.length() > 0) {
            dot = ".";
        }
        long lastModified = serverFile.lastModified();
        long fileLength = serverFile.length();
        Struct result = new Struct();
        result.put("ATTEMPTEDSERVERFILE", (Object)attemptedServerFileName);
        result.put("CLIENTDIRECTORY", (Object)clientPath);
        result.put("CLIENTFILE", (Object)(clientName + dot + clientExt));
        result.put("CLIENTFILEEXT", (Object)clientExt);
        result.put("CLIENTFILENAME", (Object)clientName);
        if (mimeType.contains("/")) {
            result.put("CONTENTSUBTYPE", (Object)mimeType.substring(mimeType.lastIndexOf(47) + 1));
        } else {
            result.put("CONTENTSUBTYPE", (Object)mimeType);
        }
        if (mimeType.contains("/")) {
            result.put("CONTENTTYPE", (Object)mimeType.substring(0, mimeType.indexOf("/")));
        } else {
            result.put("CONTENTTYPE", (Object)mimeType);
        }
        result.put("FILEEXISTED", (Object)(fileExisted ? Boolean.TRUE : Boolean.FALSE));
        result.put("FILESIZE", (Object)new Long(fileLength));
        result.put("FILEWASAPPENDED", (Object)Boolean.FALSE);
        result.put("FILEWASOVERWRITTEN", (Object)(overWrite ? Boolean.TRUE : Boolean.FALSE));
        result.put("FILEWASRENAMED", (Object)(makeUnique ? Boolean.TRUE : Boolean.FALSE));
        result.put("FILEWASSAVED", (Object)(wasSaved ? Boolean.TRUE : Boolean.FALSE));
        result.put("OLDFILESIZE", (Object)new Long(fileLength));
        result.put("DATELASTACCESSED", (Object)new OleDate(lastModified));
        result.put("SERVERDIRECTORY", (Object)serverDirectory);
        result.put("SERVERFILE", (Object)serverFileName);
        result.put("SERVERFILEEXT", (Object)serverExt);
        if (serverFileName.lastIndexOf(".") > -1) {
            result.put("SERVERFILENAME", (Object)serverFileName.substring(0, serverFileName.lastIndexOf(".")));
        } else {
            result.put("SERVERFILENAME", (Object)serverFileName);
        }
        result.put("TIMECREATED", (Object)new OleDateTime(lastModified));
        result.put("TIMELASTMODIFIED", (Object)new OleDateTime(lastModified));
        return result;
    }

    private static void checkisBlocked(String clientExt) {
        if (clientExt == null || clientExt.trim().length() == 0) {
            throw new EmptyFileExtensionException();
        }
        CharSequence[] fileExts = FileUtils.getExtensionsToBlock();
        if (fileExts != null) {
            for (String string : fileExts) {
                if (string.equals(WILDCARD)) {
                    throw new AllFileUploadsBlockedException();
                }
                if (string.equalsIgnoreCase(NO_EXTENSION) && clientExt.isEmpty()) {
                    throw new NoFileExtensionFileUploadsBlockedException();
                }
                if (!string.equalsIgnoreCase(clientExt)) continue;
                throw new BlockedUploadTypeException(String.join((CharSequence)",", fileExts), clientExt);
            }
        }
    }

    private static String[] getExtensionsToBlock() {
        ApplicationSettings appSettings = FusionContext.getApplicationSettings();
        String allowedExtraFileExts = null;
        allowedExtraFileExts = appSettings != null ? appSettings.getBlockedExtForFileUpload() : ServiceFactory.getRuntimeService().getBlockedExtForFileUpload();
        if (allowedExtraFileExts != null && !allowedExtraFileExts.equals("")) {
            return allowedExtraFileExts.split(",");
        }
        return null;
    }

    public static void move(final String source, final String destination) {
        final File s = VFSFileFactory.getFileObject(source);
        if (System.getSecurityManager() == null) {
            if (!s.exists()) {
                throw new FileTag.InvalidSourceException(source);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!s.exists()) {
                        throw new FileTag.InvalidSourceException(source);
                    }
                    return null;
                }
            });
        }
        final File new_file = FileUtils.determineDest(destination, s.getParent(), s.getName());
        if (System.getSecurityManager() == null) {
            if (!new_file.canWrite() && new_file.exists()) {
                throw new InvalidDestinationException(destination);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!new_file.canWrite() && new_file.exists()) {
                        throw new InvalidDestinationException(destination);
                    }
                    return null;
                }
            });
        }
        if (!source.equalsIgnoreCase(destination) && !s.renameTo(new_file)) {
            FileUtils.delete(new_file);
            if (!s.renameTo(new_file)) {
                try {
                    FileUtils.copyFile(s.getCanonicalPath(), new_file.getCanonicalPath());
                    FileUtils.delete(s);
                }
                catch (IOException e) {
                    throw new FileTag.MultipleFileOperationException("moving a file to another filesystem ", (Throwable)e, source, destination);
                }
            }
        }
    }

    public static String getMimeType(String filepath, boolean strict) throws IOException {
        return FileUtils.getMimeType(filepath, strict, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(String filepath, boolean strict, String orgPath) throws IOException {
        String mimetype = null;
        File file = VFSFileFactory.getFileObject(filepath);
        if (strict) {
            Metadata data = new Metadata();
            if (orgPath == null || orgPath != null && orgPath.equals("")) {
                data.set("resourceName", file.getName());
            } else {
                data.set("resourceName", orgPath);
            }
            MediaType mtype = null;
            try (BufferedInputStream inputStream = null;){
                inputStream = new BufferedInputStream(VFSFileFactory.getInputStream(file));
                if (mimeTypes == null) {
                    FileUtils.loadMimes();
                }
                mtype = mimeTypes.detect((InputStream)inputStream, data);
            }
            mimetype = mtype.toString();
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException(filepath);
            }
            if (mimeTypes == null) {
                FileUtils.loadMimes();
            }
            mimetype = mimeTypes.getMimeType(file.getName()).getName();
        }
        return mimetype;
    }

    public static void delete(String file) {
        File f = VFSFileFactory.getFileObject(file);
        if (!f.canWrite()) {
            if (!f.exists()) {
                throw new FileDoesNotExistException("delete", file);
            }
            throw new FileTag.DirFileIsReadOnlyException(f.getAbsolutePath(), "Delete", "Source");
        }
        FileUtils.delete(f);
    }

    public static String readFile(String file, String charset) {
        StringBuilder builder;
        char[] buf = new char[1024];
        File f = VFSFileFactory.getFileObject(file);
        Reader in = null;
        try {
            int count;
            builder = new StringBuilder((int)f.length());
            in = charset == null ? new BOMReader(new BufferedInputStream(VFSFileFactory.getInputStream(file)), DEFAULT_CHARSET, true) : new BOMReader(new BufferedInputStream(VFSFileFactory.getInputStream(file)), charset, false);
            while ((count = in.read(buf)) != -1) {
                builder.append(buf, 0, count);
            }
        }
        catch (NegativeArraySizeException ex) {
            throw new RuntimeException("An error occured while reading large file.");
        }
        catch (CharConversionException cce) {
            throw new FileCharConversionException(file, charset);
        }
        catch (IOException ioe) {
            throw new FileTag.SingleFileOperationException("read", ioe, file);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new FileReadException(file, ex);
            }
        }
        return builder.toString();
    }

    public static byte[] readBinaryFile(String file) {
        byte[] buffer = new byte[8192];
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int read;
            in = VFSFileFactory.getInputStream(file);
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new FileTag.SingleFileOperationException("readBinary", e, file);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    public static void writeFile(String file, Object content, String charset) {
        charset = charset == null ? DEFAULT_CHARSET : charset;
        OutputStream fos = null;
        try {
            fos = VFSFileFactory.getOutputStream(file);
            byte[] bytes = content instanceof byte[] ? (byte[])content : Cast._String(content).getBytes(charset);
            fos.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new FileStreamWrapper.GeneralIOException("write", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeFile(String file, Object content, String charset, boolean addNewLine) {
        block25: {
            charset = charset == null ? DEFAULT_CHARSET : charset;
            byte[] bytes = null;
            if (content instanceof byte[]) {
                bytes = (byte[])content;
            }
            if (bytes == null) {
                try (OutputStream fos = VFSFileFactory.getOutputStream(file, false);
                     PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fos, charset)));){
                    if (addNewLine) {
                        out.println(Cast._String(content));
                    } else {
                        out.print(Cast._String(content));
                    }
                    break block25;
                }
                catch (IOException e) {
                    throw new FileStreamWrapper.GeneralIOException("write", e);
                }
            }
            try (OutputStream fos = VFSFileFactory.getOutputStream(file);){
                fos.write(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new FileStreamWrapper.GeneralIOException("write", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(String file, Object content, boolean addnewline, String charset) throws IOException {
        charset = charset == null ? DEFAULT_CHARSET : charset;
        PrintWriter out = null;
        OutputStream os = null;
        byte[] byteArray = null;
        if (content instanceof byte[]) {
            byteArray = (byte[])content;
        } else if (charset.equalsIgnoreCase("utf-16")) {
            Object contentString = content.toString();
            String lineSeparator = addnewline ? LINE_SEPARATOR : "";
            contentString = (String)contentString + lineSeparator;
            byteArray = ((String)contentString).getBytes(charset);
        }
        try {
            if (byteArray == null) {
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream(file, true), charset)));
                if (addnewline) {
                    out.println(content.toString());
                } else {
                    out.print(content.toString());
                }
            } else {
                os = VFSFileFactory.getOutputStream(file, true);
                if (charset.equalsIgnoreCase("utf-16")) {
                    os.write(byteArray, 2, byteArray.length - 2);
                } else {
                    os.write(byteArray);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static void setFileAttributes(String file, String attributes) {
        FileUtils.setFileAttributes(VFSFileFactory.getFileObject(file), attributes);
    }

    public static boolean setFileAttributes(File file, String attributes) {
        if (attributes != null) {
            if (attributes.trim().toUpperCase().equals("READONLY")) {
                file.setReadOnly();
            } else {
                try {
                    FileUtils.setWindowsFileAttribs(file.getAbsolutePath(), attributes);
                }
                catch (IOException e) {
                    throw new CouldNotSetFileAttributeException(file.getAbsolutePath(), e);
                }
            }
            return true;
        }
        return false;
    }

    public static void setUnixAccessMode(String path, int mode) {
        try {
            FileUtils.setUnixModes(path, mode);
        }
        catch (IOException e) {
            throw new CouldNotSetFileAttributeException(path, e);
        }
    }

    public static void copyDirectory(boolean recurse, Object filter, String destFilePath, String sourceFilePath) {
        if (sourceFilePath.equalsIgnoreCase(destFilePath)) {
            throw new FileTag.SourceEqualsDestinationException(sourceFilePath);
        }
        File[] fileArr = FileUtils.listFiles(sourceFilePath, false, filter, null, true);
        if (fileArr != null) {
            for (int i = 0; i < fileArr.length; ++i) {
                File tempFile;
                if (fileArr[i].isDirectory()) {
                    if (!recurse) continue;
                    tempFile = VFSFileFactory.getFileObject(destFilePath, fileArr[i].getName());
                    if (filter == null && !VFSFileFactory.exists(tempFile)) {
                        tempFile.mkdir();
                    }
                    FileUtils.copyDirectory(recurse, filter, tempFile.getPath(), fileArr[i].getPath());
                    continue;
                }
                try {
                    tempFile = VFSFileFactory.getFileObject(destFilePath);
                    if (filter != null && !VFSFileFactory.exists(tempFile)) {
                        tempFile.mkdirs();
                    }
                    FileUtils.copyFile(fileArr[i], destFilePath);
                    continue;
                }
                catch (IOException e) {
                    throw new FileCopyException(fileArr[i].getPath(), destFilePath, e);
                }
            }
        }
    }

    static void copyFile(String source, String dest) throws IOException, FileNotFoundException {
        File s = VFSFileFactory.getFileObject(source);
        FileUtils.copyFile(s, dest);
    }

    public static void copyFile(File s, String dest) throws IOException, FileNotFoundException {
        File new_file = FileUtils.determineDest(dest, s.getParent(), s.getName());
        if (new_file instanceof VFile) {
            VFile vFile = (VFile)new_file;
            StoreService storeService = ServiceFactory.getStoreService(false);
            if (storeService != null && storeService.isInstanceOfS3FileObject(vFile.getFileObject())) {
                storeService.copyFile(s, vFile);
                return;
            }
            RuntimeService runtime = ServiceFactory.getRuntimeService();
            String applicationName = FusionContext.getCurrent().getApplicationName();
            if (VFSUtils.isVFSEnabled(applicationName)) {
                long usedSize = VFSUtils.getUsedSize(applicationName);
                FileSystemOptions fso = VFSFileSystemOptionFactory.getRAMFileSystemOptions();
                if (fso != null) {
                    int allowedSize = ApplicationRamFileSystemConfigBuilder.getInstance().getMaxSize(fso);
                    if (s.length() + usedSize > (long)allowedSize) {
                        throw new VFSFileSystemOptionFactory.ApplicationInMemoryLimitException(allowedSize / 0x100000);
                    }
                }
            }
        }
        if (s instanceof VFile || new_file instanceof VFile) {
            FileUtils.bufferCopy(s, new_file);
        } else {
            try {
                FileUtils.nioCopy(s, new_file);
            }
            catch (FileSystemException e) {
                FileUtils.bufferCopy(s, new_file);
            }
        }
        new_file.setLastModified(s.lastModified());
    }

    private static void nioCopy(File s, File new_file) throws IOException {
        Files.copy(s.toPath(), new_file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bufferCopy(File s, File new_file) throws java.io.FileNotFoundException, IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(VFSFileFactory.getInputStream(s));
            out = new BufferedOutputStream(VFSFileFactory.getOutputStream(new_file.getAbsolutePath()));
            while ((read = in.read(buffer, 0, 8192)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
            }
            ((BufferedOutputStream)out).flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bufferCopy(InputStream in, File new_file) throws java.io.FileNotFoundException, IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(VFSFileFactory.getOutputStream(new_file.getAbsolutePath()));
            while ((read = in.read(buffer, 0, 8192)) != -1) {
                out.write(buffer, 0, read);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    static File determineDest(String destStr, String sourceDir, String sourceName) {
        File new_file;
        final File dest = VFSFileFactory.getFileObject(destStr);
        boolean isDir = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return dest.isDirectory();
            }
        });
        if (!isDir && destStr.endsWith("/")) {
            destStr = destStr.substring(0, destStr.length() - 1);
        }
        if (isDir) {
            new_file = VFSFileFactory.getFileObject(dest, sourceName);
        } else if (dest.getParent() == null) {
            new_file = VFSFileFactory.getFileObject(sourceDir, destStr);
        } else if (!destStr.endsWith("/") && !destStr.endsWith("\\")) {
            new_file = VFSFileFactory.getFileObject(destStr);
        } else {
            throw new InvalidTagAttributeException("CFFILE", "destination", destStr);
        }
        return new_file;
    }

    private static String getDefaultCharset() {
        String fileEncoding = RuntimeService.defaultFileCharset;
        if (fileEncoding.equals("Cp1252")) {
            fileEncoding = "ISO8859_1";
        }
        return fileEncoding;
    }

    public static boolean setUnixModes(String path, int modeString) throws IOException {
        if (modeString == -1) {
            return false;
        }
        if (SystemInfo.isWindows()) {
            return false;
        }
        if (String.valueOf(modeString).trim().length() == 0) {
            return false;
        }
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        final String[] execArg = new String[]{"chmod", String.valueOf(modeString), path};
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (SystemInfo.isAIX()) {
                        return Runtime.getRuntime().exec(execArg, new String[0]);
                    }
                    return FileUtils.exec(execArg, true);
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            Exception e = ex.getException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (IOException)e;
        }
    }

    protected static void setWindowsFileAttribs(String path, String attribString) throws IOException, InvalidFileAttributeException {
        if (!SystemInfo.isWindows()) {
            return;
        }
        if (attribString == null || attribString.trim().length() == 0) {
            return;
        }
        if (path == null || path.trim().length() == 0) {
            return;
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("attrib");
        if (attribString.toUpperCase().indexOf("READONLY") > -1) {
            cmdList.add("+R");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-R");
        }
        if (attribString.toUpperCase().indexOf("HIDDEN") > -1) {
            cmdList.add("+H");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-H");
        }
        if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-S");
        }
        if (attribString.toUpperCase().indexOf("ARCHIVE") > -1) {
            cmdList.add("+A");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-A");
        }
        if (cmdList.size() > 1) {
            if (!cmdList.contains("+A") && !cmdList.contains("-A")) {
                cmdList.add("-A");
            }
            if (!cmdList.contains("+R") && !cmdList.contains("-R")) {
                cmdList.add("-R");
            }
            if (!cmdList.contains("+H") && !cmdList.contains("-H")) {
                cmdList.add("-H");
            }
            if (!cmdList.contains("+S") && !cmdList.contains("-S")) {
                cmdList.add("-S");
            }
        }
        if (cmdList.size() == 1 && attribString.length() >= 1) {
            throw new InvalidFileAttributeException(attribString);
        }
        cmdList.add(path);
        final String[] execArg = cmdList.toArray(new String[cmdList.size()]);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileUtils.exec(execArg, true);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception e = ex.getException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (IOException)e;
        }
    }

    private static Process exec(String[] command, boolean wait) {
        Process p;
        try {
            p = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            return null;
        }
        if (wait) {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return p;
    }

    protected static File uniqueFile(File dir, String fname, String ext) {
        String parentDir = !dir.isFile() ? dir.getPath() : dir.getParent();
        String extSeparator = ".";
        if (ext.trim().length() > 0 && fname.endsWith(ext)) {
            fname = fname.substring(0, fname.indexOf("." + ext));
        }
        if (ext.trim().length() == 0) {
            extSeparator = "";
        }
        File f = VFSFileFactory.getFileObject(parentDir, fname + extSeparator + ext);
        int num = 0;
        while (f.exists()) {
            f = VFSFileFactory.getFileObject(parentDir, fname + ++num + extSeparator + ext);
        }
        return f;
    }

    public static void verifyFile(String path) {
        if (path.trim().length() == 0) {
            throw new FileNotFoundException(path);
        }
    }

    public static void createDestination(String path) {
        FileUtils.verifyFile(path);
        File dir = VFSFileFactory.getFileObject(path);
        if (!VFSFileFactory.exists(dir)) {
            if (!dir.mkdirs()) {
                throw new CannotCreateDirectoryException(path);
            }
        } else if (dir.isFile()) {
            throw new DirectoryIsFileException(path);
        }
    }

    public static void setLastModified(String filepath, Date date) {
        File file = VFSFileFactory.getFileObject(filepath);
        if (!file.exists()) {
            throw new FileNotFoundException(filepath);
        }
        if (date == null) {
            throw new CFLocaleBase.InvalidDateTimeException("");
        }
        file.setLastModified(date.getTime());
    }

    public static String getCanonicalPath(String filePath, boolean includeEndFileSepIfGiven) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!path.isAbsolute()) {
                throw new InvalidPathException(filePath);
            }
            boolean addFilePathSepAtEnd = false;
            if (includeEndFileSepIfGiven && filePath.endsWith(File.separator)) {
                addFilePathSepAtEnd = true;
            }
            File file = new File(filePath);
            String canonPath = file.getCanonicalPath();
            if (addFilePathSepAtEnd) {
                return canonPath + File.pathSeparator;
            }
            return canonPath;
        }
        catch (IOException | java.nio.file.InvalidPathException e) {
            throw new InvalidPathException(filePath);
        }
    }

    public static Map getFileMetadata(String fileFullPath) {
        File file = VFSFileFactory.getFileObject(fileFullPath);
        boolean canRead = file.canRead();
        if (!canRead && !file.exists()) {
            throw new FileNotFoundException(fileFullPath);
        }
        Struct map = new Struct();
        map.put("name", (Object)file.getName());
        map.put("path", (Object)file.getAbsolutePath());
        map.put("parent", (Object)file.getParent());
        map.put("type", (Object)(file.isDirectory() ? "directory" : TYPE_FILE));
        map.put("size", (Object)Long.toString(file.length()));
        map.put("lastmodified", (Object)new OleDateTime(file.lastModified()));
        map.put("canRead", (Object)canRead);
        map.put("canWrite", (Object)file.canWrite());
        map.put("isHidden", (Object)file.isHidden());
        return map;
    }

    public static byte[] writeObjectToFile(String filePath, Object instance) {
        byte[] binaryObj = null;
        ByteArrayOutputStream byteOS = null;
        OutputStream fos = null;
        try {
            byteOS = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteOS);
            oos.writeObject(instance);
            binaryObj = byteOS.toByteArray();
            oos.close();
            if (filePath != null) {
                fos = VFSFileFactory.getOutputStream(filePath);
                fos.write(binaryObj);
            }
        }
        catch (NotSerializableException e) {
            throw new SerializationException(e);
        }
        catch (IOException e) {
            throw new FileStreamWrapper.GeneralIOException("ObjectSave", e);
        }
        finally {
            try {
                if (byteOS != null) {
                    byteOS.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return binaryObj;
    }

    public static Object loadInstance(Object instance, PageContext pageContext) {
        Object obj;
        block17: {
            InputStream fis = null;
            ByteArrayInputStream byteIns = null;
            ObjectInputStream ois = null;
            obj = null;
            String filePath = null;
            try {
                if (instance instanceof String) {
                    filePath = (String)instance;
                    filePath = Utils.getFileFullPath(filePath, pageContext, true);
                    fis = VFSFileFactory.getInputStream(filePath);
                    ois = new CustomObjectInputStream(fis);
                    obj = ois.readObject();
                    break block17;
                }
                if (instance instanceof byte[]) {
                    byteIns = new ByteArrayInputStream((byte[])instance);
                    ois = new CustomObjectInputStream(byteIns);
                    obj = ois.readObject();
                    break block17;
                }
                throw new ObjectFormatException();
            }
            catch (ClassNotFoundException e) {
                throw new FileReadException(e.getMessage(), e);
            }
            catch (java.io.FileNotFoundException e) {
                throw new FileNotFoundException(instance.toString());
            }
            catch (StreamCorruptedException e) {
                throw new CorruptStreamException(instance.toString());
            }
            catch (IOException e) {
                throw new FileStreamWrapper.GeneralIOException("ObjectLoad", e);
            }
            finally {
                try {
                    if (byteIns != null) {
                        byteIns.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return obj;
    }

    private static Boolean matchFileType(String accept, String clientExt, String mimeType) {
        boolean passes = false;
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String thisTok = st.nextToken().trim();
            if (thisTok.startsWith(".")) {
                String ext = thisTok.substring(1, thisTok.length());
                passes = ext.equalsIgnoreCase(clientExt);
            } else {
                if (thisTok.equalsIgnoreCase(NO_EXTENSION) && clientExt.isEmpty()) {
                    return null;
                }
                passes = MimeTypeUtils.canAccept(thisTok, mimeType);
            }
            if (!passes) continue;
            break;
        }
        return passes;
    }

    private static void matchExtensions(String accept, String clientExt, String extensions, boolean acceptContainsExtensions) {
        if (extensions == null || extensions.length() == 0) {
            if (!acceptContainsExtensions || !FileUtils.isExtensionAccepted(accept, clientExt)) {
                FileUtils.checkisBlocked(clientExt);
            }
        } else {
            StringTokenizer st = new StringTokenizer(extensions, ",");
            while (st.hasMoreTokens()) {
                String ext;
                String thisTok = st.nextToken().trim();
                if (thisTok.equalsIgnoreCase(NO_EXTENSION) && clientExt.isEmpty()) {
                    return;
                }
                String string = ext = thisTok.startsWith(".") ? thisTok.substring(1, thisTok.length()) : thisTok;
                if (!ext.equals(WILDCARD) && !ext.equalsIgnoreCase(clientExt)) continue;
                return;
            }
            throw new InvalidUploadTypeException(extensions, clientExt);
        }
    }

    private static boolean isExtensionAccepted(String accept, String clientExt) {
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String ext;
            String thisTok = st.nextToken().trim();
            if (!(thisTok.startsWith(".") ? (ext = thisTok.substring(1, thisTok.length())).equalsIgnoreCase(clientExt) : thisTok.equalsIgnoreCase(NO_EXTENSION) && clientExt.isEmpty())) continue;
            return true;
        }
        return false;
    }

    private static Boolean matchFileTypeStrict(String type, String mimeType, String accept) throws IOException {
        return FileUtils.matchFileTypeStrict(type, mimeType, accept, false, null);
    }

    private static Boolean matchFileTypeStrict(String type, String mimeType, String accept, boolean checkExtensions, String clientExt) throws IOException {
        StringTokenizer st = new StringTokenizer(accept, ",");
        Array mimearray = new Array();
        if (st.hasMoreTokens()) {
            String thisTok;
            while (st.hasMoreTokens()) {
                thisTok = st.nextToken().trim();
                if (checkExtensions) {
                    if (thisTok.startsWith(".")) {
                        String ext = thisTok.substring(1, thisTok.length());
                        if (!ext.equalsIgnoreCase(clientExt)) continue;
                        return true;
                    }
                    if (!thisTok.equalsIgnoreCase(NO_EXTENSION) || !clientExt.isEmpty()) continue;
                    return null;
                }
                if (thisTok.indexOf("/") <= 0) continue;
                mimearray.add(thisTok);
            }
            if (mimearray.size() == 0) {
                throw new MimeTypeRequiredException("strict", "true", type);
            }
            for (int i = 0; i < mimearray.size(); ++i) {
                thisTok = (String)mimearray.get(i);
                if (!MimeTypeUtils.canAccept(thisTok, mimeType) && (!mimeType.equals("application/x-tika-msoffice") || !xtikamsoffice.contains(thisTok)) && (!mimeType.equals("application/x-tika-ooxml") || !xtikaooxml.contains(thisTok))) continue;
                return true;
            }
        } else {
            throw new MimeTypeRequiredException("strict", "true", type);
        }
        return false;
    }

    private static String getFriendlyPath(String path) {
        File f = VFSFileFactory.getFileObject(path);
        return f instanceof VFile ? ((VFile)f).getFriendlyName() : path;
    }

    static {
        xtikaooxml = Arrays.asList("application/vnd.ms-excel.addin.macroenabled.12", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slide", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        xtikamsoffice = Arrays.asList("application/vnd.ms-outlook", "application/vnd.ms-powerpoint", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slide.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12", "application/vnd.visio", "application/vnd.ms-word", "application/vnd.ms-excel");
        LINE_SEPARATOR = System.getProperty("line.separator");
        forceDelete = Boolean.getBoolean("coldfusion.files.disableforcedelete");
        disallowEmptyFileUpload = Boolean.getBoolean("coldfusion.file.upload.disallowemptyfileupload");
    }

    public static class CannotCreateDirectoryException
    extends ApplicationException {
        public String dir;

        public CannotCreateDirectoryException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class DirectoryIsFileException
    extends ApplicationException {
        public String dir;

        public DirectoryIsFileException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class InvalidDirectoryException
    extends ApplicationException {
        public String dir;

        public InvalidDirectoryException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class CannotReadDirectoryException
    extends ApplicationException {
        public String dir;

        public CannotReadDirectoryException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class InvalidFileFilterException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    private static final class MultiColumnSorter
    implements Comparator {
        Map fileAttribs = new HashMap();
        HashMap m = new HashMap();
        ArrayList l = new ArrayList();

        private MultiColumnSorter() {
        }

        public void add(String token) {
            String name;
            int index = token.indexOf(" ");
            if (index != -1) {
                name = token.substring(0, index);
                if (token.endsWith("DESC")) {
                    this.m.put(name, Boolean.FALSE);
                } else {
                    this.m.put(name, Boolean.TRUE);
                }
            } else {
                name = token;
                this.m.put(token, Boolean.TRUE);
            }
            this.l.add(name);
        }

        private boolean check() {
            boolean condn = false;
            String name = null;
            for (int i = 0; i < this.l.size(); ++i) {
                name = (String)this.l.get(i);
                if (name.equals("NAME") || name.equals("DIRECTORY")) continue;
                condn = true;
                break;
            }
            return condn;
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            int result = 0;
            int overall = 0;
            String filepath1 = null;
            String filepath2 = null;
            HashMap<String, String> fileMetadata1 = null;
            HashMap<String, String> fileMetadata2 = null;
            Object attributes1 = null;
            Object attributes2 = null;
            if (this.check()) {
                filepath1 = f1.getAbsolutePath();
                filepath2 = f2.getAbsolutePath();
                fileMetadata1 = (HashMap<String, String>)this.fileAttribs.get(filepath1);
                if (fileMetadata1 == null) {
                    fileMetadata1 = new HashMap<String, String>();
                    this.fileAttribs.put(filepath1, fileMetadata1);
                }
                if ((fileMetadata2 = (HashMap<String, String>)this.fileAttribs.get(filepath2)) == null) {
                    fileMetadata2 = new HashMap<String, String>();
                    this.fileAttribs.put(filepath2, fileMetadata2);
                }
            }
            for (int i = 0; i < this.l.size(); ++i) {
                String name = (String)this.l.get(i);
                if (!this.m.containsKey(name)) continue;
                if (name.equals("NAME")) {
                    result = f1.getName().compareToIgnoreCase(f2.getName());
                } else if (name.equals("SIZE")) {
                    Long flength1 = null;
                    Long flength2 = null;
                    value = null;
                    if (fileMetadata1 != null && (value = (String)fileMetadata1.get("SIZE")) != null) {
                        flength1 = Long.parseLong(value);
                    }
                    if (fileMetadata2 != null && (value = (String)fileMetadata2.get("SIZE")) != null) {
                        flength2 = Long.parseLong(value);
                    }
                    if (flength1 == null) {
                        flength1 = f1.length();
                        fileMetadata1.put("SIZE", flength1.toString());
                    }
                    if (flength2 == null) {
                        flength2 = f2.length();
                        fileMetadata2.put("SIZE", flength2.toString());
                    }
                    result = (diff = (long)flength1.compareTo(flength2)) == 0L ? 0 : (diff < 0L ? -1 : 1);
                } else if (name.equals("TYPE")) {
                    Boolean isDirectory1 = null;
                    Boolean isDirectory2 = null;
                    value = null;
                    if (fileMetadata1 != null && (value = (String)fileMetadata1.get("TYPE")) != null) {
                        isDirectory1 = Boolean.parseBoolean(value);
                    }
                    if (fileMetadata2 != null && (value = (String)fileMetadata2.get("TYPE")) != null) {
                        isDirectory2 = Boolean.parseBoolean(value);
                    }
                    if (isDirectory1 == null) {
                        isDirectory1 = f1.isDirectory();
                        fileMetadata1.put("TYPE", isDirectory1.toString());
                    }
                    if (isDirectory2 == null) {
                        isDirectory2 = f2.isDirectory();
                        fileMetadata2.put("TYPE", isDirectory2.toString());
                    }
                    result = isDirectory1.equals(isDirectory2) ? 0 : (isDirectory1.booleanValue() ? -1 : 1);
                } else if (name.equals("DATELASTMODIFIED")) {
                    Long lastModified1 = null;
                    Long lastModified2 = null;
                    value = null;
                    if (fileMetadata1 != null && (value = (String)fileMetadata1.get("DATELASTMODIFIED")) != null) {
                        lastModified1 = Long.parseLong(value);
                    }
                    if (fileMetadata2 != null && (value = (String)fileMetadata2.get("DATELASTMODIFIED")) != null) {
                        lastModified2 = Long.parseLong(value);
                    }
                    if (lastModified1 == null) {
                        lastModified1 = f1.lastModified();
                        fileMetadata1.put("DATELASTMODIFIED", lastModified1.toString());
                    }
                    if (lastModified2 == null) {
                        lastModified2 = f2.lastModified();
                        fileMetadata2.put("DATELASTMODIFIED", lastModified2.toString());
                    }
                    result = (diff = (long)lastModified1.compareTo(lastModified2)) > 0L ? 1 : (diff < 0L ? -1 : 0);
                } else if (name.equals("ATTRIBUTES")) {
                    String attribString1 = null;
                    String attribString2 = null;
                    value = null;
                    if (fileMetadata1 != null && (value = (String)fileMetadata1.get("ATTRIBUTES")) != null) {
                        attribString1 = value;
                    }
                    if (fileMetadata2 != null && (value = (String)fileMetadata2.get("ATTRIBUTES")) != null) {
                        attribString2 = value;
                    }
                    if (attribString1 == null) {
                        attribString1 = DirFileUtils.getFileAttribString(f1);
                        fileMetadata1.put("ATTRIBUTES", attribString1.toString());
                    }
                    if (attribString2 == null) {
                        attribString2 = DirFileUtils.getFileAttribString(f2);
                        fileMetadata2.put("ATTRIBUTES", attribString2.toString());
                    }
                    result = attribString1.compareTo(attribString2);
                } else if (name.equals("DIRECTORY")) {
                    result = f1.getParent().compareToIgnoreCase(f2.getParent());
                }
                int n = result = this.m.get(name) == Boolean.FALSE ? result * -1 : result;
                if (overall != 0) continue;
                overall = result;
            }
            return overall;
        }
    }

    public static class InvalidFileExtensionException
    extends ApplicationException {
        private String allowedExtensions;
        private String extension;

        public InvalidFileExtensionException() {
        }

        public InvalidFileExtensionException(String extension, String allowedExtensions) {
            this.extension = extension;
            this.allowedExtensions = allowedExtensions;
        }

        public InvalidFileExtensionException(String extension, String allowedExtensions, Throwable throwable) {
            this.extension = extension;
            this.allowedExtensions = allowedExtensions;
        }

        public String getAllowedExtensions() {
            return this.allowedExtensions;
        }

        public String getExtension() {
            return this.extension;
        }
    }

    public static class CouldNotDeleteFileException
    extends ApplicationException {
        private final String file;

        public CouldNotDeleteFileException(String file) {
            this.file = FileUtils.getFriendlyPath(file);
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class NonEmptyDirectoryCannotBeDeletedException
    extends ApplicationException {
        public String dir;

        public NonEmptyDirectoryCannotBeDeletedException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class KnownDeletetionException
    extends ApplicationException {
        public String file;

        KnownDeletetionException(Throwable ex, String file) {
            super(ex);
            this.file = FileUtils.getFriendlyPath(file);
        }
    }

    public static class NewDirectoryExistedException
    extends ApplicationException {
        public String dir;

        public NewDirectoryExistedException(String dir) {
            this.dir = FileUtils.getFriendlyPath(dir);
        }
    }

    public static class DirectoryCannotBeRenamed
    extends ApplicationException {
        public String dir;
        public String newdir;

        public DirectoryCannotBeRenamed(String dir, String newdir) {
            this.dir = FileUtils.getFriendlyPath(dir);
            this.newdir = FileUtils.getFriendlyPath(newdir);
        }
    }

    public static class FileCopyException
    extends ApplicationException {
        public final String source;
        public final String destination;

        public FileCopyException(String source, String destination, Throwable e) {
            super(e);
            this.source = FileUtils.getFriendlyPath(source);
            this.destination = FileUtils.getFriendlyPath(destination);
        }
    }

    public static class DestinationNotDefinedException
    extends ApplicationException {
    }

    public static class CFFileNonMultipartException
    extends ApplicationException {
        private String contentType;

        CFFileNonMultipartException(String ctype) {
            this.contentType = ctype;
        }

        public String getCType() {
            return this.contentType;
        }
    }

    public static class EmptyFileUploadException
    extends FileUploadException {
        private String file;

        EmptyFileUploadException(String file, String fileName, String fileExt) {
            super(fileName, fileExt);
            this.file = FileUtils.getFriendlyPath(file);
        }

        public String getFile() {
            return this.file;
        }

        @Override
        String getReason() {
            return FileUtils.EMPTY_FILE;
        }
    }

    public static class FileUploadException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String clientFileName;
        private String clientFileExt;
        protected boolean canSkip = true;
        private String reason = this.getReason();
        Struct struct;

        public FileUploadException() {
        }

        public FileUploadException(Throwable ex) {
            super(ex);
        }

        public FileUploadException(Throwable ex, String fileName, String fileExt, boolean canSkip) {
            super(ex);
            this.clientFileName = fileName;
            this.clientFileExt = fileExt;
            this.canSkip = canSkip;
        }

        public FileUploadException(String fileName, String fileExt, boolean canSkip) {
            this.clientFileName = fileName;
            this.clientFileExt = fileExt;
            this.canSkip = canSkip;
        }

        public FileUploadException(String fileName, String fileExt) {
            this.clientFileName = fileName;
            this.clientFileExt = fileExt;
        }

        Struct getAsStruct() {
            this.struct = new Struct();
            this.struct.put("REASON", (Object)this.reason);
            this.struct.put("DETAIL", (Object)this.getDetail());
            this.struct.put("MESSAGE", (Object)this.getMessage());
            this.struct.put("CLIENTFILE", (Object)(this.getClientFileName() + "." + this.getClientFileExt()));
            this.struct.put("CLIENTFILENAME", (Object)this.getClientFileName());
            this.struct.put("CLIENTFILEEXT", (Object)this.getClientFileExt());
            this.populateError();
            return this.struct;
        }

        protected void populateError() {
        }

        String getReason() {
            return FileUtils.FILE_UPLOAD_FAILURE;
        }

        public String getClientFileName() {
            return this.clientFileName;
        }

        public void setClientFileName(String fileName) {
            this.clientFileName = fileName;
        }

        public String getClientFileExt() {
            return this.clientFileExt;
        }

        public void setClientFileExt(String fileExtension) {
            this.clientFileExt = fileExtension;
        }

        public boolean canSkip() {
            return this.canSkip;
        }
    }

    public static class InvalidDestinationException
    extends ApplicationException {
        private String destination;

        InvalidDestinationException(String dest) {
            this.destination = FileUtils.getFriendlyPath(dest);
        }

        public String getDest() {
            return this.destination;
        }
    }

    public static class InvalidValueException
    extends ApplicationException {
        private final String type;

        InvalidValueException(String type) {
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    public static class NoFileExtensionFileUploadsBlockedException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;
    }

    public static class BlockedUploadTypeException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;
        private final String block;
        private String mimeType;

        BlockedUploadTypeException(String block, String mimeType) {
            this.block = block;
            this.mimeType = mimeType;
        }

        BlockedUploadTypeException(String block, String mimeType, String fileName, String fileExt) {
            super(block, fileExt);
            this.block = block;
            this.mimeType = mimeType;
        }

        public String getBlock() {
            return this.block;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        protected void populateError() {
            this.struct.put("BLOCK", (Object)this.getBlock());
            this.struct.put("MIMETYPE", (Object)this.getMimeType());
        }

        @Override
        String getReason() {
            return FileUtils.INVALID_FILE_TYPE;
        }
    }

    public static class InvalidUploadTypeException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;
        private String accept;
        private String mimeType;

        InvalidUploadTypeException(String accept, String mimeType) {
            this.accept = accept;
            this.mimeType = mimeType;
        }

        InvalidUploadTypeException(String accept, String mimeType, String fileName, String fileExt) {
            super(fileName, fileExt);
            this.accept = accept;
            this.mimeType = mimeType;
        }

        public String getAccept() {
            return this.accept;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        protected void populateError() {
            this.struct.put("ACCEPT", (Object)this.getAccept());
            this.struct.put("MIMETYPE", (Object)this.getMimeType());
        }

        @Override
        String getReason() {
            return FileUtils.INVALID_FILE_TYPE;
        }
    }

    public static class FileOverwriteException
    extends FileUploadException {
        private String dest;

        FileOverwriteException(String dest) {
            this.dest = FileUtils.getFriendlyPath(dest);
        }

        FileOverwriteException(String dest, String fileName, String fileExt) {
            super(fileName, fileExt);
            this.dest = FileUtils.getFriendlyPath(dest);
        }

        public String getDest() {
            return this.dest;
        }

        @Override
        protected void populateError() {
            this.struct.put("DEST", (Object)this.getDest());
        }

        @Override
        String getReason() {
            return FileUtils.FILE_EXISTS;
        }
    }

    public static class FormFileNotFoundException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;
        public static final boolean canSkip = true;
        private String fileField;

        FormFileNotFoundException(String field) {
            this.fileField = field;
        }

        FormFileNotFoundException(String field, String fileName, String fileExt) {
            super(fileName, fileExt);
            this.fileField = field;
        }

        public String getFileField() {
            return this.fileField;
        }

        @Override
        public String getMessage() {
            if (this.msg == null) {
                this.msg = this.fileField == null ? FormFileNotFoundException.getString(this, "messageNoFile", this.locale) : FormFileNotFoundException.getString(this, "message", this.locale);
            }
            return this.msg;
        }

        @Override
        protected void populateError() {
            this.struct.put("FILEFIELD", (Object)this.getFileField());
        }

        @Override
        String getReason() {
            return FileUtils.FORM_FILE_NOT_FOUND;
        }
    }

    public static class EmptyFileExtensionException
    extends ApplicationException {
    }

    public static class AllFileUploadsBlockedException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;
    }

    public static class FileNotFoundException
    extends ApplicationException {
        public final String file;

        public FileNotFoundException(String file) {
            this.file = FileUtils.getFriendlyPath(file);
        }
    }

    public static class FileDoesNotExistException
    extends ApplicationException {
        public final String action;
        public final String file;

        public FileDoesNotExistException(String action, String file) {
            this.action = action;
            this.file = FileUtils.getFriendlyPath(file);
        }
    }

    public static class FileReadException
    extends ApplicationException {
        public final String file;

        public FileReadException(String file, Throwable e) {
            super(e);
            this.file = FileUtils.getFriendlyPath(file);
        }
    }

    public static class FileCharConversionException
    extends ApplicationException {
        public final String file;
        public final String charType;

        FileCharConversionException(String file, String charType) {
            this.file = FileUtils.getFriendlyPath(file);
            this.charType = charType;
        }
    }

    public static class CouldNotSetFileAttributeException
    extends FileUploadException {
        public final String path;

        public CouldNotSetFileAttributeException(String path, Throwable e) {
            super(e);
            this.path = FileUtils.getFriendlyPath(path);
        }

        @Override
        protected void populateError() {
            this.struct.put("PATH", (Object)this.path);
        }

        @Override
        String getReason() {
            return FileUtils.FILE_ATTRIBS_NOT_SET;
        }
    }

    public static class InvalidFileAttributeException
    extends FileUploadException {
        final String attribString;

        InvalidFileAttributeException(String attribString) {
            this.attribString = attribString;
        }

        public String getAttribString() {
            return this.attribString;
        }

        @Override
        protected void populateError() {
            this.struct.put("ATTRIBSTRING", (Object)this.getAttribString());
        }

        @Override
        String getReason() {
            return FileUtils.INVALID_FILE_ATTRIBUTE;
        }
    }

    public static class InvalidPathException
    extends ApplicationException {
        private final String path;

        public InvalidPathException(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class SerializationException
    extends ApplicationException {
        public SerializationException(Throwable e) {
            super(e);
        }
    }

    public static class ObjectFormatException
    extends ApplicationException {
    }

    public static class CorruptStreamException
    extends ApplicationException {
        public final String file;

        public CorruptStreamException(String file) {
            this.file = FileUtils.getFriendlyPath(file);
        }
    }

    public static class MimeTypeRequiredException
    extends ApplicationException {
        public String required;
        public String switchAttr;
        public String switchValue;

        public MimeTypeRequiredException(String switchAttr, String switchValue, String required) {
            this.required = required.toUpperCase();
            this.switchAttr = switchAttr.toUpperCase();
            this.switchValue = switchValue.toUpperCase();
        }
    }

    public static class FileFieldNotDefinedException
    extends ApplicationException {
    }

    public static class FileGetStrictMimeTypeException
    extends ApplicationException {
        public FileGetStrictMimeTypeException(Throwable ex) {
            super(ex);
        }
    }

    public static class EndOfFileException
    extends ApplicationException {
    }

    public static class InvalidFileException
    extends ApplicationException {
        public final String file;

        public InvalidFileException(String file) {
            this.file = FileUtils.getFriendlyPath(file);
        }
    }
}

