/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.cache;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.CachingConstants;
import coldfusion.tagext.io.cache.CachingParams;
import coldfusion.tagext.lang.IncludeTag;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CacheTag
extends GenericTag
implements BodyTag,
CachingConstants {
    private static final int DEF_PORT = 80;
    private static final String HTTP_STRING = "http://";
    private static final String HTTPS_STRING = "http://";
    private static final SimpleDateFormat httpDateFormatter = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.ENGLISH);
    private String action = "SERVERCACHE";
    private String directory = null;
    private Long timespan = -1L;
    private String expireURL = null;
    private String username = null;
    private String password = null;
    private String protocol = "http://";
    private int port = 80;
    private Long idleTime = -1L;
    private Map cacheConfigmap = null;
    private String cacheid = null;
    private String cacheKey = null;
    private String region = null;
    private boolean foundCache = false;
    private String[] dependsOn = null;
    private boolean useCache = true;
    private boolean stripWhiteSpace = false;
    private Object value = null;
    private String name = null;
    private String metadata = null;
    private boolean throwOnError = false;
    private boolean useURL = false;
    private String generatedKey = null;
    private static final GenericTagPermission tp;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setUseQueryString(boolean useURL) {
        this.useURL = useURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        if ("".equals(directory = directory.trim())) {
            CacheExceptions.throwEmptyAttributeException("directory");
        }
        directory = Utils.getFileFullPath(directory.trim(), this.pageContext, true);
        File tempFile = VFSFileFactory.getFileObject(directory);
        if (!CacheTag.fileExists(directory) || tempFile.isFile()) {
            CacheExceptions.throwDirectoryNotFoundException("directory", directory);
        }
        this.directory = directory;
    }

    static boolean fileExists(final String filename) {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getFileObject(filename).exists();
        }
        Boolean bExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return VFSFileFactory.getFileObject(filename).exists();
            }
        });
        return bExists;
    }

    public long getTimespanForCache() {
        return this.timespan != null ? this.timespan : 0L;
    }

    private long getTimespanForHeader() {
        return this.timespan != null ? this.timespan : 86400L;
    }

    public void setTimespan(double days) {
        this.timespan = new Long((long)(days * 86400.0));
    }

    public long getIdleTime() {
        return this.idleTime != null ? this.idleTime : 0L;
    }

    public void setIdleTime(double days) {
        this.idleTime = new Long((long)(days * 86400.0));
    }

    public String getExpireURL() {
        return this.expireURL;
    }

    public void setExpireURL(String expireURL) {
        this.expireURL = expireURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (!"http://".equalsIgnoreCase(protocol) && !"http://".equalsIgnoreCase(protocol)) {
            CacheExceptions.throwInvalidProtocolException(protocol);
        }
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCacheid() {
        return this.cacheid;
    }

    public void setId(String cacheid) {
        if (cacheid == null) {
            CacheExceptions.throwInvalidAttributeException("ID", cacheid, null);
        }
        this.cacheid = cacheid.trim();
    }

    public String getCacheKey() {
        return this.region != null ? this.region : this.cacheKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        String[] dependencies = dependsOn.split(",");
        for (int i = 0; i < dependencies.length; ++i) {
            if (dependencies[i] != null && !"".equals(dependencies[i].trim())) {
                Object value = this.pageContext.findAttribute(dependencies[i]);
                if (value == null) continue;
                dependencies[i] = new StringBuffer().append(dependencies[i]).append("=").append(value).toString();
                continue;
            }
            CacheExceptions.throwEmptyAttributeException("dependson");
        }
        this.dependsOn = dependencies;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean getStripWhiteSpace() {
        return this.stripWhiteSpace;
    }

    public void setStripWhiteSpace(boolean stripWhiteSpace) {
        this.stripWhiteSpace = stripWhiteSpace;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    public void setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
    }

    public String getKey() {
        if (this.generatedKey == null) {
            this.generatedKey = this.generateTemplateKey();
        }
        return this.generatedKey;
    }

    private String generateTemplateKey() {
        StringBuffer stringBuffer = new StringBuffer();
        HttpServletRequest httpRequest = this.fContext.getRequest();
        if (this.id == null) {
            if (httpRequest.getRequestURL() != null) {
                stringBuffer.append(httpRequest.getRequestURL());
            } else {
                stringBuffer.append(this.protocol).append(httpRequest.getServerName()).append(":").append(this.port).append("/");
            }
            if (this.useURL && httpRequest.getQueryString() != null) {
                stringBuffer.append("_query_").append(httpRequest.getQueryString().toLowerCase());
            }
            String strHash = null;
            try {
                strHash = CFPage.Hash(this.fContext.getPagePath());
            }
            catch (IOException e) {
                strHash = null;
            }
            if (strHash != null) {
                stringBuffer.append("_pageid:").append(strHash);
            }
            if (this.hasEndTag && this.lineNo > 0) {
                stringBuffer.append("_line:").append(this.lineNo);
            }
            if (this.dependsOn != null) {
                for (int i = 0; i < this.dependsOn.length; ++i) {
                    stringBuffer.append(this.dependsOn[i]);
                }
            }
        } else {
            stringBuffer.append(this.id);
        }
        return stringBuffer.toString();
    }

    public HttpServletRequest getRequest() {
        return this.fContext.getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.fContext.getResponse();
    }

    public Map getCacheConfigmap() {
        return this.cacheConfigmap;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public JspWriter getPageWriter() {
        return this.pageContext.getOut();
    }

    public String getAppName() {
        return this.fContext.getApplicationName();
    }

    public JspWriter getOut() {
        return this.out;
    }

    @Override
    public void release() {
        this.action = "SERVERCACHE";
        this.directory = null;
        this.timespan = -1L;
        this.expireURL = null;
        this.username = null;
        this.password = null;
        this.protocol = "http://";
        this.port = 80;
        this.useCache = true;
        this.dependsOn = null;
        this.value = null;
        this.generatedKey = null;
        this.throwOnError = false;
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        if ("FLUSH".equalsIgnoreCase(this.action) && this.cacheid != null && this.throwOnError && "".equals(this.cacheid)) {
            CacheExceptions.throwInvalidAttributeException("ID", this.cacheid, null);
        }
        if (this.action == null || this.action.equalsIgnoreCase("SERVERCACHE") || this.action.equalsIgnoreCase("OPTIMAL") || this.action.equalsIgnoreCase("CACHE")) {
            if (!this.hasEndTag && this.metadata != null) {
                CacheExceptions.throwIllegalMetadataException("metadata");
            }
            boolean isIncluded = false;
            CacheTag tag = this;
            while ((tag = tag.getParent()) != null) {
                if (!(tag instanceof IncludeTag) || ((IncludeTag)((Object)tag)).getTemplate() == this.pageContext.getPage()) continue;
                isIncluded = true;
                break;
            }
            if (isIncluded && !this.hasEndTag) {
                throw new CacheExceptions.InvalidCacheTagException();
            }
        }
        if (this.cacheKey != null && this.region != null) {
            throw new CacheExceptions.InvalidAttributeCombinationException();
        }
        if (this.useCache) {
            if (this.action == null || this.action.equalsIgnoreCase("SERVERCACHE")) {
                return this.checkTemplatecache();
            }
            if (this.action.equalsIgnoreCase("OPTIMAL") || this.action.equalsIgnoreCase("CACHE")) {
                return this.checkTemplatecache();
            }
            if (this.action.equalsIgnoreCase("CLIENTCACHE")) {
                this.addHTTPHeaders();
            } else if (this.action.equalsIgnoreCase("FLUSH")) {
                CacheTagHelper.deleteFromCache(this);
                this.foundCache = true;
                return 0;
            }
        }
        if (this.action.equalsIgnoreCase("PUT")) {
            CacheTagHelper.addToObjectCache(this);
            this.foundCache = true;
            return 0;
        }
        if (this.action.equalsIgnoreCase("GET")) {
            Object cachedObj = CacheTagHelper.getFromCache(this.cacheid, "OBJECT", "CFCACHE tag", this.cacheKey, true);
            this.pageContext.setAttribute(this.name, cachedObj);
            if (this.metadata != null) {
                if (cachedObj != null) {
                    this.pageContext.setAttribute(this.metadata, (Object)CacheTagHelper.getCacheMetadata(this.cacheid, this.cacheKey));
                } else {
                    this.pageContext.setAttribute(this.metadata, (Object)new Struct());
                }
            }
            this.foundCache = true;
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            CacheTagHelper.addToTemplateCache(this);
        }
        if (this.metadata != null) {
            this.pageContext.setAttribute(this.metadata, (Object)CacheTagHelper.getTemplateCacheMetadata(this));
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        super.doEndTag();
        if (!this.hasEndTag && !this.foundCache) {
            this.fContext.cacheConfig = new CachingParams(this.getKey(), this.getAppName(), this.getIdleTime(), this.getTimespanForCache(), this.getStripWhiteSpace(), this.directory, this.getCacheKey());
        }
        boolean skip = !"FLUSH".equalsIgnoreCase(this.action) && !"GET".equalsIgnoreCase(this.action) && !"PUT".equalsIgnoreCase(this.action);
        this.release();
        this.onTagEnd();
        if (!this.hasEndTag && this.foundCache && skip) {
            return 5;
        }
        return 6;
    }

    private int checkTemplatecache() {
        if (!CacheTagHelper.checkFromTemplateCache(this)) {
            this.foundCache = true;
            if (this.metadata != null) {
                this.pageContext.setAttribute(this.metadata, (Object)CacheTagHelper.getTemplateCacheMetadata(this));
            }
            return 0;
        }
        if (!this.hasEndTag && (this.action.equalsIgnoreCase("OPTIMAL") || this.action.equalsIgnoreCase("CACHE"))) {
            this.addHTTPHeaders();
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHTTPHeaders() {
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        OleDateTime dateTime = new OleDateTime(System.currentTimeMillis() + this.getTimespanForHeader() * 1000L);
        String dateTimeFormat = null;
        SimpleDateFormat simpleDateFormat = httpDateFormatter;
        synchronized (simpleDateFormat) {
            dateTimeFormat = httpDateFormatter.format(dateTime);
        }
        res.setHeader("Expires", dateTimeFormat);
        res.setHeader("Cache-Control", "public,max-age=" + this.getTimespanForHeader());
        res.setHeader("Pragma", "public");
    }

    static {
        httpDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        tp = new GenericTagPermission("cfcache");
    }
}

