/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io.cache.ehcache;

import coldfusion.runtime.CachedBufferedOutputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GenericResponseWrapper
extends HttpServletResponseWrapper
implements Serializable {
    private int statusCode = 200;
    private int contentLength;
    private String contentType;
    private List headers = new ArrayList();
    private List cookies = new ArrayList();
    private transient CachedBufferedOutputStream outstr;
    private transient PrintWriter writer;

    public GenericResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
        this.outstr = new CachedBufferedOutputStream((OutputStream)response.getOutputStream());
    }

    public ServletOutputStream getOutputStream() {
        return this.outstr;
    }

    public boolean isOutputAutoFlushed() {
        return this.outstr.isAutoFlushed();
    }

    public void setStatus(int code) {
        this.statusCode = code;
        super.setStatus(code);
    }

    public void sendError(int i, String string) throws IOException {
        this.statusCode = i;
        super.sendError(i, string);
    }

    public void sendError(int i) throws IOException {
        this.statusCode = i;
        super.sendError(i);
    }

    public void sendRedirect(String string) throws IOException {
        this.statusCode = 302;
        super.sendRedirect(string);
    }

    public void setStatus(int code, String msg) {
        this.statusCode = code;
        super.setStatus(code);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.outstr), this.getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void addHeader(String name, String value) {
        String[] header = new String[]{name, value};
        this.headers.add(header);
        super.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        String[] header = new String[]{name, value};
        Iterator iter = this.headers.iterator();
        boolean present = false;
        while (iter.hasNext()) {
            String[] h = (String[])iter.next();
            if (!h[0].equalsIgnoreCase(name)) continue;
            h[1] = value;
            present = true;
            break;
        }
        if (!present) {
            this.headers.add(header);
        }
        super.setHeader(name, value);
    }

    public Collection getHeaders() {
        return this.headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        super.addCookie(cookie);
    }

    public Collection getCookies() {
        return this.cookies;
    }

    public void flushBuffer() throws IOException {
        this.flush();
        super.flushBuffer();
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.headers.clear();
        this.statusCode = 200;
        this.contentType = null;
        this.contentLength = 0;
    }

    public void resetBuffer() {
        super.resetBuffer();
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.outstr.flush();
    }

    public String encodeRedirectUrl(String s) {
        return super.encodeRedirectURL(s);
    }

    public String encodeUrl(String s) {
        return super.encodeURL(s);
    }

    public void clear() {
        this.headers = null;
        this.cookies = null;
        this.outstr.clear();
        this.outstr = null;
        this.writer = null;
    }
}

