/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.jsp.JRunTagLibraryInfo;
import coldfusion.tagext.lang.ModuleTag;
import coldfusion.util.SoftCache;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;

public class ImportedTag
extends ModuleTag {
    private String name;
    private String prefix;
    static final SoftCache canonicalCache = new SoftCache(){

        @Override
        protected Object fetch(Object key) {
            String tagroot;
            TagLibInfo tli = (TagLibInfo)key;
            if (tli.isBuiltIn && (tagroot = tli.application.getInitParameter("cftags")) != null) {
                tagroot = tli.application.getRealPath(tagroot);
                return tagroot;
            }
            File tldFile = JRunTagLibraryInfo.resolveTagLibraryURI(tli.application, tli.taglibUri, new File(tli.pageDir + tli.pageName));
            try {
                return tldFile.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
    };

    public void setName(String name, String tagLibUri, String prefix, boolean builtIn) {
        this.name = name;
        this.prefix = prefix;
        TagLibInfo tli = new TagLibInfo();
        tli.taglibUri = tagLibUri;
        String pagePath = this.fContext.getPagePath();
        Object baseDir = null;
        String pageName = null;
        String fileSeperator = null;
        fileSeperator = VFSFileFactory.checkIfVFile(pagePath) ? "/" : File.separator;
        int lastslash = pagePath.lastIndexOf(fileSeperator);
        if (lastslash != -1) {
            baseDir = pagePath.substring(0, lastslash);
            baseDir = (String)baseDir + fileSeperator;
            pageName = pagePath.substring(lastslash + 1, pagePath.length());
        }
        tli.pageDir = baseDir;
        tli.pageName = pageName;
        tli.application = this.application;
        tli.isBuiltIn = builtIn;
        Object canonicalUri = (String)canonicalCache.get(tli);
        if (!((String)canonicalUri).endsWith(File.separator)) {
            canonicalUri = (String)canonicalUri + File.separator;
        }
        String canonicalPath = (String)canonicalUri + name + ".cfm";
        super.setTemplatePath(canonicalPath);
        this.publicName = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTagPublicName() {
        if (this.getPrefix() == null) {
            return "CF" + this.name;
        }
        return "CF_" + this.name;
    }

    static class TagLibInfo {
        String taglibUri;
        String pageDir;
        String pageName;
        ServletContext application;
        boolean isBuiltIn;

        TagLibInfo() {
        }

        public int hashCode() {
            return (this.pageDir + this.taglibUri + this.isBuiltIn).hashCode();
        }

        public boolean equals(Object x) {
            if (x == this) {
                return true;
            }
            if (x instanceof TagLibInfo) {
                TagLibInfo other = (TagLibInfo)x;
                if (this.taglibUri.equals(other.taglibUri) && this.pageDir.equals(other.pageDir) && this.isBuiltIn == other.isBuiltIn) {
                    return true;
                }
            }
            return false;
        }
    }
}

