/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.MissingIncludeException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Scope;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.VariableScope;
import coldfusion.server.DebuggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.GenericTag;
import coldfusion.util.BOMReader;
import coldfusion.util.RuntimeWrapper;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFilePermission;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;

public class IncludeTag
extends GenericTag {
    private static final String CFML = ".CFML";
    private static final String CFM = ".CFM";
    private static final long serialVersionUID = 1L;
    CfJspPage targetPage;
    NeoPageContext tagPageContext;
    private boolean compileIncluded = true;
    private boolean checkCompileExt = false;
    private static String WILDCARD = "*";
    RuntimeService runtime = ServiceFactory.getRuntimeService();
    String canonicalLocation;
    private boolean runOnce = false;
    private static String webInfPath = null;

    public String getCanonicalLocation() {
        return this.canonicalLocation;
    }

    public void setTemplatePath(String canonicalPath) throws Throwable {
        this.setTemplate(canonicalPath, ((NeoPageContext)this.pageContext).getVariableScope());
    }

    protected void setTemplate(String canonicalPath, VariableScope vs) {
        this.canonicalLocation = canonicalPath;
        NeoPageContext neoContext = (NeoPageContext)this.pageContext;
        if (this.compileIncluded) {
            this.resolveCompileTemplate(canonicalPath, vs, neoContext);
        }
    }

    private void resolveCompileTemplate(String canonicalPath, VariableScope vs, NeoPageContext neoContext) throws Error {
        LocalScope locscope = neoContext.getActiveFunctionLocalScope();
        try {
            if (ServiceFactory.getSecurityService().isSandboxSecurityEnabled() && ServiceFactory.getSecurityService().isJvmSecurityEnabled()) {
                String webinf;
                boolean access_override = false;
                Iterator ctiterator = this.runtime.getCustomtags().values().iterator();
                while (ctiterator.hasNext()) {
                    String value = ctiterator.next().toString();
                    value = ((RuntimeServiceImpl)this.runtime).evaluate(value);
                    if (SystemInfo.isWindows()) {
                        value = value.replace("/", "\\");
                    }
                    if (!canonicalPath.startsWith(value)) continue;
                    access_override = true;
                }
                if (webInfPath == null && !(webinf = this.pageContext.getServletContext().getRealPath("/WEB-INF")).endsWith(File.separator)) {
                    webInfPath = webinf + File.separator;
                }
                if (!access_override && canonicalPath.startsWith(webInfPath) && (canonicalPath.startsWith(webInfPath + "exception") || canonicalPath.startsWith(webInfPath + "cftags") || canonicalPath.startsWith(webInfPath + "debug"))) {
                    access_override = true;
                }
                if (!access_override) {
                    if (VFSFileFactory.checkIfVFile(canonicalPath)) {
                        AccessController.checkPermission(new VFilePermission(canonicalPath, "read"));
                    } else {
                        AccessController.checkPermission(new FilePermission(canonicalPath, "read"));
                    }
                }
                this.targetPage = (CfJspPage)AccessController.doPrivileged(new TemplateClassLoaderPrivilege(this.application, canonicalPath, vs, locscope));
            } else {
                this.targetPage = TemplateClassLoader.newInstance(this.application, canonicalPath, vs, locscope);
            }
            this.tagPageContext = this.targetPage.initialize(neoContext, (Tag)this);
            LocalScope _localScope = neoContext.getActiveFunctionLocalScope();
            if (_localScope != null) {
                this.tagPageContext.pushNewFunctionLocalScope(_localScope);
            }
            this.propagateDefaultQueryScope(this.tagPageContext, neoContext);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeWrapper(ex);
        }
    }

    protected void propagateDefaultQueryScope(NeoPageContext tagPageContext, NeoPageContext pageContext) {
        tagPageContext.propagateDefaultQueryScope(pageContext);
    }

    @Override
    public void release() {
        super.release();
        this.compileIncluded = true;
        this.checkCompileExt = false;
        this.runOnce = false;
    }

    @Override
    public void releaseTag(boolean release) {
        this.releaseTargetPage(release);
        if (release) {
            super.releaseTag(true);
        } else if (!this.isCacheVarScope()) {
            super.releaseTag(false);
        }
    }

    private void releaseTargetPage(boolean release) {
        if (this.targetPage != null) {
            this.targetPage.release(release);
            this.tagPageContext = null;
            this.targetPage = null;
        }
    }

    public void releaseTagWithoutReset() {
        this.releaseTargetPage(false);
        super.releaseTag(true);
    }

    @Override
    public void releaseTag() {
        this.releaseTag(true);
    }

    public void setTemplate(String template) {
        LocalScope threadLocalScope;
        template = template.replace('\u0000', ' ');
        String fsTemplate = this.fileSystemPath(template);
        File includeCanonicalFile = null;
        includeCanonicalFile = System.getSecurityManager() == null ? this.runtime.resolveTemplatePath(fsTemplate) : (File)AccessController.doPrivileged(new ResolveTemplatePathPrivilege(this.runtime, fsTemplate));
        if (includeCanonicalFile == null) {
            if (this.calledName != null) {
                throw new NoSuchIncludeTemplateException(template, this.calledName);
            }
            throw new NoSuchIncludeTemplateException(template, "CFINCLUDE");
        }
        if (includeCanonicalFile != null) {
            try {
                this.checkCompileExt = true;
                this.checkForType(template, includeCanonicalFile);
            }
            catch (InvalidIncludeTemplateException e) {
                if (this.calledName != null) {
                    e.setTagName(this.calledName);
                } else {
                    e.setTagName("CFINCLUDE");
                }
                throw e;
            }
        }
        NeoPageContext neoContext = (NeoPageContext)this.pageContext;
        VariableScope vs = neoContext.getVariableScope();
        this.setTemplate(includeCanonicalFile.getPath(), vs);
        if (!this.compileIncluded) {
            return;
        }
        Scope threadAttributeScope = neoContext.getThreadAttributeScope();
        if (threadAttributeScope != null) {
            this.tagPageContext.setThreadAttributeScope(threadAttributeScope);
        }
        if ((threadLocalScope = neoContext.getThreadLocalScope()) != null) {
            this.tagPageContext.setThreadLocalScope(threadLocalScope);
        }
    }

    protected void checkForType(String template, File includeCanonicalFile) {
        String fileName = includeCanonicalFile.getName().toUpperCase();
        if (!fileName.endsWith(CFM) && !fileName.endsWith(CFML)) {
            if (this.checkCompileExt) {
                String[] allowedExtraExtensions = this.getCompileExtForInclude();
                if (allowedExtraExtensions != null) {
                    for (String ext : allowedExtraExtensions) {
                        if (!ext.equals(WILDCARD) && !fileName.endsWith("." + ext)) continue;
                        this.compileIncluded = true;
                        return;
                    }
                }
                this.compileIncluded = false;
            } else {
                throw new InvalidIncludeTemplateException(template);
            }
        }
    }

    public String[] getCompileExtForInclude() {
        ApplicationSettings appSettings = FusionContext.getApplicationSettings();
        String allowedExtraFileExts = null;
        allowedExtraFileExts = appSettings != null ? appSettings.getCompileExtForInclude() : ServiceFactory.getRuntimeService().getCompileExtForInclude();
        if (allowedExtraFileExts != null && !allowedExtraFileExts.equals("")) {
            return allowedExtraFileExts.split(",");
        }
        return null;
    }

    public CfJspPage getTemplate() {
        return this.targetPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspException {
        if (this.canProcessPage()) {
            DebuggingService debuggingService;
            this.getRootPageContext().addIncludedFile(this.canonicalLocation);
            long startTime = 0L;
            RequestMonitorData rmd = RequestMonitorData.getCurrent();
            if (rmd != null && rmd.getCFStack() != null && !rmd.getCFStack().isEmpty()) {
                this.onTagStart();
            }
            if ((debuggingService = ServiceFactory.getDebuggingService()) != null && debuggingService.getDebugger() != null) {
                if (debuggingService.check(1)) {
                    startTime = System.currentTimeMillis();
                }
            }
            try {
                if (this.compileIncluded) {
                    this.handlePageInvoke(startTime, debuggingService);
                } else {
                    this.addStaticTemplateContent(this.canonicalLocation, (NeoPageContext)this.pageContext);
                }
            }
            finally {
                if (debuggingService != null && debuggingService.getDebugger() != null) {
                    if (debuggingService.check(1)) {
                        String sPath = this.canonicalLocation;
                        debuggingService.getDebugger().template(sPath, startTime, System.currentTimeMillis());
                    }
                }
                if (rmd != null && rmd.getCFStack() != null && !rmd.getCFStack().isEmpty()) {
                    this.onTagEnd();
                }
            }
        }
        return 0;
    }

    protected void intializeWhitespaceManagementSettings() {
        block3: {
            try {
                if (this.tagPageContext != null) {
                    this.tagPageContext.pushWSManagementSetting(ServiceFactory.getRuntimeService().getWhitespace());
                }
            }
            catch (Exception ex) {
                if (this.tagPageContext == null) break block3;
                this.tagPageContext.pushWSManagementSetting(Boolean.FALSE);
            }
        }
    }

    protected void cleanupWhitespaceManagementSettings() {
        if (this.tagPageContext != null) {
            this.tagPageContext.popWSManagementSetting();
        }
    }

    protected String fileSystemPath(String path) {
        String result = File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
        return result;
    }

    public void setRunonce(boolean value) {
        this.runOnce = value;
    }

    public NeoPageContext getPageContext() {
        return this.tagPageContext;
    }

    private boolean canProcessPage() {
        return !this.runOnce || this.getRootPageContext().getIncludedFile(this.canonicalLocation) == null;
    }

    private NeoPageContext getRootPageContext() {
        if (this.getParent() != null) {
            Tag pageParent = this.getParent();
            while (pageParent.getParent() != null) {
                pageParent = pageParent.getParent();
            }
            if (pageParent != null && pageParent instanceof IncludeTag) {
                return ((IncludeTag)pageParent).getPageContext();
            }
        }
        return (NeoPageContext)this.pageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePageInvoke(long startTime, DebuggingService debuggingService) throws Error, JspException {
        try {
            block15: {
                this.intializeWhitespaceManagementSettings();
                try {
                    this.targetPage.registerUDFs();
                }
                catch (CfJspPage.DynamicDuplicateFunctionDefinitionException dupEx) {
                    if (this.runOnce) break block15;
                    throw dupEx;
                }
            }
            NeoPageContext neoContext = (NeoPageContext)this.pageContext;
            LocalScope superScope = null;
            superScope = neoContext.getSuperScope();
            if (superScope != null) {
                this.targetPage.pageContext.pushSuperScope(superScope);
            }
            try {
                this.targetPage.invoke(this.fContext);
            }
            finally {
                if (superScope != null) {
                    this.targetPage.pageContext.popSuperScope();
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (JspException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeWrapper(ex);
        }
        finally {
            this.cleanupWhitespaceManagementSettings();
        }
    }

    private void addStaticTemplateContent(String canonicalPath, NeoPageContext neoContext) {
        Reader in = null;
        try {
            int count;
            File f = null;
            if (canonicalPath != null) {
                f = VFSFileFactory.getFileObject(canonicalPath);
                if (canonicalPath.length() == 0 || !f.exists()) {
                    throw new FileNotFoundException(canonicalPath);
                }
            }
            char[] buf = new char[1024];
            StringBuffer buffer = new StringBuffer((int)f.length());
            in = new BOMReader(new BufferedInputStream(VFSFileFactory.getInputStream(canonicalPath)), RuntimeService.defaultFileCharset, true);
            while ((count = in.read(buf)) != -1) {
                buffer.append(buf, 0, count);
            }
            JspWriter out = this.pageContext.getOut();
            if (out instanceof CFOutput) {
                ((CFOutput)out).cfoutput(true);
            }
            out.write(buffer.toString());
            if (out instanceof CFOutput) {
                ((CFOutput)out).cfoutput(false);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeWrapper(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static class TemplateClassLoaderPrivilege
    implements PrivilegedExceptionAction {
        ServletContext app;
        String canonicalPath;
        VariableScope s;
        LocalScope ls;

        TemplateClassLoaderPrivilege(ServletContext app, String canonicalPath, VariableScope s, LocalScope ls) {
            this.app = app;
            this.canonicalPath = canonicalPath;
            this.s = s;
            this.ls = ls;
        }

        public Object run() throws Exception {
            return TemplateClassLoader.newInstance(this.app, this.canonicalPath, this.s, this.ls);
        }
    }

    static class ResolveTemplatePathPrivilege
    implements PrivilegedAction {
        RuntimeService runtime;
        String path;

        ResolveTemplatePathPrivilege(RuntimeService runtime, String path) {
            this.runtime = runtime;
            this.path = path;
        }

        public Object run() {
            return this.runtime.resolveTemplatePath(this.path);
        }
    }

    public static class NoSuchIncludeTemplateException
    extends MissingIncludeException {
        private static final long serialVersionUID = 1L;
        String tagName;

        public NoSuchIncludeTemplateException(String missingFileName, String tagName) {
            this.missingFileName = missingFileName;
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }
    }

    public static class InvalidIncludeTemplateException
    extends MissingIncludeException {
        private static final long serialVersionUID = 1L;
        String tagName;

        public InvalidIncludeTemplateException(String missingFileName) {
            this.missingFileName = missingFileName;
        }

        public InvalidIncludeTemplateException(String missingFileName, String tagName) {
            this.missingFileName = missingFileName;
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }
    }

    public class FileNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String file;

        FileNotFoundException(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    static class ResolveTemplateNamePrivilege
    implements PrivilegedAction {
        RuntimeService runtime;
        PageContext pageContext;
        String name;
        String ext;

        ResolveTemplateNamePrivilege(RuntimeService runtime, PageContext pageContext, String name, String ext) {
            this.runtime = runtime;
            this.pageContext = pageContext;
            this.name = name;
            this.ext = ext;
        }

        public Object run() {
            return this.runtime.resolveTemplateName(this.name, this.ext);
        }
    }
}

