/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttribute;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.server.XmlRpcService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.util.RuntimeWrapper;
import coldfusion.xml.rpc.ServiceProxy;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvokeTag
extends GenericTag
implements BodyTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfinvoke");
    private String method;
    private Map args;
    private Object[] argsObject;
    private String resultName;
    private Object webservice;
    private Object component;
    private String username;
    private String password;
    private String proxyServer;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private int timeout = 0;
    private String port;
    private boolean refreshWSDL = false;
    private String wsdl2javaArgs;
    private String wsversion;
    private long startTime = 0L;
    private String workstation;
    private String ntlmdomain;
    private String authtype;
    protected static final String BASIC_AUTH = "BASIC";
    protected static final String NTLM_AUTH = "NTLM";
    private static Logger webserviceLog = ServiceFactory.getLoggingService().getLogger("coldfusion.webservice");

    @Override
    public void release() {
        super.release();
        this.method = null;
        this.args = null;
        this.argsObject = null;
        this.resultName = null;
        this.webservice = null;
        this.component = null;
        this.username = null;
        this.password = null;
        this.proxyServer = null;
        this.proxyPort = null;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.timeout = 0;
        this.port = null;
        this.refreshWSDL = false;
        this.wsdl2javaArgs = null;
        this.wsversion = null;
        this.startTime = 0L;
        this.workstation = null;
        this.ntlmdomain = null;
        this.authtype = null;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setReturnVariable(String s) {
        this.resultName = s;
    }

    public void setWebservice(Object s) {
        this.webservice = s;
    }

    public Object getWebservice() {
        return this.webservice;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = Integer.toString(proxyPort);
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServicePort(String p) {
        this.port = p;
    }

    public void setMethod(String s) {
        this.method = s;
    }

    public void setRefreshWSDL(boolean b) {
        this.refreshWSDL = b;
    }

    public void setWsdl2JavaArgs(String s) {
        this.wsdl2javaArgs = s;
    }

    public void setWsversion(String s) {
        this.wsversion = s;
    }

    public void setAttributecollection(Map m) {
        if (this.args == null) {
            this.args = new AttributeCollection();
        }
        this.args.putAll(m);
    }

    public void setComponent(Object c) {
        this.component = c;
    }

    public void setArgumentCollection(Object m) {
        if (m instanceof Object[]) {
            this.argsObject = (Object[])m;
        } else if (m instanceof List) {
            this.argsObject = ((List)m).toArray();
        } else {
            this.setAttributecollection((Map)m);
        }
    }

    protected void setArgument(String name, Object value) {
        if (this.args == null) {
            this.args = new AttributeCollection();
        }
        this.args.put(name, value);
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public void setAuthtype(String authtype) {
        if (!(authtype == null || authtype.equalsIgnoreCase("none") || authtype.equalsIgnoreCase(BASIC_AUTH) || authtype.equalsIgnoreCase(NTLM_AUTH))) {
            throw new UnsupportedAuthenticationTypeException();
        }
        this.authtype = authtype;
    }

    public String getNtlmdomain() {
        return this.ntlmdomain;
    }

    public void setNtlmdomain(String ntlmdomain) {
        this.ntlmdomain = ntlmdomain;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.validateParams();
        return 2;
    }

    private void validateParams() {
        if (this.authtype != null && BASIC_AUTH.equalsIgnoreCase(this.authtype) && (this.ntlmdomain != null || this.workstation != null)) {
            throw new UnsupportedAttributeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doEndTag() throws JspException {
        int n;
        CFPage page = (CFPage)this.pageContext.getPage();
        if (this.webservice == null) {
            if (this.proxyServer != null || this.proxyPort != null) {
                throw new InvalidProxyAttributeException();
            }
            if (this.timeout != 0) {
                throw new InvalidTimeoutAttributeException();
            }
        }
        try {
            Object result = null;
            if (this.method == null) {
                throw new RequiredAttributesException("CFINVOKE", "method");
            }
            if (this.args == null) {
                this.args = new AttributeCollection();
            }
            if (this.component != null) {
                String attrClass = this.component.getClass().getName();
                if (attrClass.equals("java.lang.String")) {
                    Invokable instance = ComponentProxyFactory.getProxy((String)this.component, (NeoPageContext)this.pageContext, page.importList, null);
                    result = this.argsObject == null ? page._invoke((Object)instance, this.method, this.args) : page._invoke((Object)instance, this.method, this.argsObject);
                } else {
                    if (!(this.component instanceof TemplateProxy)) {
                        throw new InvalidComponentAttributeValueException();
                    }
                    result = this.argsObject == null ? page._invoke(this.component, this.method, this.args) : page._invoke(this.component, this.method, this.argsObject);
                }
            } else if (this.webservice != null) {
                webserviceLog.info("Starting Web service request.");
                this.startTime = System.currentTimeMillis();
                this.args.remove("webservice");
                this.args.remove("method");
                this.args.remove("returnVariable");
                this.args.remove("servicePort");
                this.args.remove("refreshWSDL");
                this.args.remove("wsversion");
                this.args.remove("wsdl2javaargs");
                if (this.proxyServer != null && this.proxyPort == null) {
                    throw new MissingProxyAttributeException("proxyPort", "proxyServer");
                }
                if (this.proxyServer == null && this.proxyPort != null) {
                    throw new MissingProxyAttributeException("proxyServer", "proxyPort");
                }
                if (this.timeout < 0) {
                    throw new BadTimeoutException(this.timeout);
                }
                if (this.webservice instanceof ServiceProxy) {
                    ServiceProxy proxy = (ServiceProxy)this.webservice;
                    this.setParams(proxy);
                    result = this.argsObject == null ? page._invoke((Object)proxy, this.method, this.args) : page._invoke((Object)proxy, this.method, this.argsObject);
                    webserviceLog.info("Web service request completed {Time taken=" + (System.currentTimeMillis() - this.startTime) + " ms}");
                } else {
                    if (this.webservice == null) {
                        throw new RequiredAttributesException("CFINVOKE", "service");
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("username", this.username);
                    props.put("password", this.password);
                    props.put("timeout", new Integer(this.timeout));
                    props.put("port", this.port);
                    props.put("wsdl2javaargs", this.wsdl2javaArgs);
                    props.put("wsversion", this.wsversion);
                    props.put("proxyserver", this.proxyServer);
                    props.put("proxyport", this.proxyPort);
                    props.put("proxyuser", this.proxyUser);
                    props.put("proxypassword", this.proxyPassword);
                    props.put("authtype", this.authtype);
                    props.put("ntlmdomain", this.ntlmdomain);
                    props.put("workstation", this.workstation);
                    if (this.refreshWSDL) {
                        props.put("refreshwsdl", Boolean.TRUE);
                    }
                    webserviceLog.info("Creating Web service proxy {url='" + this.webservice.toString() + "'}");
                    XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
                    ServiceProxy proxy = xmlRpcService.getWebServiceProxy(this.webservice.toString(), props);
                    try {
                        this.setParams(proxy);
                        if (this.argsObject == null) {
                            result = page._invoke((Object)proxy, this.method, this.args);
                        }
                        result = page._invoke((Object)proxy, this.method, this.argsObject);
                    }
                    finally {
                        webserviceLog.info("Web service request completed {Time taken=" + (System.currentTimeMillis() - this.startTime) + " ms}");
                        proxy.close();
                    }
                }
            } else {
                result = this.argsObject == null ? CFPage._invokeUDF(this.pageContext.getAttribute(this.method), this.method, page, this.args) : (this.args != null ? CFPage._invokeUDF(this.pageContext.getAttribute(this.method), this.method, page, this.argsObject, this.args) : CFPage._invokeUDF(this.pageContext.getAttribute(this.method), this.method, page, this.argsObject));
            }
            if (this.resultName != null) {
                this.pageContext.setAttribute(this.resultName, result);
            }
            n = 6;
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new RuntimeWrapper(e2);
                }
            }
            catch (Throwable throwable) {
                List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("method"), Arrays.asList(this.convertUpperCase(this.method)));
                this.onTagEnd(tagAttributes);
                this.release();
                throw throwable;
            }
        }
        List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("method"), Arrays.asList(this.convertUpperCase(this.method)));
        this.onTagEnd(tagAttributes);
        this.release();
        return n;
    }

    private void setParams(ServiceProxy proxy) {
        proxy.setTimeout(this.timeout);
        if (this.username != null && this.username.length() > 0) {
            proxy.setUsername(this.username);
            proxy.setPassword(this.password);
        }
        if (this.proxyServer != null) {
            proxy.setProxyServer(this.proxyServer);
            proxy.setProxyPort(this.proxyPort);
            if (this.proxyUser != null) {
                proxy.setProxyUser(this.proxyUser);
                proxy.setProxyPassword(this.proxyPassword);
            }
        }
        if (this.authtype != null) {
            proxy.setAuthype(this.authtype);
        }
    }

    public class UnsupportedAuthenticationTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class UnsupportedAttributeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidProxyAttributeException
    extends ApplicationException {
        InvalidProxyAttributeException() {
        }
    }

    public static class InvalidTimeoutAttributeException
    extends ApplicationException {
        InvalidTimeoutAttributeException() {
        }
    }

    public static class InvalidComponentAttributeValueException
    extends ApplicationException {
        InvalidComponentAttributeValueException() {
        }
    }

    public static class MissingProxyAttributeException
    extends ApplicationException {
        private String missingAttribute;
        private String givenAttribute;

        MissingProxyAttributeException(String missingAttribute, String givenAttribute) {
            this.missingAttribute = missingAttribute;
            this.givenAttribute = givenAttribute;
        }

        public String getMissingAttribute() {
            return this.missingAttribute;
        }

        public String getGivenAttribute() {
            return this.givenAttribute;
        }
    }

    public static class BadTimeoutException
    extends ApplicationException {
        public int timeout;

        BadTimeoutException(int timeout) {
            this.timeout = timeout;
        }
    }
}

