/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.LockException;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.RWLock;
import coldfusion.tagext.GenericTag;
import coldfusion.util.WrappedException;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class LockTag
extends GenericTag
implements TryCatchFinally {
    private boolean isReadOnly;
    private boolean throwontimeout = true;
    private String lockName;
    private String lockScope;
    private boolean gotLock;
    private Object anonymousLock = null;
    private boolean isCounting = false;
    private int count = 1;
    private long timeout;

    public void setType(String strType) {
        if (strType.equalsIgnoreCase("READONLY")) {
            this.isReadOnly = true;
        } else if (strType.equalsIgnoreCase("EXCLUSIVE")) {
            this.isReadOnly = false;
        } else if (strType.equalsIgnoreCase("CONCURRENT")) {
            this.isCounting = true;
            this.isReadOnly = false;
        }
    }

    public void setThrowontimeout(boolean b) {
        this.throwontimeout = b;
    }

    public void setName(String lockName) {
        this.lockName = lockName;
    }

    public void setScope(String lockScope) {
        this.lockScope = lockScope;
    }

    public void setTimeout(int timeout) {
        this.timeout = 1000 * timeout;
    }

    public void setGeneratedLock(Object generatedLock) {
        this.anonymousLock = generatedLock;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        int result = 1;
        if (this.isCounting && this.lockName == null) {
            throw new MissingLockNameException();
        }
        try {
            if (this.lockName != null) {
                if (this.isCounting) {
                    LockManager.get().requestConcurrentLock(this.lockName, this.count, this.timeout);
                } else {
                    LockManager.get().requestNamedLock(this.lockName, this.isReadOnly, this.timeout);
                }
            } else if (this.lockScope != null) {
                LockManager.get().requestScopedLock(this.lockScope, this.pageContext, this.isReadOnly, this.timeout);
            } else if (this.anonymousLock != null) {
                if (this.isReadOnly) {
                    throw new AnonymousReadOnlyLockException();
                }
                if (this.anonymousLock instanceof RWLock) {
                    ((RWLock)this.anonymousLock).requestLock(this.isReadOnly, this.timeout);
                } else if (!((ReentrantLock)this.anonymousLock).tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException();
                }
            } else {
                throw new JspException("NAME or SCOPE must be specified.");
            }
            this.gotLock = true;
        }
        catch (InterruptedException ex) {
            this.gotLock = false;
            if (this.throwontimeout) {
                if (this.lockName != null) {
                    throw new TimeoutException(ex, this.lockName);
                }
                if (this.lockScope != null) {
                    throw new ScopedLockTimeoutException(ex, this.lockScope);
                }
                throw new AnonymousLockTimeoutException((Throwable)ex);
            }
            result = 0;
        }
        return result;
    }

    public int doEndTag() throws JspException {
        int retVal = super.doEndTag();
        this.onTagEnd();
        return retVal;
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        if (this.gotLock) {
            this.gotLock = false;
            if (this.lockName != null) {
                if (this.isCounting) {
                    LockManager.get().releaseConcurrentLock(this.lockName);
                } else {
                    LockManager.get().releaseNamedLock(this.lockName, this.isReadOnly);
                }
            } else if (this.lockScope != null) {
                LockManager.get().releaseScopedLock(this.lockScope, this.pageContext, this.isReadOnly);
            } else if (this.anonymousLock != null) {
                if (this.anonymousLock instanceof RWLock) {
                    ((RWLock)this.anonymousLock).releaseLock(this.isReadOnly);
                } else {
                    ((ReentrantLock)this.anonymousLock).unlock();
                }
            }
        }
    }

    public class MissingLockNameException
    extends LockException {
        MissingLockNameException() {
            super((String)null);
        }
    }

    public class AnonymousReadOnlyLockException
    extends LockException {
        AnonymousReadOnlyLockException() {
            super((String)null);
        }
    }

    public static class TimeoutException
    extends LockException
    implements WrappedException {
        private Throwable rootCause;

        TimeoutException(Throwable ex, String name) {
            super(name);
            this.rootCause = ex;
        }

        @Override
        public Throwable getRootCause() {
            return this.rootCause;
        }
    }

    public class ScopedLockTimeoutException
    extends TimeoutException {
        ScopedLockTimeoutException(Exception ex, String scopeName) {
            super(ex, scopeName);
        }
    }

    public class AnonymousLockTimeoutException
    extends TimeoutException {
        AnonymousLockTimeoutException(Throwable ex) {
            super(ex, "an anonymous lock");
        }
    }
}

