/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.LogService;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import jakarta.servlet.jsp.JspTagException;
import java.security.Permission;

public final class LogTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cflog");
    private String logText = null;
    private String cfLogFile = "application";
    private String userLogFile = null;
    private String logLevel = "information";
    private boolean loggingApp = true;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setText(String text) {
        this.logText = text;
    }

    public String getText() {
        return this.logText;
    }

    public void setLog(String cfLogFile) {
        this.cfLogFile = cfLogFile;
    }

    public String getLog() {
        return this.cfLogFile;
    }

    public void setFile(String userLogFile) {
        this.userLogFile = userLogFile;
    }

    public String getFile() {
        return this.userLogFile;
    }

    public void setType(String level) {
        this.logLevel = level != null ? ((level = level.toLowerCase()).equals("error") || level.equals("warning") || level.equals("fatal") ? level : "information") : "information";
    }

    public String getType() {
        return this.logLevel;
    }

    public void setApplication(boolean loggingApp) {
        this.loggingApp = loggingApp;
    }

    public boolean isApplication() {
        return this.loggingApp;
    }

    @Override
    public void release() {
        this.logText = null;
        this.cfLogFile = "application";
        this.userLogFile = null;
        this.logLevel = "information";
        this.loggingApp = true;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() throws JspTagException {
        this.onTagStart();
        Logger logger = null;
        String appName = this.getApplicationName();
        LogService logService = (LogService)ServiceFactory.getLoggingService();
        logger = this.userLogFile != null ? logService.getUserLog(this.userLogFile) : (this.cfLogFile.equalsIgnoreCase("scheduler") ? CFLogs.SCHEDULER_LOG : CFLogs.APPLICATION_LOG);
        if (logger.isLoggingEnabled()) {
            logger.applog(this.logLevel, appName, this.escapeDoubleQuotes(this.logText));
        }
        return 0;
    }

    private String getApplicationName() {
        if (!this.loggingApp) {
            return null;
        }
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (appScope != null) {
            return appScope.getName().toUpperCase();
        }
        return appName;
    }

    public String escapeDoubleQuotes(String str) {
        if (null == str) {
            return str;
        }
        boolean hasQuotes = false;
        for (char ch : str.toCharArray()) {
            if (Character.isJavaLetterOrDigit(ch) || ch != '\"') continue;
            hasQuotes = true;
            break;
        }
        if (hasQuotes) {
            str = str.replace("\"", "\"\"");
        }
        return str;
    }

    public class InvalidAttributeValueException
    extends IllegalAttributeValueException {
        public String tagName = "cflog tag";

        public InvalidAttributeValueException(String attribute, boolean func) {
            if (func) {
                this.tagName = "log function";
            }
            this.attribute = attribute.toUpperCase();
        }
    }
}

