/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.tagext.QueryLoop;
import coldfusion.tagext.io.FileUtils;
import coldfusion.tagext.io.InvalidCharsetException;
import coldfusion.util.BOMReader;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class LoopTag
extends QueryLoop {
    protected JspWriter out;
    private String filepath;
    private String index;
    private String item;
    private int from = -1;
    private int to = -1;
    private int characters;
    private String charset = null;
    private BufferedReader reader;
    private int lines = 0;
    private int noOfLines = 0;
    private String label = null;

    public void setEndrow(int end) {
        this.endrow = end;
    }

    public String getFile() {
        return this.filepath;
    }

    public void setFile(String file) {
        this.filepath = Utils.getFileFullPath(file, this.pageContext);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        if (from <= 0) {
            throw new InvalidRangeException();
        }
        this.from = from;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int to) {
        if (to <= 0) {
            throw new InvalidRangeException();
        }
        this.to = to;
    }

    public int getCharacters() {
        return this.characters;
    }

    public void setCharacters(int characters) {
        this.characters = characters;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setGroup(String s) {
        this.group = s;
    }

    public void setGroupcasesensitive(boolean b) {
        this.ignore_cases = b;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public int doStartTag() throws JspException {
        this.onTagStart();
        this.out = this.pageContext.getOut();
        this.noOfLines = 0;
        if (this.filepath != null) {
            this.validate();
            try {
                BOMReader bomReader = null;
                bomReader = this.charset == null ? new BOMReader(new BufferedInputStream(VFSFileFactory.getInputStream(this.filepath)), FileUtils.DEFAULT_CHARSET, true) : new BOMReader(new BufferedInputStream(VFSFileFactory.getInputStream(this.filepath)), this.charset, false);
                this.reader = new BufferedReader(bomReader);
                String read = null;
                if (this.characters != 0) {
                    read = this.readNext();
                } else {
                    int fromval = this.from > 0 ? this.from : 1;
                    for (int i = 0; i < fromval; ++i) {
                        read = this.readNext();
                        if (read != null || this.from <= 0) continue;
                        throw new FileUtils.EndOfFileException();
                    }
                }
                if (read != null) {
                    if (this.item != null) {
                        this.pageContext.setAttribute(this.item, (Object)read);
                        if (this.index != null) {
                            ++this.noOfLines;
                            this.pageContext.setAttribute(this.index, (Object)this.noOfLines);
                        }
                    } else if (this.index != null) {
                        this.pageContext.setAttribute(this.index, (Object)read);
                    }
                    return 1;
                }
                return 0;
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidCharsetException(this.charset);
            }
            catch (IOException e) {
                throw new FileUtils.FileReadException(this.filepath, e);
            }
        }
        this.tags = this.findAllQueryLoopTags(LoopTag.class);
        if (this.tags != null && this.tags.length != 0 && this.query == null) {
            try {
                QueryLoop tagToReset = this.findTagToReset(this.tags);
                if (tagToReset != null) {
                    this.orig_current = tagToReset.getCurrent();
                    this.setCurrent(tagToReset.getCurrent());
                }
                this.ref_value = this.tags[0].getRowSet().getObject(this.tags[0].getGroupName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.ref_value != null) {
                this.ref_value = "";
            }
        } else if (this.query != null) {
            return super.doStartTag();
        }
        return 1;
    }

    @Override
    public int doAfterBody() throws JspException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException("CFLOOP");
        }
        if (this.filepath != null) {
            String read;
            try {
                read = this.readNext();
            }
            catch (IOException e) {
                throw new FileUtils.FileReadException(this.filepath, e);
            }
            if (this.to > 0) {
                if (read != null) {
                    if (this.lines <= this.to) {
                        if (this.item != null) {
                            this.pageContext.setAttribute(this.item, (Object)read);
                            if (this.index != null) {
                                ++this.noOfLines;
                                this.pageContext.setAttribute(this.index, (Object)this.noOfLines);
                            }
                        } else if (this.index != null) {
                            this.pageContext.setAttribute(this.index, (Object)read);
                        }
                        return 1;
                    }
                    return 0;
                }
                if (this.lines == this.to) {
                    return 0;
                }
                throw new FileUtils.EndOfFileException();
            }
            if (read != null) {
                if (this.item != null) {
                    this.pageContext.setAttribute(this.item, (Object)read);
                    if (this.index != null) {
                        ++this.noOfLines;
                        this.pageContext.setAttribute(this.index, (Object)this.noOfLines);
                    }
                } else if (this.index != null) {
                    this.pageContext.setAttribute(this.index, (Object)read);
                }
                return 1;
            }
            return 0;
        }
        return this.advance();
    }

    @Override
    public int doEndTag() throws JspException {
        if (this.query != null) {
            return super.doEndTag();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void doFinally() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.doFinally();
    }

    private void validate() {
        File file = VFSFileFactory.getFileObject(this.filepath);
        if (!file.exists()) {
            throw new FileUtils.FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory() || !file.canRead()) {
            throw new FileUtils.InvalidFileException(this.filepath);
        }
        if (this.from > 0 && this.to > 0 && this.from > this.to) {
            throw new InvalidRangeException();
        }
    }

    private String readNext() throws IOException {
        if (this.characters > 0) {
            char[] chars = new char[this.characters];
            int read = this.reader.read(chars, 0, this.characters);
            if (read == -1) {
                return null;
            }
            return new String(chars, 0, read);
        }
        String read = this.reader.readLine();
        if (read != null) {
            ++this.lines;
        }
        return read;
    }

    @Override
    public void release() {
        this.out = null;
        this.filepath = null;
        this.index = null;
        this.item = null;
        this.from = -1;
        this.to = -1;
        this.characters = 0;
        this.charset = null;
        this.reader = null;
        this.lines = 0;
        this.noOfLines = 0;
        this.label = null;
        super.release();
    }

    public static class InvalidRangeException
    extends ApplicationException {
    }
}

