/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.tagext.lang.NodeNotFoundException;
import coldfusion.tagext.lang.RegistryException;
import coldfusion.util.FastHashtable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.oro.text.perl.Perl5Util;

public class RegNode
extends FastHashtable {
    private String _name = null;
    private RegNode _parent = null;
    private static String _stringOut = null;

    public RegNode(String s, RegNode n) {
        this._name = s;
        this._parent = n;
    }

    public RegNode(String s) {
        this._name = s;
    }

    public String getName() {
        return this._name;
    }

    public RegNode getParent() {
        return this._parent;
    }

    public static String popRight(String s) {
        StringTokenizer st = new StringTokenizer(s, "\\");
        String top = st.nextToken();
        if (s.length() > top.length()) {
            return s.substring(top.length() + 1);
        }
        return null;
    }

    public static String popLeft(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, "\\");
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    public synchronized void doSet(String branch, String entry, String value, String type) {
        String top = RegNode.popLeft(branch);
        if (top == null) {
            if (!type.equalsIgnoreCase("key")) {
                String t;
                if (type.equalsIgnoreCase("dword") || type.equalsIgnoreCase("REG_DWORD")) {
                    t = "REG_DWORD";
                    try {
                        int n = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        value = "0";
                    }
                } else {
                    t = "REG_SZ";
                }
                this.put(entry, (Object)new Pair(value, t));
            } else {
                Object obj = this.get(entry);
                RegNode nd = null;
                if (obj == null) {
                    nd = new RegNode(entry, this);
                    this.put(entry, (Object)nd);
                } else if (obj instanceof RegNode) {
                    nd = (RegNode)obj;
                } else {
                    nd = new RegNode(entry, this);
                    this.put(entry, (Object)nd);
                }
                if (value != null && value.length() != 0) {
                    nd.put("", (Object)new Pair(value, "REG_SZ"));
                }
            }
            return;
        }
        RegNode node = (RegNode)this.get(top);
        if (node == null) {
            RegNode nunode = new RegNode(top, this);
            this.put(top, (Object)nunode);
            nunode.doSet(RegNode.popRight(branch), entry, value, type);
        } else {
            node.doSet(RegNode.popRight(branch), entry, value, type);
        }
    }

    public Object doGet(String branch, String entry, String type) throws NodeNotFoundException {
        String top = RegNode.popLeft(branch);
        Object ret = null;
        Pair p = null;
        if (top == null) {
            Object obj = this.get(entry);
            if (obj instanceof Pair) {
                p = (Pair)this.get(entry);
                if (p.getType().equalsIgnoreCase("REG_SZ")) {
                    ret = p.getValue();
                } else if (p.getType().equalsIgnoreCase("REG_DWORD")) {
                    try {
                        ret = Integer.decode(p.getValue());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        throw new RegistryException("Invalid Value");
                    }
                } else {
                    ret = "";
                }
                return ret;
            }
            if (obj instanceof RegNode) {
                Object pobj = ((RegNode)obj).get("");
                if (pobj != null) {
                    p = (Pair)pobj;
                    ret = p.getValue();
                } else {
                    ret = "";
                }
                return ret;
            }
            throw new NodeNotFoundException("Registry Path not found: ", this.printPath() + "|" + branch);
        }
        RegNode node = (RegNode)this.get(top);
        if (node == null) {
            throw new NodeNotFoundException("Registry path not found: ", this.printPath() + "|" + branch);
        }
        return node.doGet(RegNode.popRight(branch), entry, type);
    }

    public Map doGetAll(String branch) throws NodeNotFoundException {
        String top = RegNode.popLeft(branch);
        if (top == null) {
            return this;
        }
        RegNode node = (RegNode)this.get(top);
        if (node == null) {
            throw new NodeNotFoundException("Registry path not found: ", this.printPath() + "|" + branch);
        }
        return node.doGetAll(RegNode.popRight(branch));
    }

    public synchronized void doDelete(String branch, String entry) throws NodeNotFoundException {
        String top = RegNode.popLeft(branch);
        if (top == null) {
            this.remove(entry);
        } else {
            RegNode node = (RegNode)this.get(top);
            if (node == null) {
                throw new NodeNotFoundException("Registry path not found: ", this.printPath() + "|" + branch);
            }
            node.doDelete(RegNode.popRight(branch), entry);
        }
    }

    public synchronized void doDelete(String branch) throws NodeNotFoundException {
        String top = RegNode.popLeft(branch);
        if (RegNode.popRight(branch) == null) {
            this.remove(branch);
        } else {
            RegNode node = (RegNode)this.get(top);
            if (node == null) {
                String str = new String();
                throw new NodeNotFoundException("Registry path not found: ", this.printPath() + "|" + branch);
            }
            node.doDelete(RegNode.popRight(branch));
        }
    }

    public synchronized void traverse(PrintWriter out) {
        Object obj;
        Object key;
        out.println();
        this.superParent(out);
        out.println(this.getName() + ":" + this.size());
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            key = ((Map.Entry)iter.next()).getKey();
            obj = this.get(key);
            if (!(obj instanceof Pair)) continue;
            Pair p = (Pair)obj;
            out.println(key + ":\t\t" + p.getEncodedValue() + ";\t" + p.getType());
        }
        iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            key = ((Map.Entry)iter.next()).getKey();
            obj = this.get(key);
            if (!(obj instanceof RegNode)) continue;
            ((RegNode)obj).traverse(out);
        }
    }

    private void superParent(PrintWriter out) {
        RegNode node = this.getParent();
        if (node != null) {
            node.superParent(out);
            if (node.getParent() != null) {
                out.print(node.getName() + "\\");
            }
        }
    }

    private synchronized String printPath() {
        _stringOut = new String();
        return this.superParent();
    }

    private String superParent() {
        RegNode node = this.getParent();
        if (node != null) {
            String t = node.superParent();
            if (node.getParent() != null && node.getParent() != null) {
                _stringOut = _stringOut + node.getName() + "\\";
            }
        }
        return _stringOut;
    }

    public void traverseChildren(PrintWriter out) {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Object obj = ((Map.Entry)iter.next()).getValue();
            if (!(obj instanceof RegNode)) continue;
            ((RegNode)obj).traverse(out);
        }
    }

    public static String toStorage(String s) {
        Perl5Util util = new Perl5Util();
        String sub = s;
        sub = util.substitute("s#\\\\#\\\\\\\\#g", sub);
        sub = util.substitute("s#(\n)#\\\\n#g", sub);
        return sub;
    }

    public static String fromStorage(String s) {
        Perl5Util util = new Perl5Util();
        String sub = s;
        sub = util.substitute("s#([^\\\\])\\\\n#$1\n#g", sub);
        sub = util.substitute("s#\\\\\\\\#\\\\#g", sub);
        return sub;
    }

    public class Pair {
        private String _value = null;
        private String _evalue = null;
        private String _type = null;

        public Pair(String v, String t) {
            this._value = v;
            this._evalue = RegNode.toStorage(v);
            this._type = t;
        }

        public String getValue() {
            return this._value;
        }

        public String getEncodedValue() {
            return this._evalue;
        }

        public String getType() {
            return this._type;
        }

        public String toString() {
            String tmp = this._value + "\t" + this._type;
            return tmp;
        }
    }
}

