/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.Logger;
import coldfusion.osgi.services.CronService;
import coldfusion.osgi.to.ScheduleTagTO;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IllegalDateFormatException;
import coldfusion.runtime.NeoException;
import coldfusion.scheduling.CronTabEntry;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.validation.RequiredAttributesException;
import jakarta.servlet.jsp.JspException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScheduleTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfschedule");
    public static final String SERVER = "server";
    public static final String APPLICATION = "application";
    public String action = "update";
    protected String task;
    protected String operation = "HTTPRequest";
    protected String url;
    protected String file;
    protected String requestTimeOut = "";
    protected String path;
    protected String startDate;
    protected String startTime;
    protected String endDate;
    protected String endTime;
    protected String interval;
    protected String password = "";
    protected String username = "";
    protected String proxyServer = "";
    protected String proxyUser = "";
    protected String proxyPassword = "";
    protected String port = "80";
    protected String proxyPort = "80";
    protected boolean publish = false;
    protected boolean resolveURL = false;
    protected String group;
    protected String onexception;
    protected String eventhandler;
    protected String oncomplete;
    protected String onmisfire = "";
    protected String repeat = "-1";
    protected String crontime;
    protected String priority = "5";
    protected boolean cluster = false;
    protected boolean overwrite = true;
    protected Object exclude;
    protected String retrycount = "3";
    protected String mode = "server";
    protected String result = null;
    private static final Set<String> MODESET = new HashSet<String>();
    protected ScheduleTagTO scheduleTagData;
    List<String> settersCalled = new ArrayList<String>();
    private Date lastfire;
    public static final Set MISFIRESET;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void setAction(String s) {
        this.action = s;
    }

    public String getAction() {
        return this.action;
    }

    public void setTask(String s) {
        this.task = s.trim();
    }

    public String getTask() {
        return this.task;
    }

    public void setOperation(String s) {
        this.addSetter("operation");
        this.operation = s;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setRetrycount(String s) {
        this.addSetter("retrycount");
        this.retrycount = s;
    }

    public String getRetrycount() {
        return this.retrycount;
    }

    public void setUrl(String s) {
        this.addSetter("url");
        this.url = s;
    }

    public String getUrl() {
        return this.url;
    }

    public void setFile(String s) {
        this.addSetter("file");
        this.file = s;
    }

    public String getFile() {
        return this.file;
    }

    public void setPath(String s) {
        this.addSetter("path");
        this.path = s;
    }

    public String getPath() {
        return this.path;
    }

    public void setStartDate(String s) {
        this.addSetter("startdate");
        this.startDate = s;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartTime(String s) {
        this.addSetter("starttime");
        this.startTime = s;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setEndDate(String s) {
        this.addSetter("enddate");
        this.endDate = s;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndTime(String s) {
        this.addSetter("endtime");
        this.endTime = s;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setInterval(String s) {
        this.addSetter("interval");
        this.interval = s;
    }

    private void addSetter(String setter) {
        this.settersCalled.add(setter);
    }

    public String getInterval() {
        return this.interval;
    }

    public void setPublish(boolean b) {
        this.addSetter("publish");
        this.publish = b;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setRequestTimeOut(String s) {
        this.addSetter("requesttimeout");
        this.requestTimeOut = s;
    }

    public String getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setPassword(String s) {
        this.addSetter("password");
        this.password = s;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setUsername(String s) {
        this.addSetter("username");
        this.username = s;
    }

    public String getUsername() {
        return this.username;
    }

    public void setProxyServer(String s) {
        this.addSetter("proxyserver");
        this.proxyServer = s;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyPassword(String o) {
        this.addSetter("proxypassword");
        this.proxyPassword = o;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyUser(String o) {
        this.addSetter("proxyuser");
        this.proxyUser = o;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setResolveURL(boolean b) {
        this.addSetter("resolveurl");
        this.resolveURL = b;
    }

    public boolean isResolveURL() {
        return this.resolveURL;
    }

    public void setPort(String s) {
        this.addSetter("port");
        this.port = s;
    }

    public String getPort() {
        return this.port;
    }

    public void setProxyPort(String s) {
        this.addSetter("proxyport");
        this.proxyPort = s;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group.trim();
    }

    public String getOnexception() {
        return this.onexception;
    }

    public void setOnexception(String onexception) {
        this.addSetter("onexception");
        this.onexception = onexception;
    }

    public String getEventhandler() {
        return this.eventhandler;
    }

    public void setEventhandler(String eventhandler) {
        this.addSetter("eventhandler");
        this.eventhandler = eventhandler;
    }

    public String Oncomplete() {
        return this.oncomplete;
    }

    public void setOncomplete(String onexecute) {
        this.addSetter("oncomplete");
        this.oncomplete = onexecute;
    }

    public String getOnmisfire() {
        return this.onmisfire;
    }

    public void setOnmisfire(String misfirehandle) {
        FeatureRouter.getInstance().allowFeature(EFRConstants.scheduler_new_features, null);
        this.addSetter("onmisfire");
        this.onmisfire = misfirehandle;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.addSetter("repeat");
        this.repeat = repeat;
    }

    public String getCrontime() {
        return this.crontime;
    }

    public void setCrontime(String crontime) {
        this.addSetter("crontime");
        this.crontime = crontime;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.addSetter("priority");
        this.priority = priority;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public void setOverwrite(boolean overwrite) {
        this.addSetter("overwrite");
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setCluster(boolean cluster) {
        this.addSetter("cluster");
        this.cluster = cluster;
    }

    public Object getExclude() {
        return this.exclude;
    }

    public void setExclude(Object exclude) {
        this.addSetter("exclude");
        this.exclude = exclude;
    }

    @Override
    public void release() {
        this.task = null;
        this.operation = null;
        this.url = null;
        this.file = null;
        this.path = null;
        this.startDate = null;
        this.startTime = null;
        this.endDate = null;
        this.endTime = null;
        this.interval = null;
        this.password = null;
        this.username = null;
        this.proxyServer = null;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.port = null;
        this.proxyPort = null;
        this.requestTimeOut = null;
        this.publish = false;
        this.resolveURL = false;
        this.group = null;
        this.onexception = null;
        this.eventhandler = null;
        this.oncomplete = null;
        this.onmisfire = "";
        this.repeat = "-1";
        this.crontime = null;
        this.priority = "5";
        this.cluster = false;
        this.overwrite = true;
        this.exclude = null;
        this.retrycount = "3";
        this.mode = SERVER;
        this.result = null;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() throws JspException {
        CronService cs;
        this.onTagStart();
        try {
            cs = ServiceFactory.getCronService(true);
            Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.schedule");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SchedulingException((Throwable)ex);
        }
        if (!ServiceFactory.getSecurityService().isAdminUser() && !this.validateMode()) {
            throw new SchedulingModeException(this.mode);
        }
        if (this.publish) {
            if (this.isEmpty(this.file)) {
                throw new RequiredAttributesException("CFSCHEDULE", "file");
            }
            if (this.isEmpty(this.path)) {
                throw new RequiredAttributesException("CFSCHEDULE", "path");
            }
        }
        if (this.action.equalsIgnoreCase("create")) {
            this.doActionCreate(cs);
        } else if (this.action.equalsIgnoreCase("update")) {
            this.doActionUpdate(cs);
        } else if (this.action.equalsIgnoreCase("modify")) {
            this.doActionEdit(cs);
        } else if (this.action.equalsIgnoreCase("delete")) {
            this.doActionDelete(cs);
        } else if (this.action.equalsIgnoreCase("pause")) {
            this.doActionPause(cs);
        } else if (this.action.equalsIgnoreCase("resume")) {
            this.doActionResume(cs);
        } else if (this.action.equalsIgnoreCase("pauseall")) {
            this.doActionPauseall(cs);
        } else if (this.action.equalsIgnoreCase("resumeall")) {
            this.doActionResumeall(cs);
        } else if (this.action.equalsIgnoreCase("list")) {
            this.doActionList(cs);
        } else if (this.action.equalsIgnoreCase("run")) {
            this.doActionRun(cs);
        } else {
            throw new InvalidTagAttributeException("CFSCHEDULE", "action", this.action);
        }
        return 5;
    }

    private void doActionCreate(CronService cs) {
        ScheduleTagTO ctask = cs.findTask(this.task, this.group, this.mode);
        if (ctask != null) {
            throw new TaskExistsException(this.task, this.group, this.mode);
        }
        this.doActionUpdate(cs);
    }

    private void doActionEdit(CronService cs) {
        String interval;
        ScheduleTagTO ctask = cs.findTask(this.task, this.group, this.mode);
        if (ctask == null) {
            throw new TaskNotExistException(this.task, this.group, this.mode);
        }
        if (this.setterNotCalled("oncomplete")) {
            this.oncomplete = ctask.getChianedtasks();
        }
        if (this.setterNotCalled("publish")) {
            this.publish = ctask.isPublish();
        }
        if (this.setterNotCalled("resolveurl")) {
            this.resolveURL = ctask.isResolveUrl();
        }
        if (this.setterNotCalled("password")) {
            this.password = ctask.getPassword();
        }
        if (this.setterNotCalled("username")) {
            this.username = ctask.getUsername();
        }
        if (this.setterNotCalled("proxyserver")) {
            this.proxyServer = ctask.getProxyserver();
        }
        if (this.setterNotCalled("proxyuser")) {
            this.proxyUser = ctask.getProxyuser();
        }
        if (this.setterNotCalled("proxypassowrd")) {
            this.proxyPassword = ctask.getProxypassword();
        }
        if (this.setterNotCalled("port")) {
            this.port = ctask.getPort();
        }
        if (this.setterNotCalled("proxyport")) {
            this.proxyPort = ctask.getProxyport();
        }
        if (this.setterNotCalled("file")) {
            this.file = ctask.getFile();
        }
        if (this.setterNotCalled("path")) {
            this.path = ctask.getPath();
        }
        if (this.setterNotCalled("url")) {
            this.url = ctask.getUrl();
        }
        if (this.setterNotCalled("eventhandler")) {
            this.eventhandler = ctask.getEventhandlerrp();
        }
        if (this.setterNotCalled("onexception")) {
            this.onexception = ctask.getOnexception();
        }
        if (this.setterNotCalled("oncomplete")) {
            this.oncomplete = ctask.getChianedtasks();
        }
        if (this.setterNotCalled("retrycount")) {
            this.retrycount = ctask.getRetrycount();
        }
        if (this.setterNotCalled("repeat")) {
            this.repeat = ctask.getRepeat();
        }
        if (this.setterNotCalled("crontime") && ((interval = ctask.getInterval()) == null || !interval.equals("daily") && !interval.equals("monthly") && !interval.equals("weekly"))) {
            this.crontime = ctask.getCrontime();
        }
        if ((this.crontime == null || this.crontime.length() == 0) && this.setterNotCalled("interval")) {
            this.interval = ctask.getInterval();
        }
        if (this.setterNotCalled("onmisfire")) {
            this.onmisfire = ctask.getMisfire();
        }
        if (this.setterNotCalled("priority")) {
            this.priority = ctask.getPriority();
        }
        if (this.setterNotCalled("startdate") && ctask.getStartdate() != null) {
            this.startDate = ctask.getStartdate().toString();
        }
        if (this.setterNotCalled("enddate") && ctask.getEnddate() != null) {
            this.endDate = ctask.getEnddate().toString();
        }
        if (this.setterNotCalled("starttime") && ctask.getStarttime() != null) {
            this.startTime = ctask.getStarttime().toString();
        }
        if (this.setterNotCalled("endtime") && ctask.getEndtime() != null) {
            this.endTime = ctask.getEndtime().toString();
        }
        if (this.setterNotCalled("exclude")) {
            this.exclude = ctask.getExclude();
        }
        if (this.setterNotCalled("cluster")) {
            this.cluster = ctask.isClustered();
        }
        if (this.setterNotCalled("overwrite")) {
            this.overwrite = ctask.getOverwrite();
        }
        this.lastfire = ctask.getLastfire();
        this.doActionUpdate(cs);
    }

    private boolean setterNotCalled(String setter) {
        return !this.settersCalled.contains(setter);
    }

    private void doActionList(CronService cs) {
        try {
            QueryTable tasksList = cs.listTasks(this.task, this.group, this.mode);
            if (null != this.result) {
                this.pageContext.setAttribute(this.result, (Object)tasksList);
            }
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionResumeall(CronService cs) {
        try {
            cs.resumeAllTasks(this.group, this.mode, false);
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionPauseall(CronService cs) {
        try {
            cs.pauseAllTasks(this.group, this.mode, false);
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionRun(CronService qs) {
        try {
            if (!this.task.equalsIgnoreCase("__list")) {
                qs.runCall(this.task, this.group, this.mode);
            }
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
        catch (Throwable e1) {
            throw new SchedulingException(e1);
        }
    }

    private void doActionResume(CronService qs) {
        try {
            if (null == this.task) {
                qs.resumeAllTasks(this.group, this.mode, true);
            } else {
                qs.resumeTask(this.task, this.group, this.mode);
            }
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionPause(CronService qs) {
        try {
            if (null == this.task) {
                qs.pauseAllTasks(this.group, this.mode, true);
            } else {
                qs.pauseTask(this.task, this.group, this.mode);
            }
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionDelete(CronService qs) {
        try {
            qs.deleteTask(this.task, this.group, this.mode);
        }
        catch (Exception e) {
            throw new SchedulingException((Throwable)e);
        }
    }

    private void doActionUpdate(CronService qs) {
        Date sdate = null;
        Date edate = null;
        Date stime = null;
        Date etime = null;
        this.validatePriority();
        this.validateMisfire();
        this.validateRetrycount();
        this.validateFile();
        if (ScheduleTag.stringNullCheck(this.url) && ScheduleTag.stringNullCheck(this.eventhandler)) {
            throw new SchedulingNoUrlHandlerException();
        }
        if (!ScheduleTag.stringNullCheck(this.eventhandler)) {
            if (ScheduleTag.stringNullCheck(this.onmisfire)) {
                this.onmisfire = "invokehandler";
            }
            if (ScheduleTag.stringNullCheck(this.onexception)) {
                this.onexception = "invokehandler";
            }
        }
        if (!this.isEmpty(this.startDate)) {
            sdate = CFPage.ParseDateTime(this.startDate);
        }
        if (!this.isEmpty(this.startTime)) {
            stime = CFPage.ParseDateTime(this.startTime);
        }
        if (!this.isEmpty(this.endDate)) {
            edate = CFPage.ParseDateTime(this.endDate);
        }
        if (!this.isEmpty(this.endTime)) {
            etime = CFPage.ParseDateTime(this.endTime);
        }
        this.validate_interval(this.interval);
        if (null != sdate && null != stime) {
            CronTabEntry.mergeDates(sdate, stime, false);
        }
        if (this.crontime != null && this.checkCronSyntax()) {
            throw new SchedulingCrontimeException(this.crontime);
        }
        this.scheduleTagData = new ScheduleTagTO();
        this.scheduleTagData.setTask(this.task);
        this.scheduleTagData.setGroup(this.group);
        this.scheduleTagData.setPublish(this.publish);
        this.scheduleTagData.setPassword(this.password);
        this.scheduleTagData.setUsername(this.username);
        this.scheduleTagData.setProxyserver(this.proxyServer);
        this.scheduleTagData.setProxyuser(this.proxyUser);
        this.scheduleTagData.setProxypassword(this.proxyPassword);
        this.scheduleTagData.setRequestTimeOut(this.requestTimeOut);
        this.scheduleTagData.setResolveUrl(this.resolveURL);
        this.scheduleTagData.setPort(this.port);
        this.scheduleTagData.setProxyport(this.proxyPort);
        this.scheduleTagData.setFile(this.file);
        this.scheduleTagData.setPath(this.path);
        this.scheduleTagData.setUrl(this.url);
        this.scheduleTagData.setEventhandler(this.eventhandler);
        this.scheduleTagData.setOnexception(this.onexception);
        this.scheduleTagData.setChianedtasks(this.oncomplete);
        this.scheduleTagData.setRetrycount(this.retrycount);
        this.scheduleTagData.setRepeat(this.repeat);
        this.scheduleTagData.setInterval(this.interval);
        this.scheduleTagData.setCrontime(this.crontime);
        this.scheduleTagData.setMisfire(this.onmisfire);
        this.scheduleTagData.setStartdate(sdate);
        this.scheduleTagData.setStarttime(stime);
        this.scheduleTagData.setEnddate(edate);
        this.scheduleTagData.setEndtime(etime);
        this.scheduleTagData.setPriority(this.priority);
        this.scheduleTagData.setExclude(this.exclude);
        this.scheduleTagData.setMode(this.mode);
        this.scheduleTagData.setClustered(this.cluster);
        this.scheduleTagData.setOverwrite(this.overwrite);
        if (this.lastfire != null) {
            this.scheduleTagData.setLastfire(this.lastfire);
        }
        if (this.action.equals("modify")) {
            this.scheduleTagData.shouldNotMisfire = true;
        }
        try {
            qs.updateTask(this.scheduleTagData);
        }
        catch (IllegalDateFormatException ex) {
            throw new SchedulingException((Throwable)ex);
        }
        catch (NumberFormatException ex) {
            throw new SchedulingException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new SchedulingException((Throwable)ex);
        }
    }

    public static boolean stringNullCheck(String string) {
        return null == string || 0 == string.length();
    }

    private void validateFile() {
        if (this.file == null || this.file.length() == 0) {
            return;
        }
        String ext = "";
        try {
            ext = ServiceFactory.getCronService().checkAllowedFileExtensions(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!"true".equals(ext)) {
            throw new SchedulingInvalidFileExtensionException(ext);
        }
    }

    private void validateMisfire() {
        if (this.onmisfire == null || this.onmisfire.length() == 0) {
            return;
        }
        Set misfireset = MISFIRESET;
        if (!misfireset.contains(this.onmisfire.toUpperCase())) {
            StringBuilder misfires = new StringBuilder();
            for (String s : misfireset) {
                misfires.append(s).append(",");
            }
            misfires.deleteCharAt(misfires.length() - 1);
            throw new IncorrectMisfire(this.onmisfire, misfires.toString());
        }
    }

    private void validatePriority() {
        try {
            Integer.parseInt(this.priority);
        }
        catch (Exception e) {
            throw new IncorrectPriority(this.priority);
        }
    }

    private void validateRetrycount() {
        try {
            int p = Integer.parseInt(this.retrycount);
            if (p < 0 || p > 3) {
                throw new IncorrectRetrycount(this.retrycount);
            }
        }
        catch (Exception e) {
            throw new IncorrectRetrycount(this.retrycount);
        }
    }

    private boolean validateMode() {
        if (!ScheduleTag.stringNullCheck(this.mode)) {
            return MODESET.contains(this.mode.toLowerCase());
        }
        return true;
    }

    private boolean checkCronSyntax() {
        return this.crontime.split(" ").length < 5 || this.crontime.split(" ").length > 7;
    }

    private void validate_interval(String str) {
        if (!(str == null || str.equalsIgnoreCase("daily") || str.equalsIgnoreCase("weekly") || str.equalsIgnoreCase("monthly") || str.equalsIgnoreCase("once"))) {
            try {
                Integer.parseInt(str);
            }
            catch (Exception e) {
                throw new IncorrectInterval(str);
            }
        }
    }

    static {
        MODESET.add(APPLICATION);
        MODESET.add(SERVER);
        MISFIRESET = new HashSet();
        MISFIRESET.add("FIRENOW");
        MISFIRESET.add("INVOKEHANDLER");
    }

    public class SchedulingException
    extends NeoException {
        SchedulingException(Throwable ex) {
            super(ex);
        }
    }

    public static class SchedulingModeException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String mode;

        public SchedulingModeException(String mode) {
            this.mode = mode;
        }
    }

    public static class TaskExistsException
    extends ExpressionException {
        public String task;
        public String group;
        public String mode;

        public TaskExistsException(String task2, String group, String mode) {
            if (group == null || group.equals("")) {
                group = "DEFAULT";
            }
            this.task = task2;
            this.group = group;
            this.mode = mode;
        }
    }

    public class TaskNotExistException
    extends ExpressionException {
        public String task;
        public String group;
        public String mode;

        TaskNotExistException(String task2, String group, String mode) {
            if (group == null || group.equals("")) {
                group = "DEFAULT";
            }
            this.task = task2;
            this.group = group;
            this.mode = mode;
        }
    }

    public class SchedulingNoUrlHandlerException
    extends ExpressionException {
        SchedulingNoUrlHandlerException() {
        }
    }

    public static class SchedulingCrontimeException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String crontime;

        public SchedulingCrontimeException(String crontime) {
            this.crontime = crontime;
        }
    }

    public class SchedulingInvalidFileExtensionException
    extends ExpressionException {
        public String ext = null;

        SchedulingInvalidFileExtensionException(String ext) {
            this.ext = ext;
        }
    }

    public class IncorrectMisfire
    extends ExpressionException {
        public String misfire = null;
        public String validmisfires = null;

        IncorrectMisfire(String mis, String validmisfires) {
            this.misfire = mis;
            this.validmisfires = validmisfires;
        }
    }

    public class IncorrectPriority
    extends ExpressionException {
        public String priority = null;

        IncorrectPriority(String priority) {
            this.priority = priority;
        }
    }

    public class IncorrectRetrycount
    extends ExpressionException {
        public String rc = null;

        IncorrectRetrycount(String rc) {
            this.rc = rc;
        }
    }

    public class IncorrectInterval
    extends ExpressionException {
        public String interval = null;

        IncorrectInterval(String str) {
            this.interval = str;
        }
    }

    public static class SchedulingEventhandlerNofileException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String eventhandler;

        public SchedulingEventhandlerNofileException(String eventhandler) {
            this.eventhandler = eventhandler;
        }
    }

    public static class InvalidStartdateException
    extends NeoException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidExcludedateException
    extends NeoException {
        private static final long serialVersionUID = 1L;
    }

    public static class ClusterDBNotSupportedException
    extends NeoException {
        public String dbs;

        public ClusterDBNotSupportedException(String dbs) {
            this.dbs = dbs;
        }
    }

    public static class PauseExpiredTaskException
    extends NeoException {
        public String Task;

        public PauseExpiredTaskException(String Task2) {
            this.Task = Task2;
        }
    }

    public static class ResumeExpiredTaskException
    extends NeoException {
        public String Task;

        public ResumeExpiredTaskException(String Task2) {
            this.Task = Task2;
        }
    }

    public static class GroupNotPresentException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String group = "";

        public GroupNotPresentException(String grp) {
            this.group = grp;
        }
    }

    public static class ClusterNotEnabledException
    extends NeoException {
        private static final long serialVersionUID = 1L;
    }

    public static class PauseResumeChainedtaskException
    extends NeoException {
        public String Task;

        public PauseResumeChainedtaskException(String Task2) {
            this.Task = Task2;
        }
    }

    public class StartPeriodMissingException
    extends ExpressionException {
        StartPeriodMissingException() {
        }
    }

    public class IntervalNotSpecifiedException
    extends ExpressionException {
        IntervalNotSpecifiedException() {
        }
    }

    public static class SchedulingEventhandlerException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String eventhandler;

        public SchedulingEventhandlerException(String eventhandler) {
            this.eventhandler = eventhandler;
        }
    }

    public static class TaskPausedException
    extends NeoException {
        public String Task;

        public TaskPausedException(String Task2) {
            this.Task = Task2;
        }
    }
}

