/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public class SpreadSheetTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfspreadsheet");
    private String src;
    private String query = null;
    private String action;
    private String rows;
    private String columns;
    private String columnnames;
    private int headerrow = -1;
    private int sheet = 1;
    private String sheetname;
    private String name;
    private String format;
    private String filename;
    private String password;
    private int maxcolcount = 0;
    private boolean overWrite;
    private boolean update = false;
    private boolean excludeHeaderRow = false;
    private boolean sheetNoProvided = false;
    private Object autosize = true;
    private static final String linesep = System.getProperty("line.separator");
    private static Map<String, Integer> DATATYPESTRINGMAPPER = new HashMap<String, Integer>();
    private static String STRINGDATATYPE = "STRING";
    private static String DATEDATATYPE = "DATE";
    private static String NUMERICDATATYPE = "NUMERIC";

    public int doStartTag() {
        this.onTagStart();
        --this.sheet;
        FeatureRouter.getInstance().allowFeature(EFRConstants.spreadsheet_support, this.tagNameFromClass(), null);
        if (this.autosize != null && !(this.autosize instanceof Array) && !CFPage.IsBoolean(this.autosize)) {
            throw new ExcelInvalidAutosizeException();
        }
        if (this.action.equalsIgnoreCase("update")) {
            this.update = true;
        }
        if (this.action.equalsIgnoreCase("read")) {
            ServiceFactory.getExcelService().read(this.pageContext, this.query, this.format, this.name, this.src, this.headerrow, this.columnnames, this.columns, this.sheet, this.maxcolcount, this.excludeHeaderRow, this.rows, this.sheetname, this.sheetNoProvided, this.password);
        } else if (this.action.equalsIgnoreCase("write") || this.update) {
            ServiceFactory.getExcelService().write(this.pageContext, this.filename, this.sheetname, this.name, this.format, this.query, this.update, this.password, this.autosize, this.overWrite, this.sheet);
        }
        this.onTagEnd();
        return 0;
    }

    public void setExcludeHeaderRow(boolean excludeHeaderRow) {
        this.excludeHeaderRow = excludeHeaderRow;
    }

    public void setFileName(String filename) {
        this.filename = Utils.getFileFullPath(filename, this.pageContext, true);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setHeaderRow(int headerrow) {
        this.headerrow = headerrow;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSheetName(String sheetname) {
        this.sheetname = sheetname;
        this.sheetNoProvided = true;
    }

    public void setColumnNames(String columnnames) {
        this.columnnames = columnnames;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isOverWrite() {
        return this.update || this.overWrite;
    }

    public void setOverWrite(boolean o) {
        this.overWrite = o;
    }

    public void setSheet(int sheet) {
        if (sheet > 0) {
            this.sheet = sheet;
            this.sheetNoProvided = true;
        } else {
            this.sheet = 1;
            this.sheetNoProvided = false;
        }
    }

    public void setSrc(String src) {
        try {
            this.src = src = this.verifyFile(src);
        }
        catch (FileNotFoundException e) {
            throw new ExcelTagException(e);
        }
    }

    private String verifyFile(String filename) throws FileNotFoundException {
        if (filename.trim().length() == 0) {
            throw new FileNotFoundException(filename);
        }
        File file = VFSFileFactory.getFileObject(filename = Utils.getFileFullPath(filename, this.pageContext, true));
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        return filename;
    }

    public void setAutosize(Object af) {
        this.autosize = af;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    public void release() {
        this.src = null;
        this.query = null;
        this.action = null;
        this.rows = null;
        this.columns = null;
        this.sheet = 1;
        this.columnnames = null;
        this.headerrow = -1;
        this.sheetname = null;
        this.name = null;
        this.format = null;
        this.filename = null;
        this.update = false;
        this.overWrite = false;
        this.password = null;
        this.excludeHeaderRow = false;
        super.release();
    }

    static {
        DATATYPESTRINGMAPPER.put(NUMERICDATATYPE, 2);
        DATATYPESTRINGMAPPER.put(STRINGDATATYPE, -1);
        DATATYPESTRINGMAPPER.put(DATEDATATYPE, 91);
    }

    public static class ExcelInvalidAutosizeException
    extends ApplicationException {
    }

    public static class ExcelTagException
    extends ApplicationException {
        public ExcelTagException(Throwable ex) {
            super(ex);
        }
    }

    public static class CSVProcessingException
    extends ApplicationException {
        public CSVProcessingException(Throwable ex) {
            super(ex);
        }
    }

    public static class CSVReadException
    extends ApplicationException {
        public CSVReadException(Throwable ex) {
            super(ex);
        }
    }

    public static class CSVWriteException
    extends ApplicationException {
        public CSVWriteException(Throwable ex) {
            super(ex);
        }
    }

    public static class ExcelProcessException
    extends ApplicationException {
        public String action;

        public ExcelProcessException(String action, Throwable ex) {
            super(ex);
            this.action = action;
        }
    }

    public static class ExcelInvalidRowSpecifiedException
    extends ApplicationException {
    }

    public static class ExcelInvalidColumnSpecifiedException
    extends ApplicationException {
    }

    public static class MethodNotImplementedForStreamingSheetException
    extends ApplicationException {
        public String methodName;
        public String format;

        public MethodNotImplementedForStreamingSheetException(String methodName) {
            this.methodName = methodName;
        }
    }

    public static class MethodInvalidForFormatException
    extends ApplicationException {
        public String allowedFormat;

        public MethodInvalidForFormatException(String allowedFormat) {
            this.allowedFormat = allowedFormat;
        }
    }

    public static class InvalidExcelFormatForMethodException
    extends ApplicationException {
        public String methodName;

        public InvalidExcelFormatForMethodException(String methodName) {
            this.methodName = methodName;
        }
    }

    public static class InvalidExcelFormatException
    extends ApplicationException {
    }

    public static class ExcelInvalidDatatypeRangeNumberException
    extends ApplicationException {
        public String val;

        public ExcelInvalidDatatypeRangeNumberException(String val) {
            this.val = val;
        }
    }

    public static class ExcelInvalidBreaksException
    extends ApplicationException {
        public String val;

        public ExcelInvalidBreaksException(String val) {
            this.val = val;
        }
    }

    public static class ExcelNoColumnDatatypeException
    extends ApplicationException {
        public String dt;
        public String values = "";

        public ExcelNoColumnDatatypeException(String dt) {
            this.dt = dt;
        }
    }

    public static class ExcelInvalidDatatypeTypeException
    extends ApplicationException {
    }

    public static class ExcelInvalidDatatypevalueException
    extends ApplicationException {
        public String dt;
        public String values = "";

        public ExcelInvalidDatatypevalueException(String dt) {
            this.dt = dt;
        }
    }

    public static class ExcelInvalidDatatypeException
    extends ApplicationException {
        public String dt;
        public String values = "";

        public ExcelInvalidDatatypeException(String dt) {
            this.dt = dt;
            for (String type : DATATYPESTRINGMAPPER.keySet()) {
                this.values = this.values + type + ",";
            }
            this.values = this.values.substring(0, this.values.length() - 1);
        }
    }

    public static class ExcelInvalidDatatypeColNumberException
    extends ApplicationException {
        public String col;

        public ExcelInvalidDatatypeColNumberException(String col) {
            this.col = col;
        }
    }

    public static class UnSupportedPictureTypeException
    extends ApplicationException {
        public String name;

        public UnSupportedPictureTypeException(String name) {
            this.name = name;
        }
    }

    public static class SpreadSheetFunctionException
    extends ApplicationException {
        public String function;

        public SpreadSheetFunctionException(String function, Throwable ex) {
            super(ex);
            this.function = function;
        }
    }

    public static class MergeCellsInvalidValueException
    extends ApplicationException {
        public int from;
        public int to;

        public MergeCellsInvalidValueException(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class SpreadSheetInvalidSheetNumberException
    extends ApplicationException {
        public int sheetNumber;

        public SpreadSheetInvalidSheetNumberException(int sheetNum) {
            this.sheetNumber = sheetNum;
        }
    }

    public static class SpreadSheetInvalidSheetNameException
    extends ApplicationException {
        public String name;

        public SpreadSheetInvalidSheetNameException(String name) {
            this.name = name;
        }
    }

    public static class SpreadSheetLastSheetException
    extends ApplicationException {
    }

    public static class FreezePaneInvalidRowSplitParameter
    extends ApplicationException {
        public int toprow;
        public int row;

        public FreezePaneInvalidRowSplitParameter(int toprow, int row) {
            this.toprow = toprow;
            this.row = row;
        }
    }

    public static class InvalidStartRowParameterException
    extends ApplicationException {
        public int startRow;
        public int endRow;

        public InvalidStartRowParameterException(int startRow, int endRow) {
            this.startRow = startRow;
            this.endRow = endRow;
        }
    }

    public static class InvalidParameterCombinationException
    extends ApplicationException {
        public String firstParam;
        public String firstValue;
        public String secondParam;
        public String secondValue;

        public InvalidParameterCombinationException(String firstParam, String firstValue, String secondParam, String secondValue) {
            this.firstParam = firstParam;
            this.secondParam = secondParam;
            this.firstValue = firstValue;
            this.secondValue = secondValue;
        }
    }

    public static class InvalidStartColumnParameterException
    extends ApplicationException {
        public int startColumn;
        public int endColumn;

        public InvalidStartColumnParameterException(int startColumn, int endColumn) {
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }
    }

    public static class FreezePaneInvalidColSplitParameter
    extends ApplicationException {
        public int leftcol;
        public int col;

        public FreezePaneInvalidColSplitParameter(int leftcol, int col) {
            this.leftcol = leftcol;
            this.col = col;
        }
    }

    public static class SpreadsheetInvalidRowException
    extends ApplicationException {
        public int row;

        public SpreadsheetInvalidRowException(int row) {
            this.row = row;
        }
    }

    public static class SpreadsheetInvalidWidth
    extends ApplicationException {
        public int width;

        public SpreadsheetInvalidWidth(int width) {
            this.width = width;
        }
    }

    public static class SpreadsheetInvalidHeight
    extends ApplicationException {
        public float height;

        public SpreadsheetInvalidHeight(float height) {
            this.height = height;
        }
    }

    public static class InvalidRangeException
    extends ApplicationException {
        public String range;

        public InvalidRangeException(String range) {
            this.range = range;
        }
    }

    public static class ExcelInvalidSheetException
    extends ApplicationException {
        public int sheetno;

        public ExcelInvalidSheetException(int sheetno) {
            this.sheetno = sheetno;
        }
    }

    public static class ExcelLockedSheetException
    extends ApplicationException {
    }

    public static class InvalidRowSpecifiedException
    extends ApplicationException {
        public int row;

        public InvalidRowSpecifiedException(int row) {
            this.row = row;
        }
    }

    public static class InvalidColumnSpecifiedException
    extends ApplicationException {
        public int column;

        public InvalidColumnSpecifiedException(int column) {
            this.column = column;
        }
    }

    public static class ExcelInvalidArgumentRowException
    extends ApplicationException {
        public ExcelInvalidArgumentRowException(Throwable e) {
            super(e);
        }
    }

    public static class ExcelInvalidArgumentException
    extends ApplicationException {
        public int cellnum;

        public ExcelInvalidArgumentException(int cellnum) {
            this.cellnum = cellnum;
        }
    }

    public static class ExcelInvalidCellValue
    extends ApplicationException {
    }

    public static class InvalidInputException
    extends ApplicationException {
    }

    public static class EmptyListNotAllowedException
    extends ApplicationException {
        public String key;

        public EmptyListNotAllowedException(String key) {
            this.key = key;
        }
    }

    public static class DataValidationNonListValueException
    extends ApplicationException {
        public String value;

        public DataValidationNonListValueException(Object value) {
            this.value = value.toString();
        }
    }

    public static class DataValidationIncorrectOperatorException
    extends ApplicationException {
        public String operator;

        public DataValidationIncorrectOperatorException(String operator) {
            this.operator = operator;
        }
    }

    public static class DataValidationInvalidRegionException
    extends ApplicationException {
        public String key;

        public DataValidationInvalidRegionException(String key) {
            this.key = key;
        }
    }

    public static class InvalidValueForValidationTypeException
    extends ApplicationException {
        public String value;
        public String key;
        public String validationType;
        public String exampleString;

        public InvalidValueForValidationTypeException(String key, String value, String validationType, String example) {
            this.key = key;
            this.value = value;
            this.validationType = validationType;
            this.exampleString = example;
        }
    }

    public static class InvalidDataException
    extends ApplicationException {
    }

    public static class InvalidValueException
    extends ApplicationException {
        public String value;
        public String format;

        public InvalidValueException(String value, String format) {
            this.value = value;
            this.format = format;
        }
    }

    public static class ExcelProcessingException
    extends ApplicationException {
        public ExcelProcessingException(Throwable t) {
            super(t);
        }
    }

    public static class ExcelReadException
    extends ApplicationException {
        public ExcelReadException(Throwable t) {
            super(t);
        }
    }

    public static class FileAlreadyExistsException
    extends ApplicationException {
        public String file;

        public FileAlreadyExistsException(String file) {
            this.file = file;
        }
    }

    public static class ExcelSetHeaderFooterImageException
    extends ApplicationException {
    }

    public static class ExcelInvalidVariableException
    extends ApplicationException {
        public String name;

        public ExcelInvalidVariableException(String name) {
            this.name = name;
        }
    }

    public static class KeyAbsentForSpecificKeyValuePairException
    extends ApplicationException {
        public String absentKey;
        public String key;
        public Object value;
        public String operation;

        public KeyAbsentForSpecificKeyValuePairException(String absentKey, String key, Object value, String operation) {
            this.absentKey = absentKey;
            this.key = key;
            this.value = value;
            this.operation = operation;
        }
    }

    public static class InvalidKeyFormatOperationException
    extends ApplicationException {
        public String key;
        public String format;
        public String operation;

        public InvalidKeyFormatOperationException(String key, String format, String operation) {
            this.key = key;
            this.format = format;
            this.operation = operation;
        }
    }

    public static class InvalidParameterValueException
    extends ApplicationException {
        public String parameter;
        public String value;
        public String allowedValues;

        public InvalidParameterValueException(String parameter, String value, String allowedValues) {
            this.parameter = parameter;
            this.value = value;
            this.allowedValues = allowedValues;
        }
    }

    public static class InvalidKeyForOperationException
    extends ApplicationException {
        public String key;
        public String operation;

        public InvalidKeyForOperationException(String key, String operation) {
            this.key = key;
            this.operation = operation;
        }
    }

    public static class ExcelInvalidKeyCombinationException
    extends ApplicationException {
        public String key;
        public String dependentKey;

        public ExcelInvalidKeyCombinationException(String key, String dependentKey) {
            this.key = key;
            this.dependentKey = dependentKey;
        }
    }

    public static class ExcelClearCellException
    extends ApplicationException {
    }

    public static class ExcelInvalidAddressException
    extends ApplicationException {
        public String address;
        public String type;

        public ExcelInvalidAddressException(String address, String type) {
            this.address = address;
            this.type = type;
        }
    }

    public static class ExcelIllegalValueException
    extends ApplicationException {
        public String value;
        public String attribute;

        public ExcelIllegalValueException(String value, String attribute) {
            this.value = value;
            this.attribute = attribute;
        }
    }

    public static class ExcelMissingAttributeException
    extends ApplicationException {
        public String attribute;
        public String action;

        public ExcelMissingAttributeException(String action, String attribute) {
            this.attribute = attribute;
            this.action = action;
        }
    }

    public static class ExcelInvalidSheetNumberException
    extends ApplicationException {
        public int sheetnum;

        public ExcelInvalidSheetNumberException(int sheetnum) {
            this.sheetnum = sheetnum;
        }
    }

    public static class ExcelInvalidHeaderRowException
    extends ApplicationException {
        public int rownum;

        public ExcelInvalidHeaderRowException(int rownum) {
            this.rownum = rownum;
        }
    }

    public static class ExcelInvalidSheetNameException2
    extends ApplicationException {
        public String sheetname;

        public ExcelInvalidSheetNameException2(String sheetname) {
            this.sheetname = sheetname;
        }
    }

    public static class ExcelInvalidSheetNameException
    extends ApplicationException {
        public String sheetname;

        public ExcelInvalidSheetNameException(String sheetname) {
            this.sheetname = sheetname;
        }
    }

    public static class ExcelInvalidOperationWhileProcessingException
    extends ApplicationException {
        public String operation;

        public ExcelInvalidOperationWhileProcessingException(String operation) {
            this.operation = operation;
        }
    }
}

