/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.AdvancedCFException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.tagext.FunctionGeneratorTag;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.thread.CFThreadHandler;
import coldfusion.thread.Task;
import coldfusion.thread.ThreadConstants;
import coldfusion.util.CaseInsensitiveMap;
import jakarta.servlet.jsp.JspException;
import java.security.Permission;
import java.util.Map;

public class ThreadTag
extends GenericTag
implements FunctionGeneratorTag,
ThreadConstants {
    public static final String IS_INTERRUPTED = "isInterrupted";
    private String name;
    private String action = "run";
    private long duration;
    private long timeout;
    private int priority;
    private String priorityStr;
    private String functName;
    private Map args;
    public static final String RUN = "run";
    public static final String JOIN = "join";
    public static final String SLEEP = "sleep";
    public static final String TERMINATE = "terminate";
    public static final String INTERRUPT = "interrupt";
    private static final GenericTagPermission tp = new GenericTagPermission("cfthread");

    public void setName(String name) {
        if ((name = name.trim().toUpperCase()).length() == 0) {
            throw new InvalidThreadNameException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action.trim();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getPriority() {
        return this.priorityStr;
    }

    public void setPriority(String priorityStr) {
        this.priorityStr = priorityStr.trim();
        if (priorityStr.equalsIgnoreCase("HIGH")) {
            this.priority = 7;
        } else if (priorityStr.equalsIgnoreCase("NORMAL")) {
            this.priority = 5;
        } else if (priorityStr.equalsIgnoreCase("LOW")) {
            this.priority = 3;
        } else {
            throw new InvalidPriorityException(priorityStr);
        }
    }

    @Override
    public void setFunctionName(String functName) {
        this.functName = functName;
    }

    public void setAttributecollection(Map map) {
        this.setAttributeCollection(map);
    }

    public void setAttributeCollection(Object map) {
        if (map instanceof CaseInsensitiveMap) {
            try {
                this.args = ((CaseInsensitiveMap)map).duplicate();
            }
            catch (IllegalAccessException e) {
                this.args = (Map)map;
            }
        } else if (map instanceof Map) {
            this.args = (Map)map;
        } else {
            throw new InvalidAttributeCollectionException();
        }
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public static boolean isInterrupted(String threadName) {
        Task task2 = ThreadTag.getTask(threadName);
        if (task2 == null) {
            throw new ThreadNotFoundException(threadName, IS_INTERRUPTED);
        }
        return task2.isInterrupted();
    }

    public static boolean interrupted() {
        Task task2;
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext == null) {
            return false;
        }
        String threadName = fContext.getCurrentUserThreadName();
        Task task3 = task2 = threadName == null ? null : fContext.getUserThreadTask(threadName);
        if (task2 == null) {
            throw new InvalidCFThreadException();
        }
        return task2.interrupted();
    }

    private static Task getTask(String threadName) {
        return ThreadTag.getTask(threadName, FusionContext.getCurrent());
    }

    private static Task getTask(String threadName, FusionContext fusionContext) {
        if (threadName == null) {
            return null;
        }
        if ((threadName = threadName.trim().toUpperCase()).length() == 0 || threadName.indexOf(44) != -1) {
            throw new InvalidThreadNameException(threadName);
        }
        return fusionContext.getUserThreadTask(threadName);
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.validateTagAttributes();
        if (this.action.equalsIgnoreCase(SLEEP)) {
            String threadName = this.fContext.getCurrentUserThreadName();
            Task threadTask = threadName == null ? null : this.fContext.getUserThreadTask(threadName);
            try {
                Thread.sleep(this.duration);
            }
            catch (InterruptedException e) {
                if (threadTask != null) {
                    threadTask.setStatus(3);
                }
                throw new ThreadInterruptedException();
            }
            return 0;
        }
        if (this.action.equalsIgnoreCase(TERMINATE)) {
            throw new MethodUnsupportedException("threadTerminate");
        }
        if (this.action.equalsIgnoreCase(INTERRUPT)) {
            ThreadTag.interruptThread(this.name, this.fContext);
            return 0;
        }
        if (this.action.equalsIgnoreCase(JOIN)) {
            ThreadTag.joinAction(this.fContext, this.name, this.timeout);
            return 0;
        }
        if (this.action.equalsIgnoreCase(RUN)) {
            if (this.name.indexOf(44) != -1) {
                throw new InvalidThreadNameException(this.name);
            }
            Task oldTask = this.fContext.getUserThreadTask(this.name);
            if (oldTask != null) {
                throw new DuplicateThreadNameException(this.name);
            }
            String currUserThreadName = this.fContext.getCurrentUserThreadName();
            if (currUserThreadName != null) {
                throw new ChildThreadNotAllowedException(this.name);
            }
        }
        return 2;
    }

    private static void joinAction(FusionContext fusionContext, String threadName, long timeout) {
        String[] names = threadName == null ? ThreadTag.getThreadNamesToJoinWith(fusionContext) : threadName.split(",");
        long threadTimeout = timeout;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() <= 0) continue;
            long t1 = System.currentTimeMillis();
            if (threadTimeout > 0L) {
                ThreadTag.joinWith(fusionContext, name, threadTimeout);
            } else if (timeout == 0L) {
                ThreadTag.joinWith(fusionContext, name, 0L);
            }
            if (timeout == 0L) continue;
            threadTimeout -= System.currentTimeMillis() - t1;
        }
    }

    private static String[] getThreadNamesToJoinWith(FusionContext fusionContext) {
        String currThreadName = fusionContext.getCurrentUserThreadName();
        String[] cfthreadNames = fusionContext.getAllCFthreadNames();
        if (cfthreadNames.length == 0 || currThreadName == null) {
            return cfthreadNames;
        }
        String[] names = new String[cfthreadNames.length - 1];
        int i = 0;
        for (int j = 0; j < cfthreadNames.length; ++j) {
            String cfthreadName = cfthreadNames[j];
            if (cfthreadName.equals(currThreadName)) continue;
            names[i++] = cfthreadName;
        }
        return names;
    }

    private void validateTagAttributes() {
        if (this.action.equalsIgnoreCase(RUN)) {
            if (this.duration != 0L || this.timeout != 0L) {
                throw new InvalidRunActionAttributeException();
            }
        } else if (this.action.equalsIgnoreCase(JOIN)) {
            if (this.args != null || this.priority != 0 || this.duration != 0L) {
                throw new InvalidJoinActionAttributeException();
            }
        } else if (this.action.equalsIgnoreCase(SLEEP)) {
            if (this.args != null || this.name != null || this.priority != 0 || this.timeout != 0L) {
                throw new InvalidSleepActionAttributeException();
            }
        } else if (this.action.equalsIgnoreCase(TERMINATE) && (this.args != null || this.duration != 0L || this.priority != 0 || this.timeout != 0L)) {
            throw new InvalidTerminateActionAttributeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void joinWith(FusionContext fusionContext, String threadName, long timeout) {
        Task threadTask = fusionContext.getUserThreadTask(threadName);
        if (threadTask == null) {
            throw new ThreadNotFoundException(threadName, JOIN);
        }
        String currUserThreadName = fusionContext.getCurrentUserThreadName();
        if (threadName.equals(currUserThreadName)) {
            throw new SelfJoinException();
        }
        Task currentThreadTask = currUserThreadName != null ? fusionContext.getUserThreadTask(currUserThreadName) : null;
        Task task2 = threadTask;
        synchronized (task2) {
            if (threadTask.getStatus() != 3 && threadTask.getStatus() != 4) {
                try {
                    if (currentThreadTask != null) {
                        currentThreadTask.setStatus(2);
                    }
                    if (timeout >= 0L) {
                        threadTask.wait(timeout);
                    }
                    if (currentThreadTask != null) {
                        currentThreadTask.setStatus(1);
                    }
                }
                catch (InterruptedException e) {
                    if (currentThreadTask != null) {
                        currentThreadTask.setStatus(3);
                    }
                    throw new ThreadInterruptedException();
                }
            }
        }
    }

    public static void interruptThread() {
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            String threadName = fContext.getCurrentUserThreadName();
            Task threadTask = ThreadTag.getTask(threadName);
            if (threadTask == null) {
                throw new InvalidCFThreadException();
            }
            threadTask.interrupt();
        }
    }

    private static void interruptThread(String threadName, FusionContext context) {
        Task threadTask = ThreadTag.getTask(threadName, context);
        if (threadTask == null) {
            throw new ThreadNotFoundException(threadName, INTERRUPT);
        }
        threadTask.interrupt();
    }

    public static void interruptThread(String threadName) {
        ThreadTag.interruptThread(threadName, FusionContext.getCurrent());
    }

    public static void threadJoin(String threadName, long timeout) {
        if (threadName != null && (threadName = threadName.trim().toUpperCase()).length() == 0) {
            threadName = null;
        }
        FusionContext fusionContext = FusionContext.getCurrent();
        ThreadTag.joinAction(fusionContext, threadName, timeout);
    }

    public int doEndTag() throws JspException {
        if (this.action.equalsIgnoreCase(RUN)) {
            Task task2 = new Task((NeoPageContext)this.pageContext, this.args, this.functName, this.name);
            task2.setPriority(this.priority);
            CFThreadHandler cfThreadHandler = FeatureRouter.getInstance().getServerEdition().getCFThreadHandler();
            cfThreadHandler.handleTask(task2);
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.name = null;
        this.action = RUN;
        this.duration = 0L;
        this.timeout = 0L;
        this.priorityStr = null;
        this.functName = null;
        this.args = null;
        super.release();
    }

    public static class InvalidThreadNameException
    extends ApplicationException {
        public String thread;

        public InvalidThreadNameException() {
        }

        public InvalidThreadNameException(String thread) {
            this.thread = thread;
        }

        @Override
        public String getDetail() {
            if (this.thread == null) {
                return InvalidThreadNameException.getString(this, "detailEmptyName", this.locale);
            }
            return super.getDetail();
        }
    }

    public static class InvalidPriorityException
    extends ApplicationException {
        public String priority;

        public InvalidPriorityException(String priority) {
            this.priority = priority;
        }
    }

    public static class InvalidAttributeCollectionException
    extends ApplicationException {
    }

    public static class ThreadNotFoundException
    extends ApplicationException {
        public String thread;
        public String action;

        public ThreadNotFoundException(String threadName, String actionName) {
            this.thread = threadName;
            this.action = actionName;
        }
    }

    public static class InvalidCFThreadException
    extends ApplicationException {
    }

    public static class ThreadInterruptedException
    extends AdvancedCFException {
        private static final long serialVersionUID = 1L;

        @Override
        public String getType() {
            return "com.adobe.coldfusion.ThreadInterruptedException";
        }
    }

    public static class MethodUnsupportedException
    extends ApplicationException {
        public String method;

        public MethodUnsupportedException(String method) {
            this.method = method;
        }
    }

    public static class DuplicateThreadNameException
    extends ApplicationException {
        public String name;

        public DuplicateThreadNameException(String name) {
            this.name = name;
        }
    }

    public static class ChildThreadNotAllowedException
    extends ApplicationException {
        public String thread;

        public ChildThreadNotAllowedException(String thread) {
            this.thread = thread;
        }
    }

    public static class InvalidRunActionAttributeException
    extends ApplicationException {
    }

    public static class InvalidJoinActionAttributeException
    extends ApplicationException {
    }

    public static class InvalidSleepActionAttributeException
    extends ApplicationException {
    }

    public static class InvalidTerminateActionAttributeException
    extends ApplicationException {
    }

    public static class SelfJoinException
    extends ApplicationException {
    }

    public static class SelfTerminationException
    extends ApplicationException {
    }
}

