/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.CFPage;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.validation.IllegalSwitchValueException;
import coldfusion.util.UUIDUtils;
import coldfusion.util.Utils;
import jakarta.servlet.jsp.JspException;
import java.util.ArrayList;
import java.util.HashMap;

public class TimerTag
extends GenericTag {
    private String label = "cftimer";
    private String type = "debug";
    private long startTime = 0L;
    private long endTime = 0L;
    private HashMap debugMap = new HashMap();
    private String id;
    public static ArrayList typeValues = new ArrayList(4);
    private static DebuggingService debugService;

    public void setLabel(String s) {
        this.label = s;
    }

    public void setType(String s) {
        if (typeValues.indexOf(s.toUpperCase()) == -1) {
            throw new IllegalSwitchValueException("CFTimer", "Type", s, typeValues);
        }
        this.type = s.toUpperCase();
    }

    public long getTotalTime() {
        return this.endTime - this.startTime;
    }

    public void setId() {
        this.id = CFPage.Replace(UUIDUtils.createUUID(true), "-", "", "ALL");
    }

    public String getId() {
        return this.id;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (!(debugService == null || debugService.isEnabled() && debugService.isValidIP((String)this.pageContext.findAttribute("cgi.remote_addr")) && debugService.isTimerEnabled())) {
            return 1;
        }
        this.setId();
        try {
            if (this.type.equals("OUTLINE")) {
                this.out.write("");
                this.out.write("<fieldset class='cftimer'>\n");
                this.out.write("   <legend id='cftimer" + this.getId() + "' align='top'></legend>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startTime = System.currentTimeMillis();
        return 1;
    }

    public int doEndTag() throws JspException {
        this.endTime = System.currentTimeMillis();
        if (!(debugService.isEnabled() && debugService.isValidIP((String)this.pageContext.findAttribute("cgi.remote_addr")) && debugService.isTimerEnabled())) {
            return 6;
        }
        try {
            if (this.type.equals("OUTLINE")) {
                this.out.write("");
                this.out.write("<script language='JavaScript' " + Utils.getCSPNonceString() + ">\n");
                this.out.write("   if (document.getElementById) {\n");
                this.out.write("       document.getElementById('cftimer" + this.getId() + "').innerHTML = '" + this.label + ": " + this.getTotalTime() + "ms';\n");
                this.out.write("   }else if (document.all) {\n");
                this.out.write("       document.all.cftimer" + this.getId() + ".innerText = '" + this.label + ": " + this.getTotalTime() + "ms';\n");
                this.out.write("   }else{\n");
                this.out.write("       document.write('" + this.label + ": " + this.getTotalTime() + "ms');\n");
                this.out.write("   }\n");
                this.out.write("</script>\n");
                this.out.write("</fieldset>\n");
            } else if (this.type.equals("INLINE")) {
                this.out.write(this.label + ": " + this.getTotalTime() + "ms");
                this.out.flush();
            } else if (this.type.equals("COMMENT")) {
                this.out.write("<!-- " + this.label + ": " + this.getTotalTime() + "ms -->");
                this.out.flush();
            } else {
                this.debugMap.put("type", "CFTimer");
                this.debugMap.put("message", this.label);
                this.debugMap.put("priority", "information");
                this.debugMap.put("starttime", new Long(this.startTime));
                this.debugMap.put("endtime", new Long(this.endTime));
                debugService.getDebugger().userDefined(this.debugMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onTagEnd();
        return 6;
    }

    static {
        typeValues.add("DEBUG");
        typeValues.add("OUTLINE");
        typeValues.add("INLINE");
        typeValues.add("COMMENT");
        debugService = ServiceFactory.getDebuggingService();
    }
}

