/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.server.StringFormatter;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.validation.WddxValidator;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxDeserializer;
import coldfusion.wddx.WddxSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.InputSource;

public final class WddxTag
extends GenericTag {
    protected String action;
    protected Object input;
    protected String outputName;
    protected String toplevelvariable;
    protected boolean validation = false;
    protected boolean usingTimezone = true;

    public void setAction(String s) {
        this.action = s;
    }

    public String getAction() {
        return this.action;
    }

    public void setInput(Object obj) {
        if (!(obj instanceof QueryTable) && obj instanceof ResultSet) {
            try {
                this.input = new QueryTable((ResultSet)obj);
            }
            catch (SQLException sql) {
                throw new WddxException((Throwable)sql);
            }
        } else {
            this.input = obj;
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void setToplevelvariable(String s) {
        this.toplevelvariable = s;
    }

    public String getToplevelvariable() {
        return this.toplevelvariable;
    }

    public void setOutput(String s) {
        this.outputName = s;
    }

    public String getOutput() {
        return this.outputName;
    }

    public int doStartTag() {
        this.onTagStart();
        try {
            Object output;
            if ("wddx2cfml".equalsIgnoreCase(this.action) || "wddx2java".equalsIgnoreCase(this.action)) {
                output = this.deserialize(this.input);
            } else if ("cfml2wddx".equalsIgnoreCase(this.action) || "java2wddx".equalsIgnoreCase(this.action)) {
                output = this.serialize(this.input);
            } else if ("cfml2js".equalsIgnoreCase(this.action) || "cfml2js".equalsIgnoreCase(this.action)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
                this.renderJS(this.input, writer, this.toplevelvariable);
                writer.flush();
                output = out.toString("UTF8");
            } else if ("wddx2js".equalsIgnoreCase(this.action)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
                this.renderJS(this.deserialize(this.input), writer, this.toplevelvariable);
                writer.flush();
                output = out.toString("UTF8");
            } else {
                throw new UnsupportedOperationException(this.action);
            }
            if (this.outputName != null) {
                this.pageContext.setAttribute(this.outputName, output);
            } else {
                this.writeOutput(output.toString());
            }
        }
        catch (ApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WddxException((Throwable)ex);
        }
        return 0;
    }

    @Override
    public void release() {
        this.input = null;
        this.action = null;
        this.outputName = null;
        this.toplevelvariable = null;
        this.validation = false;
        this.usingTimezone = true;
        super.release();
        this.onTagEnd();
    }

    private void writeOutput(String string) throws IOException {
        if (this.out instanceof CFOutput) {
            ((CFOutput)this.out).cfoutput(true);
        }
        this.out.print(string);
        if (this.out instanceof CFOutput) {
            ((CFOutput)this.out).cfoutput(false);
        }
    }

    public void setValidate(boolean v) {
        this.validation = v;
    }

    public boolean isValidate() {
        return this.validation;
    }

    public void setUsetimezoneinfo(boolean b) {
        this.usingTimezone = b;
    }

    public boolean isUsetimezoneinfo() {
        return this.usingTimezone;
    }

    public Object deserialize(Object obj) throws WddxDeserializationException, IOException {
        WddxDeserializer deserializer = new WddxDeserializer();
        StringReader inputReader = new StringReader(Cast._String(obj));
        InputSource source = new InputSource(inputReader);
        if (this.validation) {
            try {
                new WddxValidator().validate(obj);
            }
            catch (Exception ex) {
                throw new WddxException((Throwable)ex);
            }
        }
        Object result = deserializer.deserialize(source);
        ((Reader)inputReader).close();
        return result;
    }

    public Object serialize(Object obj) throws IOException {
        if (obj instanceof TemplateProxy) {
            throw new UnableToConvertCFCException();
        }
        if (obj instanceof UDFMethod) {
            throw new UnableToConvertUDFException();
        }
        WddxSerializer ws = new WddxSerializer();
        if (!this.usingTimezone) {
            ws.disableTimezoneInfo();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ws.serialize(obj, out);
        return out.toString("UTF8");
    }

    protected void renderJS(Object obj, OutputStreamWriter out, String varName) throws Exception {
        out.write(StringFormatter.scriptFormat(obj, varName, true, false, null));
    }

    public class WddxException
    extends ApplicationException {
        public Throwable rootCause;

        public WddxException(Throwable rootCause) {
            super(rootCause);
            this.rootCause = rootCause;
        }
    }

    public class UnableToConvertCFCException
    extends ApplicationException {
    }

    public class UnableToConvertUDFException
    extends ApplicationException {
    }
}

