/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFCookie;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.net.ThreadRequestException;
import coldfusion.util.URLEncoder;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Permission;
import java.util.Date;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public final class CookieTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfcookie");
    private String name;
    private String value = "";
    private int maxage = -1;
    private boolean secure = false;
    private String path = null;
    private String domain = null;
    public static int Max_Cookie_Age = 946080000;
    private boolean httponly = false;
    private boolean preservecase = false;
    private boolean encodevalue = true;
    private String samesite = "";

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSamesite(String samesite) {
        this.samesite = samesite;
    }

    public String getSamesite() {
        return this.samesite;
    }

    public void setValue(String value) {
        this.value = Utils.stripCRLF(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setExpires(Object e) {
        if (e instanceof Date) {
            long diff = ((Date)e).getTime() - System.currentTimeMillis();
            this.maxage = diff < 0L ? 0 : (int)((double)diff / 1000.0);
        } else if (e instanceof String) {
            if (((String)e).equalsIgnoreCase("now")) {
                this.maxage = 0;
            } else if (((String)e).equalsIgnoreCase("never")) {
                this.maxage = Max_Cookie_Age;
            } else {
                if (((String)e).equalsIgnoreCase("session")) {
                    return;
                }
                if (this.isDateFormat(e)) {
                    Date date = CFPage.ParseDateTime((String)e);
                    long diff = date.getTime() - System.currentTimeMillis();
                    this.maxage = diff < 0L ? 0 : (int)((double)diff / 1000.0);
                } else {
                    this.processDouble(e);
                }
            }
        } else if (e instanceof Number) {
            this.processDouble(e);
        } else {
            Date date = Cast._Date(e);
            long diff = date.getTime() - System.currentTimeMillis();
            this.maxage = diff < 0L ? 0 : (int)((double)diff / 1000.0);
        }
    }

    private void processDouble(Object e) {
        this.maxage = (int)(86400.0 * this.doubleValue(e));
        if (this.maxage < 0) {
            this.maxage = 0;
        }
    }

    public int getExpires() {
        return this.maxage;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setHttpOnly(boolean b) {
        this.httponly = b;
    }

    public boolean isHttpOnly() {
        return this.httponly;
    }

    public void setPreserveCase(boolean b) {
        this.preservecase = b;
    }

    public boolean isPreserveCase() {
        return this.preservecase;
    }

    public void setEncodeValue(boolean b) {
        this.encodevalue = b;
    }

    public boolean isEncodeValue() {
        return this.encodevalue;
    }

    public void setPath(String path) {
        this.path = Utils.stripCRLF(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setDomain(String domain) {
        this.domain = Utils.stripCRLF(domain);
    }

    public String getDomain() {
        return this.domain;
    }

    public int doStartTag() {
        this.onTagStart();
        FusionContext ctx = FusionContext.getCurrent();
        if (ctx.pageContext.isUnderCFThread() && ctx.getState() == null) {
            throw new ThreadRequestException("cookie");
        }
        if (!this.preservecase) {
            this.name = this.name.toUpperCase();
        }
        if (!this.validateCookieName(this.name)) {
            throw new CookieTagException(this.name);
        }
        CFCookie cookie = null;
        String cookieValue = this.value;
        if (this.encodevalue) {
            cookieValue = URLEncoder.encode(this.value);
        }
        cookie = new CFCookie(this.name, cookieValue, this.httponly, this.secure, this.maxage, this.domain, this.samesite);
        if (this.path == null) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            this.path = request.getContextPath() + "/";
        }
        cookie.setPath(this.path);
        try {
            Object[] keys = new String[]{this.name};
            ((NeoPageContext)this.pageContext).SymTab_setValidatedSplitNameInString("COOKIE", keys, (Object)cookie);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.onTagEnd();
        return 0;
    }

    private final boolean validateCookieName(String name) {
        return name != null && name.length() != 0 && name.indexOf(32) == -1 && name.indexOf(44) == -1 && name.indexOf(59) == -1 && !name.startsWith("$");
    }

    protected final double doubleValue(Object x) {
        return Cast._double(x);
    }

    private final boolean isDateFormat(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern perlPattern = null;
        String pattern = "\\d\\d?/\\d\\d?/\\d\\d(\\d\\d)?";
        try {
            perlPattern = compiler.compile(pattern);
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.matches((String)obj, perlPattern);
    }

    public class CookieTagException
    extends ApplicationException {
        public String name = "";

        public CookieTagException(String name) {
            this.name = name;
        }
    }
}

