/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.net.HttpTag;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.UnsupportedEncodingException;
import java.security.Permission;

public class HttpParamTag
extends ChildTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfhttpparam");
    protected String name;
    protected String type;
    protected Object value;
    protected String file;
    protected String mimeType;
    protected boolean encoded = true;
    private HttpTag parent;

    public HttpParamTag() {
        super(HttpTag.class);
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    protected void setAncestor(Tag t) {
        this.parent = (HttpTag)t;
    }

    public void setName(String o) {
        this.name = o;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String o) {
        this.type = Utils.stripCRLF(o);
    }

    public String getType() {
        return this.type;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public Object getValue() {
        return this.value;
    }

    public void setFile(String o) {
        this.file = o;
    }

    public String getFile() {
        return this.file;
    }

    public void setEncoded(boolean v) {
        this.encoded = v;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public void setMimeType(String type) {
        this.mimeType = Utils.stripCRLF(type);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.type == null) {
            throw new RequiredAttributesException("CFHTTPPARAM", "type");
        }
        if (this.value == null && !"File".equalsIgnoreCase(this.type)) {
            throw new RequiredAttributesException("CFHTTPPARAM", "value");
        }
        if (this.value != null && !(this.value instanceof String) && !"Body".equalsIgnoreCase(this.type)) {
            try {
                this.value = Cast._String(this.value);
            }
            catch (Exception e) {
                throw new IllegalAttributeValueException("CFHTTPPARAM", "value", RB.getString(HttpParamTag.class, "HttpParamTag.stringRequired"));
            }
        }
        if ("File".equalsIgnoreCase(this.type) && this.file == null) {
            throw new RequiredAttributesException("CFHTTPPARAM", "file");
        }
        if (this.mimeType != null && !"File".equalsIgnoreCase(this.type)) {
            throw new InvalidMimeAttributeException();
        }
        if ("URL".equalsIgnoreCase(this.type)) {
            this.parent.setQueryString(this.name, Utils.stripCRLF((String)this.value), this.encoded);
        } else if ("FormField".equalsIgnoreCase(this.type)) {
            this.parent.setFormData(this.name, (String)this.value, this.encoded);
        } else if ("Cookie".equalsIgnoreCase(this.type)) {
            this.parent.setCookie(this.name, Utils.stripCRLF((String)this.value), this.encoded);
        } else if ("CGI".equalsIgnoreCase(this.type)) {
            this.parent.setCGI(this.name, Utils.stripCRLF((String)this.value), this.encoded);
        } else if ("File".equalsIgnoreCase(this.type)) {
            this.parent.setFileName(this.name, this.file, this.mimeType);
        } else if ("Xml".equalsIgnoreCase(this.type)) {
            this.parent.setXMLData((String)this.value);
        } else if ("Header".equalsIgnoreCase(this.type)) {
            this.parent.setHeaderParam(this.name, Utils.stripCRLF((String)this.value));
        } else if ("Body".equalsIgnoreCase(this.type)) {
            try {
                this.parent.setBody(this.value);
            }
            catch (UnsupportedEncodingException e) {
                throw new JspException((Throwable)e);
            }
        } else {
            throw new InvalidTagAttributeException("CFHTTPPARAM", "type", this.type);
        }
        this.parent.setHttpParam(true);
        return 0;
    }

    @Override
    public void release() {
        this.name = null;
        this.type = null;
        this.value = null;
        this.file = null;
        this.mimeType = null;
        this.encoded = true;
        super.release();
        this.onTagEnd();
    }

    public class InvalidMimeAttributeException
    extends ApplicationException {
    }

    public class InvalidMethodException
    extends ApplicationException {
    }
}

