/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.log.CFLogs;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.TemplateException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.ScopeAwareTag;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class LocationTag
extends ScopeAwareTag {
    private static final long serialVersionUID = 1L;
    protected String url;
    protected boolean addtoken = true;
    private boolean setAddTokenCalled = false;
    protected int statusCode = 302;
    static Pattern cfTokenPattern;
    private PatternMatcher matcher = new Perl5Matcher();
    static final String[] hex;

    @Override
    public void release() {
        this.url = null;
        this.setAddTokenCalled = false;
        this.addtoken = true;
    }

    public void setUrl(String o) {
        this.url = Utils.stripCRLF(o);
    }

    public void setStatusCode(int statusCode) {
        if (statusCode < 300 || statusCode > 307) {
            if (this.calledName != null) {
                throw new IllegalAttributeValueException(true);
            }
            throw new IllegalAttributeValueException(false);
        }
        this.statusCode = statusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAddtoken(boolean o) {
        this.setAddTokenCalled = true;
        this.addtoken = o;
    }

    public boolean isAddtoken() {
        return this.addtoken;
    }

    public int doEndTag() throws JspException {
        if (!this.setAddTokenCalled && ServiceFactory.getSecurityService().isSecureProfile()) {
            this.addtoken = false;
        }
        if (this.url != null) {
            this.url = this.encodeControlChars(this.url);
        }
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        String encURL = this.url;
        if (this.addtoken) {
            Object tok = "";
            if (!this.containsCFTokens(this.url)) {
                try {
                    Map scope = this.getClientScope();
                    String urltoken = (String)scope.get("urltoken");
                    if (urltoken == null) {
                        scope = this.getSessionScope();
                        urltoken = (String)scope.get("urltoken");
                    }
                    if (urltoken != null) {
                        urltoken = this.stripJSessionId(urltoken);
                        tok = this.url.indexOf("?") == -1 ? "?" + urltoken : "&" + urltoken;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.url = this.url + (String)tok;
            if (!this.containsJ2eeTokens(this.url)) {
                this.url = res.encodeRedirectURL(this.url);
            }
            encURL = this.url;
        }
        try {
            res.setStatus(this.statusCode);
            res.setHeader("location", encURL);
            res.setHeader("Cache-Control", "no-cache");
            res.setHeader("Pragma", "no-cache");
        }
        catch (IllegalStateException e) {
            if (this.calledName != null) {
                throw new InvalidLocationException(true);
            }
            throw new InvalidLocationException(false);
        }
        throw new AbortException();
    }

    private boolean containsCFTokens(String url) {
        boolean bool = this.matcher.contains(url, cfTokenPattern);
        if (bool && CFLogs.SERVER_LOG.isDebugEnabled()) {
            CFLogs.SERVER_LOG.debug("CF session tokens found:" + url);
        }
        return bool;
    }

    private String stripJSessionId(String urlToken) {
        int jSessionIdBegin = urlToken.indexOf("jsessionid=");
        if (jSessionIdBegin != -1) {
            int jSessionIdEnd = urlToken.indexOf("&", jSessionIdBegin);
            if (jSessionIdBegin != 0 && urlToken.charAt(jSessionIdBegin - 1) == '&') {
                --jSessionIdBegin;
            }
            StringBuilder builder = new StringBuilder(urlToken);
            if (jSessionIdEnd == -1) {
                builder.replace(jSessionIdBegin, urlToken.length(), "");
            } else {
                builder.replace(jSessionIdBegin, jSessionIdEnd, "");
            }
            return builder.toString();
        }
        return urlToken;
    }

    private boolean containsJ2eeTokens(String url) {
        int semiColon = url.indexOf(";", 0);
        if (semiColon != -1 && semiColon != url.length() - 1) {
            String[] pathParams;
            int questionMark;
            String urlPathParams = (questionMark = url.indexOf("?", ++semiColon)) == -1 ? url.substring(semiColon) : url.substring(semiColon, questionMark);
            for (String param : pathParams = urlPathParams.split("&")) {
                if (!param.split("=")[0].equalsIgnoreCase("jsessionid")) continue;
                return true;
            }
        }
        return false;
    }

    private String encodeControlChars(String s) {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch < ' ') {
                sbuf.append(hex[ch]);
                continue;
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    static {
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f"};
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            cfTokenPattern = compiler.compile("[\\?&](CFID|CFTOKEN)=", 32769);
        }
        catch (MalformedPatternException e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public static class IllegalAttributeValueException
    extends ApplicationException {
        public String tagName = "cflocation tag";

        public IllegalAttributeValueException(boolean func) {
            if (func) {
                this.tagName = "location function";
            }
        }
    }

    public static class InvalidLocationException
    extends TemplateException {
        public String tagName = "cflocation";

        public InvalidLocationException(boolean func) {
            if (func) {
                this.tagName = "location";
            }
        }
    }

    public static class ClientScopeNotFoundException
    extends ApplicationException {
        ClientScopeNotFoundException() {
        }
    }
}

