/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security;

import coldfusion.runtime.Cast;
import coldfusion.runtime.SecurityTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.security.AuthenticateTag;
import coldfusion.util.MapUtils;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UserTag
extends GenericTag {
    String _username;
    String _password;
    AuthenticateTag _auth;
    Object _roles;

    @Override
    public void release() {
        this._username = null;
        this._password = null;
        this._roles = null;
        this._auth = null;
        this.onTagEnd();
    }

    public int doStartTag() {
        this.onTagStart();
        this._auth = (AuthenticateTag)UserTag.findAncestorWithClass((Tag)this, AuthenticateTag.class);
        this.setRoles();
        return 6;
    }

    private void setRoles() {
        ArrayList<Object> grps = null;
        if (this._roles instanceof List) {
            grps = (ArrayList<Object>)this._roles;
        } else {
            grps = new ArrayList<Object>(25);
            StringTokenizer stok = new StringTokenizer(Cast._String(this._roles), ",");
            while (stok.hasMoreElements()) {
                grps.add(stok.nextElement());
            }
        }
        SecurityTable tab = this.listToMap(grps);
        tab.setUserName(this._username);
        tab.setPassword(this._password);
        if (this._auth != null) {
            String authName = this._auth.getName();
            String authPwd = this._auth.getPassword();
            if (authName != null && this._username != null && !authName.equals(this._username)) {
                this._auth.setCredentialsUpdated(true);
            }
            this._auth.setName(this._username);
            this._auth.setPassword(this._password);
            this._auth.setRoles(tab);
        } else {
            this.fContext.setSecureTable(tab);
        }
    }

    public void setRoles(Object groups) {
        this._roles = groups;
    }

    public void setName(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    private SecurityTable listToMap(List ls) {
        if (ls == null) {
            return null;
        }
        SecurityTable m = new SecurityTable();
        m.setUserName(this._username);
        return (SecurityTable)MapUtils.listToMap(ls, m);
    }
}

