/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth;

import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.AuthorizationGrant;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.grant.AuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.grant.ClientCredentialsGrant;
import coldfusion.tagext.security.oauth.grant.RefreshTokenGrant;
import coldfusion.tagext.security.oauth.grant.facebook.FacebookAuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.grant.facebook.FacebookClientCredentialsGrant;
import coldfusion.tagext.security.oauth.grant.facebook.FacebookRefreshTokenGrant;
import coldfusion.tagext.security.oauth.grant.google.GoogleAuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.grant.google.GoogleClientCredentialsGrant;
import coldfusion.tagext.security.oauth.grant.google.GoogleRefreshTokenGrant;
import coldfusion.tagext.security.oauth.grant.microsoft.MicrosoftAuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.grant.microsoft.MicrosoftClientCredentialsGrant;
import coldfusion.tagext.security.oauth.grant.microsoft.MicrosoftRefreshTokenGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public enum AuthorizationGrantFactory {
    INSTANCE;


    public AuthorizationGrant getAuthorizationGrant(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OauthCredentials credentials) {
        return switch (credentials.getGranttype()) {
            case GrantType.AUTHORIZATION_CODE -> this.HandleAuthorizationCodeGrantFlow(httpServletRequest, httpServletResponse, credentials);
            case GrantType.CLIENT_CREDENTIALS -> this.HandleClientCredentialsGrantFlow(httpServletRequest, httpServletResponse, credentials);
            case GrantType.REFRESH_TOKEN -> this.HandleRefreshTokenGrantFlow(httpServletRequest, httpServletResponse, credentials);
            default -> throw new UnsupportedOperationException();
        };
    }

    private AuthorizationGrant HandleAuthorizationCodeGrantFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OauthCredentials credentials) {
        switch (credentials.getType()) {
            case GOOGLE: {
                return new GoogleAuthorizationCodeGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case FACEBOOK: {
                return new FacebookAuthorizationCodeGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case MICROSOFT: {
                return new MicrosoftAuthorizationCodeGrant(httpServletRequest, httpServletResponse, credentials);
            }
        }
        this.validateEndpoints(credentials);
        return new AuthorizationCodeGrant(httpServletRequest, httpServletResponse, credentials);
    }

    private AuthorizationGrant HandleClientCredentialsGrantFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OauthCredentials credentials) {
        switch (credentials.getType()) {
            case GOOGLE: {
                return new GoogleClientCredentialsGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case FACEBOOK: {
                return new FacebookClientCredentialsGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case MICROSOFT: {
                return new MicrosoftClientCredentialsGrant(httpServletRequest, httpServletResponse, credentials);
            }
        }
        return new ClientCredentialsGrant(httpServletRequest, httpServletResponse, credentials);
    }

    private AuthorizationGrant HandleRefreshTokenGrantFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, OauthCredentials credentials) {
        switch (credentials.getType()) {
            case GOOGLE: {
                return new GoogleRefreshTokenGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case FACEBOOK: {
                return new FacebookRefreshTokenGrant(httpServletRequest, httpServletResponse, credentials);
            }
            case MICROSOFT: {
                return new MicrosoftRefreshTokenGrant(httpServletRequest, httpServletResponse, credentials);
            }
        }
        return new RefreshTokenGrant(httpServletRequest, httpServletResponse, credentials);
    }

    private void validateEndpoints(OauthCredentials credentials) {
        if (OauthConstants.isNullOrEmpty(credentials.getAuthorizationEndpoint()) || OauthConstants.isNullOrEmpty(credentials.getTokenEndpoint())) {
            throw new OauthTag.OauthNoTypeAndEndpointsException();
        }
    }
}

