/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Struct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HttpHelper {
    public static String doGet(String uri, Map<String, String> headers) {
        String string;
        block9: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpGet request = new HttpGet(uri);
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
                string = HttpHelper.executeTheRequest(httpClient, (HttpUriRequest)request);
                if (httpClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error(e);
                    return null;
                }
            }
            httpClient.close();
        }
        return string;
    }

    public static String doPost(String uri, Map<String, String> headers, HttpEntity entity) {
        String string;
        block9: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpPost request = new HttpPost(uri);
                request.setEntity(entity);
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
                string = HttpHelper.executeTheRequest(httpClient, (HttpUriRequest)request);
                if (httpClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error(e);
                    return null;
                }
            }
            httpClient.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeTheRequest(CloseableHttpClient httpClient, HttpUriRequest request) throws IOException {
        StringBuilder response;
        block21: {
            response = new StringBuilder();
            BufferedReader bufferedReader = null;
            try (CloseableHttpResponse httpResponse = httpClient.execute(request);){
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null) break block21;
                try (InputStream inputStream = entity.getContent();){
                    String line;
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = bufferedReader.readLine()) != null) {
                        response.append(line);
                    }
                }
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        }
        return response.toString();
    }

    public static void parseURLParams(String urlParams, List<NameValuePair> parameters) {
        try {
            String[] pairs;
            for (String pair : pairs = urlParams.split("&")) {
                String[] nameValue = pair.split("=");
                parameters.add((NameValuePair)new BasicNameValuePair(nameValue[0], nameValue[1]));
            }
        }
        catch (IndexOutOfBoundsException | PatternSyntaxException e) {
            CFLogs.APPLICATION_LOG.debug(e);
        }
    }

    public static boolean isError(HttpServletRequest httpServletRequest) {
        return Objects.nonNull(httpServletRequest.getParameter("error"));
    }

    public static boolean isFirstCall(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameter("code") == null;
    }

    public static Struct handleError(HttpServletRequest httpServletRequest) {
        Struct response = new Struct();
        response.put("error", (Object)httpServletRequest.getParameter("error"));
        response.put("error_description", (Object)httpServletRequest.getParameter("error_description"));
        response.put("error_reason", (Object)httpServletRequest.getParameter("error_reason"));
        response.put("state", (Object)httpServletRequest.getParameter("state"));
        return response;
    }
}

