/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth;

import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.Struct;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.OauthCredentialsConsumer;
import coldfusion.tagext.security.oauth.ProviderConfigConsumer;
import coldfusion.tagext.security.oauth.VendorType;
import java.util.Map;
import java.util.Optional;

public class OauthCredentials {
    private String clientId;
    private String scope;
    private String state;
    private VendorType type = VendorType.OTHER;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String clientSecret;
    private String redirectUri;
    private String urlParams;
    private String apiVersion;
    private GrantType granttype = GrantType.AUTHORIZATION_CODE;
    private String refreshToken;
    private String tenant;
    private String clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private String clientAssertion;

    public OauthCredentials(Map<?, ?> details) {
        ValidatorFiller.INSTANCE.fillObject(this, details, OauthCredentialsConsumer.getInstance());
    }

    public OauthCredentials() {
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public VendorType getType() {
        return this.type;
    }

    public void setType(VendorType type) {
        this.type = type;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public GrantType getGranttype() {
        return this.granttype;
    }

    public void setGranttype(GrantType granttype) {
        this.granttype = granttype;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setProviderConfig(Struct providerConfig) {
        Optional.ofNullable(providerConfig).ifPresent(config -> ValidatorFiller.INSTANCE.fillObject(this, (Map)config, ProviderConfigConsumer.getInstance()));
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public void setClientAssertionType(String clientAssertionType) {
        this.clientAssertionType = clientAssertionType;
    }

    public String getClientAssertion() {
        return this.clientAssertion;
    }

    public void setClientAssertion(String clientAssertion) {
        this.clientAssertion = clientAssertion;
    }

    public void release() {
        this.clientId = null;
        this.scope = null;
        this.state = null;
        this.type = VendorType.OTHER;
        this.authorizationEndpoint = null;
        this.tokenEndpoint = null;
        this.redirectUri = null;
        this.clientSecret = null;
        this.granttype = GrantType.AUTHORIZATION_CODE;
        this.refreshToken = null;
        this.apiVersion = null;
        this.clientAssertion = null;
        this.clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    }
}

