/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.OauthCredentials;
import java.util.List;
import java.util.Optional;

public class ProviderConfigConsumer
extends ConsumerMap<OauthCredentials> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static volatile ProviderConfigConsumer consumer;

    private ProviderConfigConsumer() {
        this.put((Object)"apiversion", new ConsumerValidator<OauthCredentials, Object>((credentials, value) -> Optional.ofNullable(credentials.getType()).map(vendorType -> vendorType.toString().equals("facebook")).ifPresent(isFacebook -> {
            if (!isFacebook.booleanValue()) {
                throw new OauthTag.NotSupportedAttributeException("providerConfig.apiversion");
            }
            credentials.setApiVersion(this.cast.getStringProperty(value));
        }), List.of(NonEmptyStringValidator.INSTANCE)));
        this.put((Object)"tenant", new ConsumerValidator<OauthCredentials, Object>((credentials, value) -> Optional.ofNullable(credentials.getType()).map(vendorType -> vendorType.toString().equals("microsoft")).ifPresent(isMicrosoft -> {
            if (!isMicrosoft.booleanValue()) {
                throw new OauthTag.NotSupportedAttributeException("providerConfig.tenant");
            }
            credentials.setTenant(this.cast.getStringProperty(value));
        }), List.of(NonEmptyStringValidator.INSTANCE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProviderConfigConsumer getInstance() {
        if (consumer != null) return consumer;
        Class<ProviderConfigConsumer> clazz = ProviderConfigConsumer.class;
        synchronized (ProviderConfigConsumer.class) {
            if (consumer != null) return consumer;
            consumer = new ProviderConfigConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return consumer;
        }
    }
}

