/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.tagext.sql.QueryParamTag;
import coldfusion.tagext.sql.QueryTag;
import coldfusion.tagext.sql.StoredProcTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

public class ProcParamTag
extends QueryParamTag {
    private static final long serialVersionUID = 1L;
    private StoredProcTag storedProc;
    protected boolean out_value = false;
    protected boolean inParamType = false;
    protected String dbvarname;

    public ProcParamTag() {
        super(StoredProcTag.class);
    }

    @Override
    protected void setAncestor(Tag t) {
        this.storedProc = (StoredProcTag)t;
    }

    public void setType(String t) {
        if ("OUT".equalsIgnoreCase(t) || "INOUT".equalsIgnoreCase(t)) {
            this.out_value = true;
        }
        if ("IN".equalsIgnoreCase(t) || "INOUT".equalsIgnoreCase(t)) {
            this.inParamType = true;
        }
    }

    public void setDbvarname(String varname) {
        this.dbvarname = varname;
    }

    public void setVariable(String n) {
        this.setId(n);
    }

    @Override
    public void release() {
        this.out_value = false;
        this.inParamType = false;
        this.dbvarname = null;
        super.release();
        this.onTagEnd();
    }

    protected void validate() throws JspException {
        if (!this.isNull && this.value == null && this.inParamType) {
            throw new RequiredAttributesException("CFPROCPARAM", "value");
        }
        if (this.isNull) {
            this.value = null;
            this.scale = -1;
        } else if (this.maxlength >= 0 && this.sqltype != 2 && this.sqltype != 3 && (this.value instanceof String && ((String)this.value).length() > this.maxlength || this.value instanceof char[] && ((char[])this.value).length > this.maxlength)) {
            throw new QueryParamTag.InvalidDataException(this, this.value, this.maxlength);
        }
        if (this.sqltype != 2 && this.sqltype != 3) {
            this.scale = -1;
        }
        if ((this.sqltype == 92 || this.sqltype == 93 || this.sqltype == 91) && this.value != null) {
            this.value = QueryTag.processSpecialSqlTypes(this.value, this.sqltype);
        }
    }

    @Override
    public int doStartTag() throws JspException {
        this.onTagStart();
        this.validate();
        this.impl = this.storedProc.getSqlImpl();
        this.storedProc.registerParameter(this);
        if (this.value != null && !this.out_value || this.value == null && this.isNull && !this.out_value) {
            this.impl.setInParam(this.value, this.sqltype, this.scale, this.sqltype_name, this.dbvarname);
        } else if (this.value != null && this.out_value || this.value == null && this.isNull && this.out_value) {
            this.impl.setInOutParam(this.value, this.sqltype, this.scale, this.sqltype_name, this.dbvarname);
        } else if (this.out_value) {
            this.impl.setOutParam(this.sqltype, this.scale, this.sqltype_name, this.dbvarname);
        }
        return 0;
    }
}

