/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.runtime.DatabaseException;
import coldfusion.sql.SqlImpl;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.sql.QueryTag;
import coldfusion.tagext.sql.QueryUtils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.StringTokenizer;

public class QueryParamTag
extends ChildTag {
    private static final long serialVersionUID = 1L;
    public static final int DEF_SCALE = 0;
    public static final int DEF_MAXLENGTH = -1;
    protected Object value;
    protected String sqltype_name = "CF_SQL_CHAR";
    protected int sqltype = 1;
    protected int scale = 0;
    protected int maxlength = -1;
    protected boolean isNull = false;
    protected boolean isList = false;
    protected String sep = ",";
    protected SqlImpl impl = null;
    private QueryTag t;

    public QueryParamTag() {
        super(QueryTag.class);
    }

    protected QueryParamTag(Class ancestorClass) {
        super(ancestorClass);
    }

    @Override
    protected void setAncestor(Tag t) {
        this.t = (QueryTag)t;
    }

    protected QueryTag getAncester() {
        return this.t;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    public Object getValue() {
        return this.value;
    }

    public void setCfsqltype(String s) {
        this.sqltype_name = s.trim();
        if ((s = s.trim()) == null) {
            this.sqltype_name = "CF_SQL_CHAR";
            this.sqltype = 1;
        } else {
            this.sqltype = QueryUtils.resolveSqlType(s);
        }
        if (this.sqltype == 0) {
            throw new QueryUtils.QueryMetadataException("CFSQLType", s);
        }
    }

    public int getCfsqltype() {
        return this.sqltype;
    }

    public String getSqltypename() {
        return this.sqltype_name;
    }

    public void setScale(int s) {
        this.scale = s;
    }

    public int getScale() {
        return this.scale;
    }

    public void setMaxlength(int len) {
        this.maxlength = len;
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public void setNull(boolean b) {
        this.isNull = b;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setList(boolean b) {
        this.isList = b;
    }

    public boolean isList() {
        return this.isList;
    }

    public void setSeparator(String s) {
        this.sep = s;
    }

    public String getSeparator() {
        return this.sep;
    }

    @Override
    public void release() {
        this.value = null;
        this.sqltype_name = "CF_SQL_CHAR";
        this.sqltype = 1;
        this.scale = 0;
        this.maxlength = -1;
        this.isNull = false;
        this.isList = false;
        this.sep = ",";
        this.impl = null;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.impl = this.t.getSqlImpl();
        JspWriter writer = null;
        if (this.pageContext != null) {
            writer = this.pageContext.getOut();
        }
        try {
            if (this.isList && this.value instanceof String) {
                StringTokenizer tok = new StringTokenizer((String)this.value, this.sep);
                int i = 0;
                int count = tok.countTokens();
                if (count == 0) {
                    if (writer != null) {
                        writer.print('?');
                    }
                    this.setInParam("", 1, this.scale, this.sqltype_name);
                } else {
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken();
                        if (writer != null) {
                            writer.print('?');
                        }
                        if (i < count - 1 && writer != null) {
                            writer.print(',');
                        }
                        this.setInParam(token, this.sqltype, this.scale, this.sqltype_name);
                        ++i;
                    }
                }
            } else {
                if (writer != null) {
                    writer.print('?');
                }
                this.setInParam(this.value, this.sqltype, this.scale, this.sqltype_name);
            }
        }
        catch (Exception ex) {
            throw new OutputException(ex);
        }
        return 0;
    }

    protected void setInParam(Object v, int stype, int sc, String stype_name) throws Exception {
        if (this.isNull) {
            v = null;
            sc = -1;
        } else if (this.maxlength >= 0 && (v instanceof String && ((String)v).length() > this.maxlength || v instanceof char[] && ((char[])v).length > this.maxlength)) {
            throw new InvalidDataException(v, this.maxlength);
        }
        if (stype != 2 && stype != 3) {
            sc = -1;
        }
        this.value = (this.sqltype == 92 || this.sqltype == 93 || this.sqltype == 91) && v != null ? QueryTag.processSpecialSqlTypes(v, stype) : v;
        this.impl.setInParam(this.value, stype, sc, stype_name, null);
    }

    public class InvalidDataException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public Object value;
        public int maxlength;

        InvalidDataException(Object value, int maxlength) {
            this.value = value;
            this.maxlength = maxlength;
        }
    }

    public class InvalidDataTypeException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public Object value;
        public String sql_type;

        InvalidDataTypeException(Object value, String sql_type) {
            this.value = value;
            this.sql_type = sql_type;
        }
    }
}

