/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UTCOleDateTime;
import coldfusion.runtime.Variable;
import coldfusion.runtime.VariableScope;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.runtime.locale.CFLocaleMgrException;
import coldfusion.server.DataSourceService;
import coldfusion.server.DebuggingService;
import coldfusion.server.ORMService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFNoResultSetTable;
import coldfusion.sql.CachedQuery;
import coldfusion.sql.CopyOnWriteQueryTable;
import coldfusion.sql.DataSrcImpl;
import coldfusion.sql.InParameter;
import coldfusion.sql.JdbcImpl;
import coldfusion.sql.ParameterList;
import coldfusion.sql.QueryDetails;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.SqlImpl;
import coldfusion.sql.Table;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.sql.QueryUtils;
import coldfusion.tagext.sql.TransactionTag;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.security.Permission;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class QueryTag
extends GenericTag
implements BodyTag,
TryCatchFinally {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfquery");
    private static final String BLOCKFACTOR = "blockFactor";
    private static final String CACHEMAXIDLETIME = "CACHEMAXIDLETIME";
    private static final String CACHEDAFTER = "CACHEDAFTER";
    private static final String CACHEDWITHIN = "CACHEDWITHIN";
    private static final String CACHEID = "CACHEID";
    private static final String CACHEREGION = "CACHEREGION";
    private static final String CLIENTINFO = "CLIENTINFO";
    private static final String DBTYPE = "DBTYPE";
    private static final String DATASOURCE = "DATASOURCE";
    private static final String DBNAME = "DBNAME";
    private static final String DEBUG = "DEBUG";
    private static final String FETCHCLIENTINFO = "FETCHCLIENTINFO";
    private static final String MAXROWS = "MAXROWS";
    private static final String PASSWORD = "PASSWORD";
    private static final String RESULT = "RESULT";
    private static final String RETURN_TYPE = "RETURNTYPE";
    private static final String TIMEOUT = "TIMEOUT";
    private static final String USERNAME = "USERNAME";
    private static final String DISABLEAUTOGENKEYS = "DISABLEAUTOGENKEYS";
    private static final String ARRAY = "array";
    private static final String STRUCT = "struct";
    private static final String JSON_ARRAY = "json/array";
    private static final String JSON_STRUCT = "json/struct";
    protected Object datasource;
    protected String dbtype;
    protected String sql_atr;
    protected String database;
    protected String username;
    protected String password;
    protected Integer maxrows;
    protected Integer blockfactor;
    protected Integer timeout;
    protected Long cacheMaxIdleTime;
    protected Date cachedafter;
    protected Long cachedwithin;
    protected String cacheRegion;
    protected String cacheId;
    protected String name;
    protected String result = null;
    protected String returnType = null;
    protected boolean cached;
    protected boolean fetchClientInfo = false;
    protected Struct clientInfo = null;
    private String defaultCatalog;
    private static final Map<Integer, Object> queryLockMap = new ConcurrentHashMap<Integer, Object>();
    protected int debugState = -1;
    protected SqlImpl impl = new SqlImpl();
    protected DataSrcImpl dimpl = null;
    private static final int[] intar = new int[]{0};
    private boolean calledAsFunction = false;
    private Exception loc = null;
    protected Table resultTable = null;
    private long startTime = 0L;
    protected int rowCount = 0;
    protected Map autoKeyMap = null;
    private Struct ormOptions = null;
    private final String hqlDbType = "HQL";
    private boolean disableAutoGenKeys = false;
    private volatile int count = 0;
    private static final String maskDsns = System.getProperty("coldfusion.query.mask.dsn");
    private static final String col = System.getProperty("coldfusion.query.mask.column");
    private static final String mask = System.getProperty("coldfusion.query.mask");

    public void setClientInfo(Struct clientInfo) {
        this.clientInfo = clientInfo;
    }

    public Struct getClientInfo() {
        return this.clientInfo;
    }

    public void setFetchClientInfo(boolean fetch) {
        this.fetchClientInfo = fetch;
    }

    public boolean isFetchClientInfo() {
        return this.fetchClientInfo;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    protected SqlImpl getSqlImpl() {
        return this.impl;
    }

    @Override
    public void setPageContext(PageContext pc) {
        this.dimpl = DataSrcImpl.getSqlProxy();
        super.setPageContext(pc);
    }

    public void setOrmOptions(Struct ormOptions) {
        this.ormOptions = ormOptions;
    }

    public void setName(String n) {
        this.name = n;
        this.impl.setQueryName(n);
    }

    public String getName() {
        return this.name;
    }

    public void setDatasource(Object ds) {
        this.datasource = ds;
    }

    public Object getDatasource() {
        return this.datasource;
    }

    public void setDisableAutoGenKeys(boolean disableAutoGenKeys) {
        this.disableAutoGenKeys = disableAutoGenKeys;
        this.impl.setDisableAutoGenKeys(disableAutoGenKeys);
    }

    public boolean getDisableAutoGenKeys() {
        return this.disableAutoGenKeys;
    }

    public void setDbtype(String dt) {
        this.dbtype = dt;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setSql(String s) {
        this.sql_atr = s;
    }

    public String getSql() {
        return this.sql_atr;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public String getUsername() {
        return this.username;
    }

    public void setReturnType(String r) {
        this.returnType = r;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setCacheRegion(String region) {
        if (region == null || region.trim().length() == 0) {
            throw new InvalidAttributeValueException("cacheregion");
        }
        this.cacheRegion = region;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheId(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new InvalidAttributeValueException("cacheid");
        }
        this.cacheId = id;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setMaxrows(int r) {
        this.maxrows = new Integer(r);
    }

    public Integer getMaxrows() {
        return this.maxrows;
    }

    public void setBlockfactor(int b) {
        this.blockfactor = new Integer(b);
    }

    public Integer getBlockfactor() {
        return this.blockfactor;
    }

    public void setTimeout(int t) {
        this.timeout = new Integer(t);
    }

    public void setDbname(String db) {
        if (db == null || db.trim().length() == 0) {
            throw new InvalidAttributeValueException("dbname");
        }
        this.database = db;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setCachemaxidletime(double days) {
        this.cacheMaxIdleTime = (long)(days * 8.64E7);
    }

    public Long getCachemaxidletime() {
        return this.cacheMaxIdleTime;
    }

    public void setCachedafter(Date c) {
        this.cachedafter = c;
    }

    public Date getCachedafter() {
        return this.cachedafter;
    }

    public void setCachedwithin(double days) {
        this.cachedwithin = (long)(days * 8.64E7);
    }

    public Long getCachedwithin() {
        return this.cachedwithin;
    }

    public void setResult(String s) {
        this.result = s;
    }

    public void setDebug(boolean d) {
        this.debugState = d ? 1 : 0;
    }

    public int getDebug() {
        return this.debugState;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    protected Tag findTransactionTag() {
        Object tag;
        TransactionTag tg = TransactionTag.getCurrent();
        if (tg != null) {
            return tg;
        }
        Object object = tag = this.calledAsFunction ? FusionContext.getCurrent().pageContext.getParentTag() : this.getParent();
        while (tag != null && !(tag instanceof TransactionTag)) {
            tag = tag.getParent();
        }
        return tag;
    }

    public QueryTag() {
    }

    public QueryTag(Map queryOptions) {
        Object debugTemp;
        Object cInfo;
        Object cWithin;
        Object cafter;
        Object cmaxIdleTime;
        Object tout;
        Object bFactor;
        Object mulRows;
        this.calledAsFunction = true;
        String queryName = (String)queryOptions.get("queryName");
        this.setName(queryName);
        if (this.count > 10000) {
            this.count = 0;
        }
        this.dimpl = DataSrcImpl.getSqlProxy();
        this.pageContext = FusionContext.getCurrent().pageContext;
        if (queryOptions == null) {
            return;
        }
        this.datasource = queryOptions.get(DATASOURCE);
        this.dbtype = (String)queryOptions.get(DBTYPE);
        this.database = (String)queryOptions.get(DBNAME);
        this.username = (String)queryOptions.get(USERNAME);
        this.password = (String)queryOptions.get(PASSWORD);
        if (queryOptions.get(DISABLEAUTOGENKEYS) != null) {
            this.disableAutoGenKeys = Cast._boolean(queryOptions.get(DISABLEAUTOGENKEYS).toString());
            this.impl.setDisableAutoGenKeys(this.disableAutoGenKeys);
        }
        if ((mulRows = queryOptions.get(MAXROWS)) != null) {
            this.maxrows = Cast._int(mulRows);
        }
        if ((bFactor = queryOptions.get(BLOCKFACTOR)) != null) {
            this.blockfactor = Cast._int(bFactor);
        }
        if ((tout = queryOptions.get(TIMEOUT)) != null) {
            this.timeout = Cast._int(tout);
        }
        if ((cmaxIdleTime = queryOptions.get(CACHEMAXIDLETIME)) != null) {
            this.setCachemaxidletime(Cast._double(cmaxIdleTime));
        }
        if ((cafter = queryOptions.get(CACHEDAFTER)) != null) {
            this.cachedafter = (Date)cafter;
        }
        if ((cWithin = queryOptions.get(CACHEDWITHIN)) != null) {
            this.setCachedwithin(Cast._double(cWithin));
        }
        this.cacheRegion = (String)queryOptions.get(CACHEREGION);
        this.cacheId = (String)queryOptions.get(CACHEID);
        this.result = (String)queryOptions.get(RESULT);
        this.returnType = (String)queryOptions.get(RETURN_TYPE);
        Object fClientInfo = queryOptions.get(FETCHCLIENTINFO);
        if (fClientInfo != null) {
            this.fetchClientInfo = Cast._boolean(fClientInfo);
        }
        if ((cInfo = queryOptions.get(CLIENTINFO)) != null) {
            this.clientInfo = (Struct)cInfo;
        }
        if ((debugTemp = queryOptions.get(DEBUG)) != null) {
            boolean d = Cast._boolean(debugTemp);
            this.debugState = d ? 1 : 0;
        }
    }

    protected void validate() throws JspException {
        int num;
        Map appSettings;
        String appName;
        ApplicationScope appScope;
        TransactionTag txn = (TransactionTag)this.findTransactionTag();
        if (this.datasource == null && (appScope = ApplicationScopeTracker.getApplicationScope(appName = FusionContext.getCurrent().getApplicationName())) != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            Object appDsObj = appSettings.get("datasource");
            if (appDsObj instanceof Map) {
                Map dsMap = (Map)appDsObj;
                this.datasource = dsMap.get("name");
                String dsUsername = (String)dsMap.get("username");
                String dsPassword = (String)dsMap.get("password");
                if (dsUsername != null && dsUsername.length() > 0) {
                    this.username = dsUsername;
                    this.password = dsPassword == null ? "" : dsPassword;
                }
            } else {
                this.datasource = appDsObj;
            }
        }
        if (txn != null && !"query".equalsIgnoreCase(this.dbtype)) {
            try {
                txn.verifyDataSrc(this.datasource, this.username, this.password);
                txn.setCommitPending(true);
            }
            catch (SQLException ex) {
                throw new DataSourceVerificationException((Throwable)ex, this.datasource);
            }
        }
        this.impl.setDebug(this.debugState != 0);
        if (this.dimpl == null) {
            this.dimpl = DataSrcImpl.getSqlProxy();
        }
        Object dsn = this.dimpl.getDatasrc();
        if (this.dbtype != null && this.dbtype.equalsIgnoreCase("query")) {
            JdbcImpl jimpl = new JdbcImpl();
            jimpl.setDriver("coldfusion.sql.imq.jdbcDriver");
            jimpl.setUrl("jdbc:imq:.");
            this.datasource = "";
            jimpl.setProperty("page_context", this.pageContext);
            this.impl.setConnectionSource(jimpl);
            this.impl.setUsername("");
            this.impl.setPassword("");
            this.impl.setCloseConnection(true);
            this.impl.markNoMonitor();
        } else {
            if (this.datasource == null) {
                this.datasource = this.datasource == null ? "" : this.datasource;
                throw new InvalidTagAttributeException("datasource", this.datasource, "tag " + this.tagNameFromClass());
            }
            if (!this.datasource.equals(dsn)) {
                this.dimpl.setDatasrc(this.datasource);
                this.impl.setConnectionSource(this.dimpl);
                this.impl.setCloseConnection(false);
            } else {
                this.impl.setConnectionSource(this.dimpl);
                this.impl.setCloseConnection(false);
            }
        }
        if (this.username != null) {
            this.impl.setUsername(this.username);
        }
        if (this.password != null) {
            this.impl.setPassword(this.password);
        }
        if (this.maxrows != null && (num = this.maxrows.intValue()) >= 0) {
            this.impl.setMaxrows(this.maxrows);
        }
        if (this.blockfactor != null) {
            this.impl.setFetchsize(this.blockfactor);
        }
        if (this.timeout != null) {
            this.impl.setTimeout(this.timeout);
        }
        if (this.sql_atr != null && this.sql_atr.length() != 0) {
            this.impl.setSql(this.sql_atr);
        }
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.initDebugSetting();
        if (this.sql_atr != null && this.sql_atr.length() != 0) {
            this.doValidate();
            return 0;
        }
        return 2;
    }

    protected void initDebugSetting() {
        this.impl.setLineNo(this.lineNo);
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        this.startTime = System.currentTimeMillis();
        if (this.debugState > 0 || this.debugState == -1 && debuggingService != null && debuggingService.check(4)) {
            this.loc = new Exception();
        }
    }

    @Override
    public void doInitBody() throws JspException {
        if (this.bodyContent instanceof CFOutput) {
            ((CFOutput)this.bodyContent).cfoutput(true);
        }
    }

    @Override
    public int doAfterBody() throws JspException {
        if (!"HQL".equalsIgnoreCase(this.dbtype)) {
            this.doValidate();
        }
        if (this.bodyContent != null) {
            this.impl.setSql(this.bodyContent.getString());
        } else {
            this.impl.setSql(this.sql_atr);
        }
        return 0;
    }

    protected void setSqlStringToImpl(String sqlStr) {
        this.impl.setSql(sqlStr);
    }

    protected void doValidate() throws JspException {
        this.validate();
        try {
            this.impl.validate();
            if (this.database != null) {
                this.defaultCatalog = this.impl.getConnection().getCatalog();
                this.impl.getConnection().setCatalog(this.database);
            }
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex, this.datasource.toString());
        }
    }

    public int doEndTag() throws JspException {
        Object result = this.startQueryExecution();
        if (this.returnType != null && result instanceof QueryTable) {
            QueryTable qTable = (QueryTable)result;
            result = QueryUtils.handleReturnType(result, this.returnType);
        }
        if (this.name != null) {
            this.pageContext.setAttribute(this.name, result);
        }
        this.onTagEnd();
        return 6;
    }

    protected Object startQueryExecution() {
        boolean inTxn = this.findTransactionTag() != null;
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        Object qrrResult = null;
        this.impl.setResultSetList(intar);
        try {
            long startTime = System.currentTimeMillis();
            if ("HQL".equalsIgnoreCase(this.dbtype)) {
                ORMService ormService;
                String dsname;
                String string = dsname = this.datasource == null ? null : this.datasource.toString();
                if (dsname != null) {
                    if (this.ormOptions == null) {
                        this.ormOptions = new Struct();
                    }
                    this.ormOptions.put("datasource", (Object)dsname);
                }
                if ((ormService = ServiceFactory.getORMService(true)) != null) {
                    qrrResult = ormService._executeQuery(this.impl.getSql(), this.extractQueryParams(false), false, this.ormOptions);
                }
            } else if (this.cacheMaxIdleTime != null || this.cachedafter != null || this.cachedwithin != null || this.cacheRegion != null) {
                this.setupCachedQuery(inTxn);
            } else {
                Table resTable = this.executeQuery(inTxn);
                this.setQueryResult(resTable);
            }
            long endTime = System.currentTimeMillis();
            if (debuggingService != null && debuggingService.getDebugger() != null && (this.debugState > 0 || this.debugState == -1 && debuggingService.check(4))) {
                Vector vParameters = this.extractQueryParams(true);
                debuggingService.getDebugger().sql(this.impl.getSql(), this.name, this.datasource, this.resultTable, this.loc, this.rowCount, startTime, endTime, this.cached, vParameters);
            }
            Long time = this.cached ? new Long(0L) : new Long(endTime - startTime);
            Struct s = this.prepareExtendedMetaDataInformation();
            s.put("EXECUTIONTIME", (Object)time);
            QueryTag.storeExtendedMetaDataInformation(this.resultTable, s);
            if (this.result != null) {
                this.pageContext.setAttribute(this.result, (Object)s);
            } else {
                VariableScope vs = ((NeoPageContext)this.pageContext).getVariableScope();
                Variable et = vs.bindInternal("CFQUERY.EXECUTIONTIME");
                et.set(time);
            }
        }
        catch (RequestTimedOutException ex) {
            throw this.setRequestTimedOutTagName(ex);
        }
        catch (SQLException ex) {
            throw new DatabaseQueryException((Throwable)ex, this.impl, this.datasource);
        }
        if ("HQL".equalsIgnoreCase(this.dbtype)) {
            return qrrResult;
        }
        return this.resultTable;
    }

    private Vector extractQueryParams(boolean debug) {
        ParameterList pl = this.impl.getParamList();
        ArrayList list = pl == null ? null : pl.getAllParameters();
        Vector<Object> vParameters = new Vector<Object>();
        int size = list == null ? 0 : list.size();
        for (int j = 0; j < size; ++j) {
            Object valObj;
            Struct stParam = new Struct();
            InParameter param = (InParameter)list.get(j);
            Object object = valObj = param.getObject() == null ? "" : param.getObject();
            if (debug) {
                stParam.put("value", valObj);
                stParam.put("sqlType", (Object)param.getSqltypeName());
                vParameters.add(stParam);
                continue;
            }
            vParameters.add(valObj);
        }
        return vParameters;
    }

    protected Struct prepareExtendedMetaDataInformation() {
        ParameterList pl;
        Struct s = new Struct();
        s.put("SQL", (Object)this.impl.getSql());
        s.put("RECORDCOUNT", (Object)new Integer(this.rowCount));
        s.put("CACHED", (Object)String.valueOf(this.cached));
        if (this.autoKeyMap != null) {
            s.putAll(this.autoKeyMap);
        }
        if ((pl = this.impl.getParamList()) != null) {
            ArrayList list = pl.getAllParameters();
            int size = list == null ? 0 : list.size();
            Array myarray = new Array();
            for (int j = 0; j < size; ++j) {
                Object valObj = ((InParameter)list.get(j)).getObject();
                myarray.add(valObj == null ? "" : valObj);
            }
            s.put("SQLPARAMETERS", (Object)myarray);
        }
        if (this.resultTable != null && this.result != null) {
            s.put("COLUMNLIST", (Object)Utils.arrayToString(this.resultTable.getColumnNames(), ",", true, true));
        }
        this.fetchClientInfo(s);
        return s;
    }

    public void fetchClientInfo(Struct s) {
        if (this.fetchClientInfo) {
            if (this.dbtype != null && this.dbtype.equalsIgnoreCase("query")) {
                throw new UnsupportedQoQOperationException();
            }
            try {
                s.put(CLIENTINFO, (Object)this.impl.getClientInfo());
            }
            catch (SQLException se) {
                throw new ConnectionException((Throwable)se);
            }
            catch (Exception e) {
                throw new ClientInfoException((Throwable)e);
            }
        }
    }

    private static void storeExtendedMetaDataInformation(Table resultTable, Struct metadata) {
        QueryTable qtable;
        ResultSetMetaData rMeta;
        if (resultTable != null && resultTable instanceof QueryTable && (rMeta = (qtable = (QueryTable)resultTable).getMetaData()) != null && rMeta instanceof QueryTableMetaData) {
            QueryTableMetaData qMeta = (QueryTableMetaData)rMeta;
            qMeta.setExtendedMetaData(metadata);
        }
    }

    @Override
    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    @Override
    public void doFinally() {
        block7: {
            try {
                if (this.bodyContent instanceof CFOutput) {
                    ((CFOutput)this.bodyContent).cfoutput(false);
                }
                if (this.impl.getParamList() != null) {
                    this.impl.getParamList().clear();
                }
                if (this.database == null || this.defaultCatalog == null) break block7;
                try {
                    this.impl.getConnection().setCatalog(this.defaultCatalog);
                }
                catch (SQLException sqle) {
                    throw new DataSourceException(sqle, this.datasource.toString());
                }
            }
            finally {
                this.release();
            }
        }
    }

    private boolean toCacheQuery(boolean bCachedAfter, boolean bCachedWithin, boolean bCacheMaxIdleTime) {
        if (bCachedAfter) {
            return true;
        }
        if (this.cachedafter != null) {
            return false;
        }
        return bCachedWithin || bCacheMaxIdleTime || this.cacheRegion != null;
    }

    private boolean reRunCachedQueryWithCachedWithin(CachedQuery cachedQuery, long currentTimeStamp) {
        return this.cachedwithin == 0L || currentTimeStamp - cachedQuery.getCreationTime() > this.cachedwithin;
    }

    private boolean reRunCachedQueryWithCacheMaxIdleTime(CachedQuery cachedQuery, long currentTimeStamp) {
        return currentTimeStamp - cachedQuery.getLastAccessTime() > this.cacheMaxIdleTime;
    }

    private boolean reRunCachedQuery(CachedQuery cachedQuery, boolean bCachedWithin, boolean bCachedMaxIdleTime) {
        long currentTimeStamp = System.currentTimeMillis();
        if (bCachedWithin && bCachedMaxIdleTime) {
            return this.reRunCachedQueryWithCachedWithin(cachedQuery, currentTimeStamp) && this.reRunCachedQueryWithCacheMaxIdleTime(cachedQuery, currentTimeStamp);
        }
        if (bCachedWithin) {
            return this.reRunCachedQueryWithCachedWithin(cachedQuery, currentTimeStamp);
        }
        if (bCachedMaxIdleTime) {
            return this.reRunCachedQueryWithCacheMaxIdleTime(cachedQuery, currentTimeStamp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupCachedQuery(boolean inTxn) throws SQLException {
        Object storedCachedQuery;
        this.impl.setIsCached(true);
        QueryDetails details = this.getQueryDetails();
        DataSourceService dataSourceService = ServiceFactory.getDataSourceService();
        CachedQuery cachedQuery = null;
        if (this.cacheRegion == null) {
            this.cacheRegion = "QUERY";
        }
        if ((storedCachedQuery = dataSourceService.getCachedQuery(details, this.cacheRegion, this.cachedwithin)) != null) {
            cachedQuery = (CachedQuery)storedCachedQuery;
        }
        long currentTimeStamp = System.currentTimeMillis();
        boolean bCachedAfter = this.cachedafter != null && this.cachedafter.getTime() < currentTimeStamp;
        boolean bCachedWithin = this.cachedwithin != null && this.cachedwithin >= 0L;
        boolean bCacheMaxIdleTime = this.cacheMaxIdleTime != null && this.cacheMaxIdleTime >= 0L;
        boolean rerunCachedQuery = false;
        boolean toBeCached = this.toCacheQuery(bCachedAfter, bCachedWithin, bCacheMaxIdleTime);
        if (cachedQuery != null) {
            rerunCachedQuery = this.reRunCachedQuery(cachedQuery, bCachedWithin, bCacheMaxIdleTime);
        }
        try {
            if (cachedQuery != null && toBeCached && !rerunCachedQuery) {
                ParameterList tempList = cachedQuery.getParameterList();
                if (tempList != null) {
                    this.impl.setParamList((ParameterList)tempList.clone());
                }
                this.cached = true;
            } else {
                Table resTable = null;
                if (toBeCached) {
                    Object object;
                    int hashCode = details.hashCode();
                    Object lock = queryLockMap.get(hashCode);
                    if (lock == null) {
                        object = queryLockMap;
                        synchronized (object) {
                            lock = queryLockMap.get(hashCode);
                            if (lock == null) {
                                lock = new Object();
                                queryLockMap.put(hashCode, lock);
                            }
                        }
                    }
                    object = lock;
                    synchronized (object) {
                        CFPage.checkRequestTimeout("CFQUERY");
                        if (cachedQuery == null || rerunCachedQuery) {
                            hashCode = details.getHashcode2();
                            resTable = this.executeQuery(inTxn);
                            if (toBeCached) {
                                cachedQuery = this.getCacheWrapper(details);
                                cachedQuery.setParameterList(details.getParamList());
                                if (resTable != null) {
                                    resTable.setCached(true);
                                    cachedQuery.setResult(resTable);
                                }
                                cachedQuery.setStats(this.impl.getQueryStat());
                                cachedQuery.refresh();
                                dataSourceService.setCachedQuery(details, hashCode, cachedQuery, this.cachedwithin, bCachedAfter, this.cacheId, this.cacheRegion, this.cacheMaxIdleTime);
                            }
                        }
                    }
                }
                resTable = this.executeQuery(inTxn);
                if (cachedQuery == null) {
                    cachedQuery = this.getCacheWrapper(details);
                    cachedQuery.setParameterList(details.getParamList());
                }
                cachedQuery.setResult(resTable);
                if (cachedQuery == null) {
                    this.setQueryResult(resTable);
                }
            }
            if (cachedQuery != null) {
                Table temp = cachedQuery.getResult();
                if (temp instanceof QueryTable) {
                    CopyOnWriteQueryTable cowQueryTable = new CopyOnWriteQueryTable((QueryTable)temp);
                    this.setQueryResult((Table)CFPage.Duplicate(cowQueryTable));
                } else {
                    this.setQueryResult((Table)CFPage.Duplicate(temp));
                }
                cachedQuery.setLastAccessTime();
                if (cachedQuery.getStats() != null) {
                    cachedQuery.getStats().updateHitCount();
                }
            }
        }
        catch (RequestTimedOutException ex) {
            if (cachedQuery.getResult() == null) {
                dataSourceService.removeCachedQuery(details, this.cacheId, this.cacheRegion);
            }
            throw ex;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeWrapper(ex);
        }
    }

    protected Table executeQuery(boolean inTxn) throws SQLException {
        if (this.dbtype != null && this.dbtype.equalsIgnoreCase("query")) {
            this.clientInfo = null;
        }
        Table tbl = this.impl.execute(inTxn, this.clientInfo);
        return tbl;
    }

    protected RequestTimedOutException setRequestTimedOutTagName(RequestTimedOutException ex) {
        ex.tname = "CFQUERY";
        return ex;
    }

    protected static Object processSpecialSqlTypes(Object v, int stype) {
        Date theDate = Cast._Date(v);
        if (theDate instanceof UTCOleDateTime) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(theDate);
            theDate = new Date(theDate.getTime() - (long)cal.get(15) - (long)cal.get(16));
        }
        switch (stype) {
            case 91: {
                v = theDate;
                break;
            }
            case 92: {
                v = new Time(theDate.getTime());
                break;
            }
            case 93: {
                v = new Timestamp(theDate.getTime());
            }
        }
        return v;
    }

    protected void setQueryResult(Table table) {
        if (table != null) {
            if (table instanceof CFNoResultSetTable) {
                this.resultTable = null;
                this.rowCount = ((CFNoResultSetTable)table).getUpdateCount();
                this.autoKeyMap = ((CFNoResultSetTable)table).getGeneratedKeysMap();
            } else {
                this.maskDateTimeColumns(table);
                this.resultTable = table;
                this.rowCount = table.getRowCount();
            }
        }
    }

    private void maskDateTimeColumns(Table table) {
        String column;
        String string = column = col == null ? "Date" : col;
        if (maskDsns == null || mask == null || column == null) {
            return;
        }
        if (this.datasource == null || !this.getMaskDsnList(maskDsns).contains(this.datasource.toString().toUpperCase()) || !(table instanceof QueryTable)) {
            return;
        }
        CFLocaleMgr cfLocaleMgr = CFLocaleMgr.getMgr();
        CFLocale cflocale = cfLocaleMgr.getCFLocale(this.getLocale(cfLocaleMgr));
        QueryTable qTable = (QueryTable)table;
        if (column.equalsIgnoreCase("Date") || column.equalsIgnoreCase("Both")) {
            qTable.maskDateTimeColumns(93, mask, cflocale);
        } else if (column.equalsIgnoreCase("Time") || column.equalsIgnoreCase("Both")) {
            qTable.maskDateTimeColumns(92, mask, cflocale);
        }
    }

    private List getMaskDsnList(String maskDsns) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer strt = new StringTokenizer(maskDsns, ",");
        while (strt.hasMoreTokens()) {
            l.add(strt.nextToken().toUpperCase());
        }
        return l;
    }

    private String getLocale(CFLocaleMgr cfLocaleMgr) {
        Locale locale = cfLocaleMgr.getLocaleObj(this.pageContext);
        CFLocale cflocale = null;
        try {
            cflocale = cfLocaleMgr.getCFLocale(locale);
        }
        catch (CFLocaleMgrException cFLocaleMgrException) {
            // empty catch block
        }
        if (cflocale == null) {
            cflocale = cfLocaleMgr.getDefaultCFLocale();
        }
        return cflocale.GetCFLocaleString();
    }

    protected QueryDetails getQueryDetails() {
        String dsname = this.datasource == null ? null : this.datasource.toString();
        ParameterList tempList = this.impl.getParamList();
        if (tempList != null) {
            tempList = (ParameterList)tempList.clone();
        }
        return new QueryDetails(dsname, this.impl.getSql().trim(), this.impl.getUsername(), tempList, this.cacheId);
    }

    protected CachedQuery getCacheWrapper(QueryDetails details) {
        CachedQuery query = new CachedQuery(details);
        if (this.cacheMaxIdleTime != null) {
            query.setUsingCacheMaxIdleAttribute();
            query.setLastAccessTime();
        }
        return query;
    }

    @Override
    public void release() {
        this.datasource = null;
        this.dbtype = null;
        this.name = null;
        this.username = null;
        this.password = null;
        this.result = null;
        this.maxrows = null;
        this.blockfactor = null;
        this.timeout = null;
        this.cacheMaxIdleTime = null;
        this.cachedafter = null;
        this.cachedwithin = null;
        this.cacheId = null;
        this.cacheRegion = null;
        this.debugState = -1;
        this.dimpl = null;
        this.startTime = 0L;
        this.resultTable = null;
        this.ormOptions = null;
        this.impl.clear();
        this.clientInfo = null;
        this.fetchClientInfo = false;
        this.returnType = null;
        super.release();
    }

    public static Object addMetadataToQueryResult(CachedQuery query) {
        Struct s = new Struct();
        if (query.getKey() != null) {
            s.put("SQL", (Object)query.getKey().getSql());
        }
        int rowCount = 0;
        if (query.getResult() != null) {
            query.getResult().getRowCount();
        }
        s.put("RECORDCOUNT", (Object)new Integer(rowCount));
        s.put("EXECUTIONTIME", (Object)0);
        s.put("CACHED", (Object)"true");
        ParameterList pl = query.getKey().getParamList();
        if (pl != null) {
            ArrayList list = pl.getAllParameters();
            int size = list == null ? 0 : list.size();
            Array myarray = new Array();
            for (int j = 0; j < size; ++j) {
                Object valObj = ((InParameter)list.get(j)).getObject();
                myarray.add(valObj == null ? "" : valObj);
            }
            s.put("SQLPARAMETERS", (Object)myarray);
        }
        if (query.getResult() != null) {
            s.put("COLUMNLIST", (Object)Utils.arrayToString(query.getResult().getColumnNames(), ",", true, true));
            QueryTag.storeExtendedMetaDataInformation(query.getResult(), s);
        }
        return query.getResult();
    }

    public class InvalidAttributeValueException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String attribName;

        public InvalidAttributeValueException(String attribName) {
            this.attribName = attribName;
        }
    }

    public class DataSourceVerificationException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        DataSourceVerificationException(Throwable ex, String dsn) {
            super(ex);
            this.datasource = dsn;
        }

        DataSourceVerificationException(Throwable ex, Object dsn) {
            super(ex);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
        }
    }

    public class InvalidTagAttributeException
    extends ApplicationException {
        public String calledFrom = "tag CFQUERY";
        String functionCall = "function executeQuery";
        public Object value;
        public String name;

        public InvalidTagAttributeException(String attr, Object val, String initiatingTag) {
            if (QueryTag.this.calledAsFunction) {
                this.calledFrom = this.functionCall;
            }
            if (!initiatingTag.isEmpty()) {
                this.calledFrom = initiatingTag;
            }
            this.name = attr;
            this.value = val;
        }
    }

    public class DataSourceException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        DataSourceException(String dsn) {
            this.datasource = dsn;
        }

        DataSourceException(Throwable ex, Object dsn) {
            super(ex);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
        }
    }

    public class DatabaseQueryException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public String where;
        public String queryError;

        DatabaseQueryException(SqlImpl impl) {
            this.init(impl);
        }

        DatabaseQueryException(Throwable ex, SqlImpl impl, Object dsn) {
            super(ex);
            this.init(impl);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
            this.queryError = ex.getMessage();
        }

        void init(SqlImpl impl) {
            if (impl.getParamList() == null) {
                this.sql = impl.getSql();
                this.where = "";
            } else {
                this.sql = impl.getParamList().getStatement(impl.getSql());
                this.where = impl.getParamList().getWhere();
            }
        }
    }

    public class UnsupportedQoQOperationException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        public UnsupportedQoQOperationException() {
        }

        public UnsupportedQoQOperationException(Throwable ex) {
            super(ex);
        }

        public UnsupportedQoQOperationException(Throwable ex, Object dsn) {
            super(ex);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
        }
    }

    public class ConnectionException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        ConnectionException(Throwable ex) {
            super(ex);
        }

        ConnectionException(Throwable ex, Object dsn) {
            super(ex);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
        }
    }

    public class ClientInfoException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        public ClientInfoException(Throwable ex) {
            super(ex);
        }

        public ClientInfoException(Throwable ex, Object dsn) {
            super(ex);
            if (dsn != null) {
                this.datasource = dsn.toString();
            }
        }
    }

    public class UnSupportedDBTypeException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
    }
}

