/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.tagext.validation.CFCTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CFCTypeValidator {
    private static final String resolvedArgType = "resolvedArgType";

    public static void validate(String type, Object value, String refPath, UDFMethod udf) throws CFCTypeValidationException {
        boolean matchFound = false;
        if (type.endsWith("[]")) {
            if (!CFPage.IsArray(value)) {
                throw new CFTypeValidatorFactory.InvalidComplexTypeException("array");
            }
            type = type.substring(0, type.length() - 2);
            if (List.class.isAssignableFrom(value.getClass())) {
                List l = (List)value;
                if (l.size() == 0) {
                    return;
                }
                value = l.get(0);
            } else if (value.getClass().isArray()) {
                if (Array.getLength(value) == 0) {
                    return;
                }
                value = Array.get(value, 0);
            }
        }
        CFPage page = FusionContext.getCurrent().parent;
        matchFound = CFCTypeValidator.validateFormMetadataName(type, value);
        if (!matchFound) {
            throw new CFCTypeValidationException(type);
        }
    }

    public static boolean validateFormMetadataName(String type, Object value) {
        boolean matchFound = false;
        if (value instanceof TemplateProxy) {
            if (type.equalsIgnoreCase("WEB-INF.cftags.interface")) {
                return true;
            }
            if (type.equalsIgnoreCase("/WEB-INF/cftags/component.cfc")) {
                return true;
            }
            AttributeCollection metadata = (AttributeCollection)((TemplateProxy)value).getMetadata();
            if (!matchFound) {
                matchFound = CFCTypeValidator.checkTypeName(type.toLowerCase(), metadata);
            }
            if (!matchFound && ((TemplateProxy)value).isComponent() && type.equalsIgnoreCase("component")) {
                matchFound = true;
            }
        }
        return matchFound;
    }

    private static boolean checkTypePath(String typePath, AttributeCollection metadata) {
        if (typePath.equalsIgnoreCase((String)metadata.get("path"))) {
            return true;
        }
        boolean matchFound = false;
        Object metaDataObj = null;
        metaDataObj = metadata.get("extends");
        if (metaDataObj != null) {
            matchFound = CFCTypeValidator.checkTypePath(typePath, (AttributeCollection)metaDataObj);
        }
        if (!matchFound && (metaDataObj = metadata.get("implements")) != null) {
            matchFound = CFCTypeValidator.checkInterfaceTypePath(typePath, (AttributeCollection)metaDataObj);
        }
        return matchFound;
    }

    private static boolean checkInterfaceTypePath(String typePath, AttributeCollection metadata) {
        Collection interfaceParents = metadata.values();
        if (interfaceParents == null || interfaceParents.size() == 0) {
            return false;
        }
        Object metaDataObj = null;
        boolean matchFound = false;
        Iterator it = interfaceParents.iterator();
        while (it.hasNext() && !matchFound) {
            AttributeCollection parentMetaData = (AttributeCollection)it.next();
            if (typePath.equalsIgnoreCase((String)parentMetaData.get("path"))) {
                return true;
            }
            metaDataObj = parentMetaData.get("extends");
            if (metaDataObj == null) continue;
            matchFound = CFCTypeValidator.checkInterfaceTypePath(typePath, (AttributeCollection)metaDataObj);
        }
        return matchFound;
    }

    private static boolean checkTypeName(String type, AttributeCollection metadata) {
        String name = ((String)metadata.get("name")).toLowerCase();
        if (CFCTypeValidator.validateName(name, type)) {
            return true;
        }
        boolean matchFound = false;
        Object metaDataObj = null;
        metaDataObj = metadata.get("extends");
        if (metaDataObj != null) {
            if (metaDataObj instanceof String) {
                return CFCTypeValidator.validateName(type, ((String)metaDataObj).toLowerCase());
            }
            matchFound = CFCTypeValidator.checkTypeName(type, (AttributeCollection)metaDataObj);
        }
        if (!matchFound && (metaDataObj = metadata.get("implements")) != null) {
            if (metaDataObj instanceof String) {
                return CFCTypeValidator.validateName(type, ((String)metaDataObj).toLowerCase());
            }
            matchFound = CFCTypeValidator.checkInterfaceTypeName(type, (AttributeCollection)metaDataObj);
        }
        return matchFound;
    }

    private static boolean checkInterfaceTypeName(String type, AttributeCollection metadata) {
        Collection interfaceParents = metadata.values();
        if (interfaceParents == null || interfaceParents.size() == 0) {
            return false;
        }
        Object metaDataObj = null;
        boolean matchFound = false;
        String name = null;
        Iterator it = interfaceParents.iterator();
        while (it.hasNext() && !matchFound) {
            AttributeCollection parentMetaData = (AttributeCollection)it.next();
            name = ((String)parentMetaData.get("name")).toLowerCase();
            if (CFCTypeValidator.validateName(name, type)) {
                return true;
            }
            metaDataObj = parentMetaData.get("extends");
            if (metaDataObj == null) continue;
            matchFound = CFCTypeValidator.checkInterfaceTypeName(type, (AttributeCollection)metaDataObj);
        }
        return matchFound;
    }

    private static boolean checkTypeNameUsingImports(String type, AttributeCollection metadata, UDFMethod udf, NeoPageContext pContext, String importList) {
        String cfcName = (String)metadata.get("NAME");
        String resolvedName = null;
        Map argTypeMap = null;
        if (udf != null && (argTypeMap = (Map)((Map)udf.getMetadata()).get(resolvedArgType)) != null) {
            resolvedName = (String)argTypeMap.get(type);
        }
        if (resolvedName == null) {
            resolvedName = CFCTypeValidator.getResolvedTypeUsingImport(type, udf, argTypeMap, pContext, importList);
        }
        if (resolvedName == null) {
            return false;
        }
        return CFCTypeValidator.checkTypeName(resolvedName, metadata);
    }

    private static String getResolvedTypeUsingImport(String type, UDFMethod udf, Map argTypeMap, NeoPageContext pcontext, String importList) {
        String resolvedName = null;
        TemplateProxy templateproxy = null;
        if (pcontext != null) {
            try {
                templateproxy = TemplateProxyFactory.createTemplateProxyForMetaData(type, pcontext, importList);
            }
            catch (Throwable t) {
                return null;
            }
            resolvedName = (String)((Map)templateproxy.getMetadata()).get("NAME");
            if (udf != null) {
                if (argTypeMap == null) {
                    argTypeMap = new Struct();
                    ((Map)udf.getMetadata()).put(resolvedArgType, argTypeMap);
                }
                argTypeMap.put(type, resolvedName);
            }
        }
        return resolvedName;
    }

    private static boolean validateName(String cfcName, String typeName) {
        if (cfcName.equals(typeName)) {
            return true;
        }
        String temp = cfcName;
        int index = temp.indexOf(".");
        while (index != -1) {
            if ((temp = temp.substring(index + 1)).equals(typeName)) {
                return true;
            }
            index = temp.indexOf(".");
        }
        return false;
    }
}

