/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.filter.StringValidator;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.InvalidSimpleTypeException;

public final class CFIntegerValidator
extends CFTypeValidator {
    private Boolean isOpenLower;
    private Boolean isOpenUpper;
    private double lowerBound = Double.MIN_VALUE;
    private double upperBound = Double.MAX_VALUE;
    private boolean stripNumericNoise = false;

    public CFIntegerValidator() {
    }

    public CFIntegerValidator(boolean stripNumericNoise) {
        this.stripNumericNoise = stripNumericNoise;
    }

    public void setLowerBound(boolean isOpenLower, double bound) {
        this.isOpenLower = isOpenLower ? Boolean.TRUE : Boolean.FALSE;
        this.lowerBound = bound;
    }

    public void setUpperBound(boolean isOpenUpper, double bound) {
        this.isOpenUpper = isOpenUpper ? Boolean.TRUE : Boolean.FALSE;
        this.upperBound = bound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Object value) throws CFTypeValidationException {
        int intVal;
        if (value instanceof Number) {
            int integerVal;
            Number numObj = (Number)value;
            double dVal = numObj.doubleValue();
            if (dVal != (double)(integerVal = numObj.intValue())) throw new IntegerParseException(value.toString());
            intVal = integerVal;
        } else {
            String tempStr = value.toString();
            boolean strictNumberValidation = CFNumberValidator.getStrictNumberValidation();
            if (!strictNumberValidation && this.stripNumericNoise) {
                tempStr = StringValidator.stripNumericNoise(tempStr, true);
            }
            try {
                intVal = Integer.parseInt(tempStr);
            }
            catch (NumberFormatException ex) {
                throw new IntegerParseException(tempStr);
            }
            catch (Exception ex) {
                throw new InvalidSimpleTypeException("integer");
            }
        }
        if (this.lowerBound != Double.MIN_VALUE && this.upperBound != Double.MAX_VALUE && this.upperBound < this.lowerBound) {
            throw new LowerGreaterThenUpperException(this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != Double.MIN_VALUE) {
            boolean openLower = this.isOpenLower;
            if ((double)intVal <= this.lowerBound && openLower) {
                throw new OpenLowerBoundException(intVal, this.lowerBound);
            }
            if ((double)intVal < this.lowerBound && !openLower) {
                throw new ClosedLowerBoundException(intVal, this.lowerBound);
            }
        }
        if (this.upperBound == Double.MAX_VALUE) return;
        boolean openUpper = this.isOpenUpper;
        if (!((double)intVal > this.upperBound) || openUpper) return;
        throw new ClosedUpperBoundException(intVal, this.upperBound);
    }

    @Override
    public void validate(Object value, String s) throws CFTypeValidationException {
    }

    @Override
    public Object cast(Object value) throws ExpressionException {
        return new Integer(Cast._int(value));
    }

    public static class IntegerParseException
    extends CFTypeValidationException {
        public String value;

        public IntegerParseException(String value) {
            this.value = value;
        }
    }

    public class LowerGreaterThenUpperException
    extends CFTypeValidationException {
        public double lower;
        public double upper;

        LowerGreaterThenUpperException(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    public class OpenLowerBoundException
    extends CFTypeValidationException {
        public int value;
        public double bound;

        OpenLowerBoundException(int value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }

    public class ClosedLowerBoundException
    extends CFTypeValidationException {
        public int value;
        public double bound;

        ClosedLowerBoundException(int value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }

    public class ClosedUpperBoundException
    extends CFTypeValidationException {
        public int value;
        public double bound;

        ClosedUpperBoundException(int value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }
}

