/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.validation.ArgumentAttributeIllegalvalueException;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.ParseExceptionWrapper;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.runtime.TagNodeWrapper;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.tagext.validation.IllegalSwitchValueException;
import coldfusion.tagext.validation.IllegalSwitchedAttrConfigException;
import coldfusion.tagext.validation.TagAttrConfiguration;
import coldfusion.tagext.validation.TagContextRule;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;

public class CFMLTagValidator
implements Serializable {
    private String _tagName;
    private TagContextRule _contextRule;
    private TagAttrConfiguration _attrConfig;
    private Map _attrConstraints;
    private Boolean _allowOtherAttrs = Boolean.FALSE;
    private Boolean _allowSuperfluousAttrs = Boolean.FALSE;

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setContextRule(TagContextRule contextRule) {
        this._contextRule = contextRule;
    }

    public void setAttrConfiguration(TagAttrConfiguration attrConfig) {
        this._attrConfig = attrConfig;
    }

    public void setAttrConstraints(Map attrConstraints) {
        this._attrConstraints = attrConstraints;
    }

    public CFTypeValidator getAttrConstraint(String attrName) {
        return (CFTypeValidator)this._attrConstraints.get(attrName.toLowerCase());
    }

    public void setAllowOtherAttributes(boolean allowOtherAttrs) {
        this._allowOtherAttrs = allowOtherAttrs ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAllowSuperfluousAttrs(boolean allowSuperfluousAttrs) {
        this._allowSuperfluousAttrs = allowSuperfluousAttrs ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean allowOtherAttributes() {
        return this._allowOtherAttrs;
    }

    public void validateAttrConfiguration(String switchValue, Collection attributes, String calledName) {
        if (this._attrConfig == null) {
            return;
        }
        String switchAttribute = this._attrConfig.getSwitchAttribute();
        Collection switchValueSet = this._attrConfig.getSwitchValues();
        if (switchValue == null || !switchValueSet.contains(switchValue.toLowerCase())) {
            if (calledName == null) {
                throw new IllegalSwitchValueException(this._tagName, switchAttribute, switchValue, switchValueSet);
            }
            throw new IllegalSwitchValueException(calledName, switchAttribute, switchValue, switchValueSet);
        }
        this._attrConfig.validate(this._tagName, switchValue, attributes, (boolean)this._allowSuperfluousAttrs, null, null);
    }

    public void validateAttrConfiguration(TagNode tagNode, ValidationResultCollector collector, boolean superfluous) {
        if (this._attrConfig == null) {
            return;
        }
        String switchValue = null;
        if (this._attrConfig.isSwitched()) {
            switchValue = this.validateSwitchedAttribute(tagNode, collector);
        }
        this._attrConfig.validate(tagNode, collector, switchValue, superfluous || this._allowSuperfluousAttrs != false);
    }

    private String validateSwitchedAttribute(TagNode tagNode, ValidationResultCollector collector) {
        String switchValue = null;
        CFMLValidationException error = null;
        boolean runtimeValidation = false;
        String switchAttribute = this._attrConfig.getSwitchAttribute();
        Collection switchValueSet = this._attrConfig.getSwitchValues();
        ExprNode attrNode = null;
        try {
            attrNode = tagNode.getAttrNode(switchAttribute);
        }
        catch (ParseException parseEx) {
            if (parseEx instanceof CFMLValidationException) {
                if (!(tagNode instanceof TagNodeWrapper)) {
                    ((CFMLValidationException)parseEx).setLineNumbers(tagNode);
                }
                collector.collectValidationResult((CFMLValidationException)parseEx);
            }
            error = new ParseExceptionWrapper(parseEx);
            error.setLineNumbers(parseEx.getLine(), parseEx.getLine());
            collector.collectValidationResult(error);
        }
        if (attrNode != null) {
            try {
                switchValue = EvaluateEngine._String(attrNode);
            }
            catch (Exception ex) {
                tagNode.prepareRuntimeAttrValidation(switchAttribute);
                runtimeValidation = true;
            }
            if (!(runtimeValidation || switchValue != null && switchValueSet.contains(switchValue.toLowerCase()))) {
                error = new IllegalSwitchValueException(this._tagName, switchAttribute, switchValue, switchValueSet);
                if (!(tagNode instanceof TagNodeWrapper)) {
                    error.setLineNumbers(attrNode);
                }
                collector.collectValidationResult(error);
            }
        } else {
            CFTypeValidator validator = this.getAttrConstraint(switchAttribute);
            if (validator.getDefault() != null) {
                switchValue = validator.getDefault().toString();
            } else {
                error = new IllegalSwitchedAttrConfigException(this._tagName, switchAttribute);
                if (!(tagNode instanceof TagNodeWrapper)) {
                    error.setLineNumbers(tagNode);
                }
                collector.collectValidationResult(error);
            }
        }
        return switchValue;
    }

    public void validateTagContext(TagNode tagNode, ValidationResultCollector collector) {
        if (this._contextRule != null) {
            this._contextRule.validate(tagNode, collector);
        }
    }

    public void validateAttrConstraint(TagNode tagNode, ValidationResultCollector collector) {
        Enumeration attrNames = null;
        ParseExceptionWrapper error = null;
        try {
            attrNames = tagNode.getAttrNames();
        }
        catch (ParseException ex) {
            error = new ParseExceptionWrapper(ex);
            error.setLineNumbers(tagNode);
            collector.collectValidationResult(error);
        }
        if (attrNames != null) {
            while (attrNames.hasMoreElements()) {
                String attrName = attrNames.nextElement().toString();
                ExprNode attrNode = null;
                try {
                    attrNode = tagNode.getAttrNode(attrName);
                }
                catch (ParseException ex) {
                    error = new ParseExceptionWrapper(ex);
                    error.setLineNumbers(tagNode);
                    collector.collectValidationResult(error);
                }
                if (attrNode == null) continue;
                this.validateAttrConstraint(attrName, attrNode, collector);
            }
        }
    }

    public void validateAttrConstraint(String attrName, ExprNode primaryexpr, ValidationResultCollector collector) {
        String attrValue = null;
        try {
            attrValue = EvaluateEngine._String(primaryexpr);
        }
        catch (Exception ex) {
            return;
        }
        CFTypeValidator validator = this.getAttrConstraint(attrName);
        if (validator != null) {
            try {
                validator.validate(attrValue);
            }
            catch (CFTypeValidationException ex) {
                IllegalAttributeValueException error = new IllegalAttributeValueException(this._tagName, attrName, ex.getMessage() + ex.getDetail());
                error.setLineNumbers(primaryexpr);
                collector.collectValidationResult(error);
            }
        }
    }

    public void validateArgumentAttributeContraint(TagNode tagNode, ValidationResultCollector collector) {
        ExprNode attrNode = tagNode.getAttrNode("attributecollection");
        if (attrNode == null) {
            ArgumentAttributeIllegalvalueException error = new ArgumentAttributeIllegalvalueException(this._tagName);
            collector.collectValidationResult(error);
        }
    }
}

