/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.filter.StringValidator;
import coldfusion.runtime.Cast;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.InvalidSimpleTypeException;
import java.util.Date;

public final class CFNumberLegacyValidator
extends CFNumberValidator {
    private Boolean isOpenLower;
    private Boolean isOpenUpper;
    private double lowerBound = Double.MIN_VALUE;
    private double upperBound = Double.MAX_VALUE;
    private boolean stripNumericNoise = false;

    @Override
    public void validate(Object value) throws CFTypeValidationException {
        double doubleVal;
        if (value == null) {
            throw new InvalidSimpleTypeException("numeric");
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Date) {
            try {
                doubleVal = Cast._double(value);
            }
            catch (Exception ex) {
                throw new InvalidSimpleTypeException("numeric");
            }
        }
        String tempStr = value.toString();
        if (this.stripNumericNoise) {
            tempStr = StringValidator.stripNumericNoise(tempStr, false);
        }
        try {
            doubleVal = Cast._double(tempStr);
        }
        catch (Exception ex) {
            throw new InvalidSimpleTypeException("numeric");
        }
        if (this.lowerBound != Double.MIN_VALUE && this.upperBound != Double.MAX_VALUE && this.upperBound < this.lowerBound) {
            throw new CFNumberValidator.LowerGreaterThenUpperException(this, this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != Double.MIN_VALUE) {
            boolean openLower = this.isOpenLower;
            if (doubleVal <= this.lowerBound && openLower) {
                throw new CFNumberValidator.OpenLowerBoundException(this, doubleVal, this.lowerBound);
            }
            if (doubleVal < this.lowerBound && !openLower) {
                throw new CFNumberValidator.ClosedLowerBoundException(this, doubleVal, this.lowerBound);
            }
        }
        if (this.upperBound != Double.MAX_VALUE) {
            boolean openUpper = this.isOpenUpper;
            if (doubleVal > this.upperBound && !openUpper) {
                throw new CFNumberValidator.ClosedUpperBoundException(this, doubleVal, this.upperBound);
            }
        }
    }
}

