/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.filter.FusionContext;
import coldfusion.filter.StringValidator;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.InvalidNumericTypeException;
import coldfusion.tagext.validation.InvalidSimpleTypeException;
import java.util.Date;

public class CFNumberValidator
extends CFTypeValidator {
    private Boolean isOpenLower;
    private Boolean isOpenUpper;
    private double lowerBound = Double.MIN_VALUE;
    private double upperBound = Double.MAX_VALUE;
    private boolean stripNumericNoise = false;

    public CFNumberValidator() {
    }

    public CFNumberValidator(boolean stripNumericNoise) {
        this.stripNumericNoise = stripNumericNoise;
    }

    public void setLowerBound(boolean isOpenLower, double bound) {
        this.isOpenLower = isOpenLower ? Boolean.TRUE : Boolean.FALSE;
        this.lowerBound = bound;
    }

    public void setUpperBound(boolean isOpenUpper, double bound) {
        this.isOpenUpper = isOpenUpper ? Boolean.TRUE : Boolean.FALSE;
        this.upperBound = bound;
    }

    private boolean checkIsBooleanString(String value) {
        return (value = value.toLowerCase()).equals("true") || value.equals("false") || value.equals("yes") || value.equals("no");
    }

    @Override
    public void validate(Object value) throws CFTypeValidationException {
        double doubleVal;
        if (value == null) {
            throw new InvalidSimpleTypeException("numeric");
        }
        if (value instanceof Boolean || value instanceof CFBoolean) {
            try {
                doubleVal = Cast._double(value);
            }
            catch (Exception ex) {
                throw new InvalidNumericTypeException();
            }
        }
        if (this.checkIsBooleanString(String.valueOf(value))) {
            throw new InvalidNumericTypeException();
        }
        if (value instanceof Number || value instanceof Date) {
            try {
                doubleVal = Cast._double(value);
            }
            catch (Exception ex) {
                throw new InvalidSimpleTypeException("numeric");
            }
        }
        String tempStr = value.toString();
        boolean strictNumberValidation = CFNumberValidator.getStrictNumberValidation();
        if (!strictNumberValidation && this.stripNumericNoise) {
            tempStr = StringValidator.stripNumericNoise(tempStr, false);
        }
        try {
            doubleVal = strictNumberValidation ? CFDouble.parseDouble((String)tempStr.trim()) : Cast._double(tempStr.trim());
        }
        catch (Exception ex) {
            throw new InvalidSimpleTypeException("numeric");
        }
        if (this.lowerBound != Double.MIN_VALUE && this.upperBound != Double.MAX_VALUE && this.upperBound < this.lowerBound) {
            throw new LowerGreaterThenUpperException(this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != Double.MIN_VALUE) {
            boolean openLower = this.isOpenLower;
            if (doubleVal <= this.lowerBound && openLower) {
                throw new OpenLowerBoundException(doubleVal, this.lowerBound);
            }
            if (doubleVal < this.lowerBound && !openLower) {
                throw new ClosedLowerBoundException(doubleVal, this.lowerBound);
            }
        }
        if (this.upperBound != Double.MAX_VALUE) {
            boolean openUpper = this.isOpenUpper;
            if (doubleVal > this.upperBound && !openUpper) {
                throw new ClosedUpperBoundException(doubleVal, this.upperBound);
            }
        }
    }

    public static boolean getStrictNumberValidation() {
        ApplicationSettings appSettings = FusionContext.getApplicationSettings();
        if (appSettings != null) {
            return appSettings.getStrictNumberValidation();
        }
        return true;
    }

    @Override
    public void validate(Object value, String s) throws CFTypeValidationException {
    }

    @Override
    public Object cast(Object value) throws ExpressionException {
        return new Double(Cast._double(value));
    }

    public static boolean checkValidNumericNoise(String s, boolean integer) {
        boolean digit = false;
        int arithmaticOp = 0;
        int currency = 0;
        int decimal = 0;
        try {
            s = s.trim();
            if (s.length() == 0) {
                return false;
            }
            char[] chars = s.toCharArray();
            block8: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '+': 
                    case '-': {
                        arithmaticOp = (byte)(arithmaticOp + 1);
                        if (arithmaticOp > 1) {
                            return false;
                        }
                        if (!digit || !integer) continue block8;
                        return false;
                    }
                    case '.': {
                        decimal = (byte)(decimal + 1);
                        if (decimal <= 1) continue block8;
                        return false;
                    }
                    case '$': 
                    case '\u0080': 
                    case '\u00a3': 
                    case '\u00a5': {
                        currency = (byte)(currency + 1);
                        if (currency <= 1) continue block8;
                        return false;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        digit = true;
                        continue block8;
                    }
                    default: {
                        return true;
                    }
                }
            }
        }
        catch (RuntimeException pe) {
            return false;
        }
        return true;
    }

    public class LowerGreaterThenUpperException
    extends CFTypeValidationException {
        public double lower;
        public double upper;

        LowerGreaterThenUpperException(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    public class OpenLowerBoundException
    extends CFTypeValidationException {
        public double value;
        public double bound;

        OpenLowerBoundException(double value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }

    public class ClosedLowerBoundException
    extends CFTypeValidationException {
        public double value;
        public double bound;

        ClosedLowerBoundException(double value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }

    public class ClosedUpperBoundException
    extends CFTypeValidationException {
        public double value;
        public double bound;

        ClosedUpperBoundException(double value, double bound) {
            this.value = value;
            this.bound = bound;
        }
    }
}

