/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.InvalidSimpleTypeException;

public final class CFStringValidator
extends CFTypeValidator {
    private int lowerBound = -1;
    private int upperBound = -1;

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void validate(Object value) throws CFTypeValidationException {
        String strVal;
        try {
            strVal = Cast._String(value);
        }
        catch (Exception ex) {
            throw new InvalidSimpleTypeException("string");
        }
        if (strVal == null) {
            throw new InvalidSimpleTypeException("string");
        }
        int len = strVal.length();
        if (this.lowerBound != -1 && len < this.lowerBound) {
            throw new StringLowerBoundException(len, this.lowerBound);
        }
        if (this.upperBound != -1 && len > this.upperBound) {
            throw new StringUpperBoundException(len, this.upperBound);
        }
    }

    @Override
    public void validate(Object value, String s) throws CFTypeValidationException {
    }

    @Override
    public Object cast(Object value) throws ExpressionException {
        return Cast._String(value);
    }

    public class StringLowerBoundException
    extends CFTypeValidationException {
        public int strlen;
        public int bound;

        StringLowerBoundException(int strlen, int bound) {
            this.strlen = strlen;
            this.bound = bound;
        }
    }

    public class StringUpperBoundException
    extends CFTypeValidationException {
        public int strlen;
        public int bound;

        StringUpperBoundException(int strlen, int bound) {
            this.strlen = strlen;
            this.bound = bound;
        }
    }
}

