/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.compiler.ASTcfloop;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.ParseExceptionWrapper;
import coldfusion.compiler.validation.TagValidationException;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.runtime.ArrayUtil;
import coldfusion.tagext.validation.AllowedAttributesException;
import coldfusion.tagext.validation.IllegalAttrConfigException;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.tagext.validation.RequiredSwitchedAttrException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

public abstract class TagAttrConfiguration
implements Serializable {
    public abstract boolean isSwitched();

    public abstract String getSwitchAttribute();

    public abstract Collection getSwitchValues();

    abstract List checkAllowedAttrs(String var1, ArrayList var2);

    abstract List checkRequiredAttrs(String var1, ArrayList var2);

    abstract String checkConfiguration(String var1, ArrayList var2, boolean var3);

    public abstract Collection getAllowedAttrs(String var1);

    public abstract Collection getRequiredAttrs(String var1);

    public abstract Collection getConfiguration(String var1);

    void validate(TagNode tagNode, ValidationResultCollector collector, String switchValue, boolean allowSuperfluousAttrs) {
        Enumeration attrs = null;
        String tagName = null;
        tagName = tagNode instanceof ASTcftag && ((ASTcftag)tagNode).getCalledName() != null ? ((ASTcftag)tagNode).getCalledName().toUpperCase() + " tag in cfscript" : (tagNode instanceof ASTcfloop && tagNode.isCalledFromScript() ? tagNode.getTagName() + " method" : "tag " + tagNode.getTagName().toUpperCase());
        try {
            attrs = tagNode.getAttrNames();
        }
        catch (ParseException parseEx) {
            if (parseEx instanceof CFMLValidationException) {
                ((CFMLValidationException)parseEx).setLineNumbers(tagNode);
                collector.collectValidationResult((CFMLValidationException)parseEx);
            }
            ParseExceptionWrapper error = new ParseExceptionWrapper(parseEx);
            error.setLineNumbers(parseEx.getLine(), parseEx.getLine());
            collector.collectValidationResult(error);
        }
        if (attrs != null) {
            this.validate(tagName, switchValue, attrs, allowSuperfluousAttrs, (Node)tagNode, collector);
        }
    }

    void validate(String tagName, String switchValue, Enumeration attrs, boolean allowSuperfluousAttrs, Node context, ValidationResultCollector collector) {
        String invalidConfig;
        TagValidationException error;
        List temp = null;
        ArrayList<String> attrList = new ArrayList<String>();
        while (attrs != null && attrs.hasMoreElements()) {
            attrList.add(attrs.nextElement().toString().toLowerCase());
        }
        if (!allowSuperfluousAttrs && !attrList.isEmpty()) {
            temp = this.checkAllowedAttrs(switchValue, new ArrayList(attrList));
        }
        if (temp != null) {
            error = new AllowedAttributesException(tagName, temp, this.getAllowedAttrs(switchValue));
            this.dispatchError(error, collector, context);
        }
        if ((temp = this.checkRequiredAttrs(switchValue, new ArrayList(attrList))) != null) {
            error = this.isSwitched() ? new RequiredSwitchedAttrException(tagName, this.getSwitchAttribute(), switchValue, ArrayUtil.ArrayToList(temp, ",")) : new RequiredAttributesException(tagName, ArrayUtil.ArrayToList(temp, ","));
            this.dispatchError(error, collector, context);
        }
        if ((invalidConfig = this.checkConfiguration(switchValue, new ArrayList(attrList), allowSuperfluousAttrs)) != null) {
            error = new IllegalAttrConfigException(tagName, invalidConfig, this.getConfiguration(switchValue));
            this.dispatchError(error, collector, context);
        }
    }

    void validate(String tagName, String switchValue, Collection attrs, boolean allowSuperfluousAttrs, Node context, ValidationResultCollector collector) {
        String invalidConfig;
        TagValidationException error;
        List temp = null;
        if (!allowSuperfluousAttrs && !attrs.isEmpty()) {
            temp = this.checkAllowedAttrs(switchValue, new ArrayList(attrs));
        }
        if (temp != null) {
            error = new AllowedAttributesException(tagName, temp, this.getAllowedAttrs(switchValue));
            this.dispatchError(error, collector, context);
        }
        if ((temp = this.checkRequiredAttrs(switchValue, new ArrayList(attrs))) != null) {
            error = this.isSwitched() ? new RequiredSwitchedAttrException(tagName, this.getSwitchAttribute(), switchValue, ArrayUtil.ArrayToList(temp, ",")) : new RequiredAttributesException(tagName, ArrayUtil.ArrayToList(temp, ","));
            this.dispatchError(error, collector, context);
        }
        if (attrs != null && (invalidConfig = this.checkConfiguration(switchValue, new ArrayList(attrs), allowSuperfluousAttrs)) != null) {
            error = new IllegalAttrConfigException(tagName, invalidConfig, this.getConfiguration(switchValue));
            this.dispatchError(error, collector, context);
        }
    }

    private void dispatchError(CFMLValidationException error, ValidationResultCollector collector, Node context) {
        if (context != null) {
            error.setLineNumbers(context);
        }
        if (collector == null) {
            throw error;
        }
        collector.collectValidationResult(error);
    }
}

