/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.wddx.WddxParseException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WddxValidator
extends HandlerBase {
    private SAXParser parser;
    private static final String dtd = "<!DOCTYPE wddxPacket [<!ELEMENT wddxPacket (header, data)><!ATTLIST wddxPacket version CDATA #REQUIRED><!ELEMENT header (comment?)><!ELEMENT comment (#PCDATA)><!ELEMENT data (null | boolean | number | dateTime | string | array | struct | recordset | binary)><!ELEMENT null EMPTY><!ATTLIST null type CDATA #IMPLIED><!ELEMENT boolean EMPTY><!ATTLIST boolean value (true | false) #REQUIRED type CDATA #IMPLIED><!ELEMENT string (#PCDATA | char)*><!ATTLIST string type CDATA #IMPLIED><!ELEMENT char EMPTY><!ATTLIST char code CDATA #REQUIRED><!ELEMENT number (#PCDATA)><!ATTLIST number type CDATA #IMPLIED><!ELEMENT dateTime (#PCDATA)><!ATTLIST dateTime type CDATA #IMPLIED><!ELEMENT array (null | boolean | number | dateTime | string | array | struct | recordset | binary)*><!ATTLIST array length CDATA #REQUIRED type CDATA #IMPLIED><!ELEMENT struct (var*)><!ATTLIST struct type CDATA #IMPLIED><!ELEMENT var (null | boolean | number | dateTime | string | array | struct | recordset | binary)><!ATTLIST var name CDATA #REQUIRED><!ELEMENT recordset (field*)><!ATTLIST recordset rowCount CDATA #REQUIRED fieldNames CDATA #REQUIRED type CDATA #IMPLIED><!ELEMENT field (null | boolean | number | dateTime | string | binary)*><!ATTLIST field name CDATA #REQUIRED><!ELEMENT binary (#PCDATA)><!ATTLIST binary encoding CDATA #FIXED \"base64\" length CDATA #IMPLIED type CDATA #IMPLIED>]>";

    public WddxValidator() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(false);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new CFTypeValidationException(e);
        }
    }

    public void validate(Object wddx) throws CFTypeValidationException {
        try {
            Object wddxStr = wddx.toString();
            int packet = ((String)wddxStr).indexOf("wddxPacket");
            if (packet < 0) {
                throw new MissingWddxRootElementException(wddx);
            }
            wddxStr = "<!DOCTYPE wddxPacket [<!ELEMENT wddxPacket (header, data)><!ATTLIST wddxPacket version CDATA #REQUIRED><!ELEMENT header (comment?)><!ELEMENT comment (#PCDATA)><!ELEMENT data (null | boolean | number | dateTime | string | array | struct | recordset | binary)><!ELEMENT null EMPTY><!ATTLIST null type CDATA #IMPLIED><!ELEMENT boolean EMPTY><!ATTLIST boolean value (true | false) #REQUIRED type CDATA #IMPLIED><!ELEMENT string (#PCDATA | char)*><!ATTLIST string type CDATA #IMPLIED><!ELEMENT char EMPTY><!ATTLIST char code CDATA #REQUIRED><!ELEMENT number (#PCDATA)><!ATTLIST number type CDATA #IMPLIED><!ELEMENT dateTime (#PCDATA)><!ATTLIST dateTime type CDATA #IMPLIED><!ELEMENT array (null | boolean | number | dateTime | string | array | struct | recordset | binary)*><!ATTLIST array length CDATA #REQUIRED type CDATA #IMPLIED><!ELEMENT struct (var*)><!ATTLIST struct type CDATA #IMPLIED><!ELEMENT var (null | boolean | number | dateTime | string | array | struct | recordset | binary)><!ATTLIST var name CDATA #REQUIRED><!ELEMENT recordset (field*)><!ATTLIST recordset rowCount CDATA #REQUIRED fieldNames CDATA #REQUIRED type CDATA #IMPLIED><!ELEMENT field (null | boolean | number | dateTime | string | binary)*><!ATTLIST field name CDATA #REQUIRED><!ELEMENT binary (#PCDATA)><!ATTLIST binary encoding CDATA #FIXED \"base64\" length CDATA #IMPLIED type CDATA #IMPLIED>]><" + ((String)wddxStr).substring(packet);
            this.parser.parse(new InputSource(new StringReader((String)wddxStr)), (HandlerBase)this);
        }
        catch (Exception ex) {
            throw new InvalidWddxPacketException((Throwable)ex);
        }
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        this.throwSAXException(spe);
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        this.throwSAXException(spe);
    }

    private void throwSAXException(SAXParseException spe) throws SAXException {
        WddxParseException parseEx = new WddxParseException(spe.getSystemId(), spe.getPublicId(), spe.getLineNumber(), spe.getColumnNumber(), spe);
        throw new SAXException(parseEx);
    }

    public static class MissingWddxRootElementException
    extends CFTypeValidationException {
        public Object value;

        public MissingWddxRootElementException(Object value) {
            this.value = value;
        }
    }

    public class InvalidWddxPacketException
    extends CFTypeValidationException {
        public String getErrorMessage() {
            return this.rootCause.getMessage();
        }

        public InvalidWddxPacketException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

