/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.thread;

import coldfusion.security.SandBoxSecurityContext;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceListener;
import coldfusion.util.GenericThreadPool;
import java.util.Optional;

public class CFThreadManager {
    private int activeHandlerThreads = 10;
    private int minHandlerThreads = 1;
    private static int maxQueueSize = Integer.valueOf(Optional.ofNullable(System.getProperty("coldfusion.Thread.maxQueueSize")).orElse("5000"));
    private int idleTimeOut = 300000;
    public static final String POOL_SIZE = "cfthreadpool";
    public static final int DEFAULT_CFTHREAD_POOL = 10;
    public static final int STANDARD_CFTHREAD_POOL_MAX = 10;
    private static CFThreadManager instance = new CFThreadManager();
    private GenericThreadPool threadPool;

    public static GenericThreadPool getThreadPool() {
        return CFThreadManager.instance.threadPool;
    }

    private CFThreadManager() {
        this.init();
        this.threadPool = new GenericThreadPool("cfthread", maxQueueSize, this.minHandlerThreads, this.activeHandlerThreads, this.idleTimeOut, SandBoxSecurityContext.PRIVILEGED);
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        runtimeService.addServiceListener(new ServiceListener(){

            @Override
            public void serviceModified() {
                CFThreadManager.this.init();
                CFThreadManager.this.threadPool.setPoolSize(CFThreadManager.this.minHandlerThreads, CFThreadManager.this.activeHandlerThreads);
            }
        });
    }

    private void init() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        this.activeHandlerThreads = runtimeService.getCFThreadPoolSize();
    }
}

