/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.TemplateReader;
import coldfusion.compiler.validation.CfmlDiagnosticInfo;
import coldfusion.runtime.Array;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.Struct;
import coldfusion.wddx.WddxSerializer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class AnalysisResult {
    public static final int HAS_NONE = 0;
    public static final int HAS_ISSUE = 1;
    public static final int HAS_ERROR = 2;
    public static final int HAS_BOTH = 3;
    private Map summary = new Struct();
    private Map detail = new Struct();
    private Map validation = new Struct();

    public void addValidationResult(String fileName, Collection results) {
        if (results.isEmpty()) {
            return;
        }
        ArrayList<Struct> errors = new ArrayList<Struct>();
        for (CfmlDiagnosticInfo diagInfo : results) {
            Struct errorDetail = new Struct();
            this.populateDetail(errorDetail, diagInfo);
            errors.add(errorDetail);
        }
        this.validation.put(fileName, errors);
        this.doSummary(results);
    }

    public void addCompatibilityResult(String fileName, Collection results) {
        if (results.isEmpty()) {
            return;
        }
        Struct featureToIssue = new Struct();
        for (CfmlDiagnosticInfo diagInfo : results) {
            String featureName = diagInfo.getFeatureName();
            Map issueDetail = (Map)featureToIssue.get(featureName);
            if (issueDetail == null) {
                issueDetail = new Struct();
                this.populateDetail(issueDetail, diagInfo);
                featureToIssue.put(featureName, issueDetail);
                continue;
            }
            String oldLine = issueDetail.get("lineInfo").toString();
            issueDetail.put("lineInfo", oldLine + ";" + diagInfo.getBeginLine());
        }
        ArrayList issues = new ArrayList();
        issues.addAll(featureToIssue.values());
        this.detail.put(fileName, issues);
        this.doSummary(results);
    }

    private void normalizeResults() {
        int counter;
        Integer objCounter;
        String featureName;
        Collection errors;
        Struct featureCounter = new Struct();
        for (Object file : this.validation.keySet()) {
            errors = (Collection)this.validation.get(file);
            for (Map errorDetail : errors) {
                featureName = errorDetail.get("featureName").toString();
                objCounter = (Integer)featureCounter.get(featureName);
                if (objCounter == null) {
                    errorDetail.put("featureName", featureName);
                    featureCounter.put(featureName, new Integer(1));
                    continue;
                }
                counter = objCounter;
                errorDetail.put("featureName", featureName + " (" + counter + ")");
                featureCounter.put(featureName, new Integer(counter + 1));
            }
        }
        for (Object file : this.detail.keySet()) {
            errors = (Collection)this.detail.get(file);
            for (Map errorDetail : errors) {
                featureName = errorDetail.get("featureName").toString();
                objCounter = (Integer)featureCounter.get(featureName);
                if (objCounter == null) {
                    errorDetail.put("featureName", featureName);
                    featureCounter.put(featureName, new Integer(1));
                    continue;
                }
                counter = objCounter;
                errorDetail.put("featureName", featureName + " (" + counter + ")");
                featureCounter.put(featureName, new Integer(counter + 1));
            }
        }
        for (Object fileName : this.validation.keySet()) {
            Collection issues = (Collection)this.detail.get(fileName);
            if (issues == null) {
                this.detail.put(fileName, this.validation.get(fileName));
                continue;
            }
            issues.addAll((Collection)this.validation.get(fileName));
        }
    }

    private void populateDetail(Map container, CfmlDiagnosticInfo diagInfo) {
        container.put("category", diagInfo.getCategory());
        container.put("featureName", diagInfo.getFeatureName());
        container.put("description", diagInfo.getDescription());
        container.put("remedy", diagInfo.getRemedy());
        container.put("severity", diagInfo.getSeverity());
        container.put("lineInfo", String.valueOf(diagInfo.getBeginLine()));
    }

    public void toWddxPacket(Writer out) throws IOException {
        this.normalizeResults();
        this.populateCodeSnippet();
        Struct temp = new Struct();
        Iterator i = this.summary.keySet().iterator();
        while (i.hasNext()) {
            Map pageCount;
            String key = i.next().toString();
            SummaryInfo summaryInfo = (SummaryInfo)this.summary.get(key);
            String category = key.substring(0, key.indexOf("-"));
            String severity = key.substring(key.indexOf("-") + 1);
            Map data = (Map)temp.get(category);
            if (data == null) {
                data = new Struct();
                temp.put(category, data);
            }
            if ((pageCount = (Map)data.get("pageCount")) == null) {
                pageCount = new Struct();
                data.put("pageCount", pageCount);
            }
            pageCount.put(severity.trim(), String.valueOf(summaryInfo.getFileCount()));
            Map rawCount = (Map)data.get("rawCount");
            if (rawCount == null) {
                rawCount = new Struct();
                data.put("rawCount", rawCount);
            }
            rawCount.put(severity.trim(), String.valueOf(summaryInfo.getItemCount()));
        }
        Struct analysisResult = new Struct();
        analysisResult.put("summary", temp);
        analysisResult.put("detail", this.detail);
        WddxSerializer ws = new WddxSerializer();
        ws.serialize((Object)analysisResult, out);
    }

    private void populateCodeSnippet() {
        Iterator i = this.detail.keySet().iterator();
        while (i.hasNext()) {
            String fileName = i.next().toString();
            Collection items = (Collection)this.detail.get(fileName);
            for (Map details : items) {
                details.put("cfmlCode", this.readLines(fileName, details.get("lineInfo").toString()));
            }
        }
    }

    private String readLines(String fileName, String lineInfo) {
        int curLine;
        LineNumberReader lineReader;
        try {
            lineReader = new LineNumberReader(new TemplateReader(new FileInputStream(fileName)));
        }
        catch (IOException ex) {
            return "";
        }
        StringBuffer snippet = new StringBuffer();
        Array lines = ListFunc.ListToArray(lineInfo, ";");
        int[] lineNumbers = new int[lines.size() * 3];
        int prevLine = 0;
        int index = 0;
        for (int i = 0; i < lines.size(); ++i) {
            try {
                curLine = Integer.parseInt(lines.get(i).toString());
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (curLine - 1 > prevLine) {
                lineNumbers[index] = curLine - 1;
                lineNumbers[++index] = curLine;
                ++index;
            } else {
                lineNumbers[index++] = curLine;
            }
            lineNumbers[index] = prevLine = curLine + 1;
            ++index;
        }
        int totalline = index;
        int endLine = lineNumbers[index - 1];
        index = 0;
        try {
            prevLine = -1;
            boolean commaAdded = false;
            while (lineReader.getLineNumber() < endLine && index < totalline) {
                String currentLine = lineReader.readLine();
                if (currentLine == null) {
                    snippet.append("    ......\r\n");
                    break;
                }
                curLine = lineReader.getLineNumber();
                if (curLine < lineNumbers[index] && !commaAdded) {
                    snippet.append("    ......\r\n");
                    commaAdded = true;
                    continue;
                }
                if (curLine != lineNumbers[index]) continue;
                snippet.append(curLine + ":    " + currentLine + "\r\n");
                ++index;
                commaAdded = false;
            }
            return snippet.toString();
        }
        catch (IOException ioe) {
            return "";
        }
    }

    private void doSummary(Collection results) {
        String category;
        Struct temp = new Struct();
        Map workingTable = this.summary;
        for (CfmlDiagnosticInfo diagInfo : results) {
            String severity;
            category = diagInfo.getCategory();
            ArrayList<CfmlDiagnosticInfo> items = (ArrayList<CfmlDiagnosticInfo>)temp.get(category + "-" + (severity = diagInfo.getSeverity().toLowerCase()));
            if (items == null) {
                items = new ArrayList<CfmlDiagnosticInfo>();
                temp.put(category + "-" + severity, items);
            }
            items.add(diagInfo);
        }
        Iterator<Object> i = temp.keySet().iterator();
        while (i.hasNext()) {
            category = i.next().toString();
            SummaryInfo summaryInfo = (SummaryInfo)workingTable.get(category);
            if (summaryInfo == null) {
                summaryInfo = new SummaryInfo();
                workingTable.put(category, summaryInfo);
            }
            summaryInfo.increaseFileCount();
            summaryInfo.increaseItemCount(((Collection)temp.get(category)).size());
        }
    }

    private class SummaryInfo {
        private int numOfItems = 0;
        private int numOfFiles = 0;

        private SummaryInfo() {
        }

        public void increaseFileCount() {
            ++this.numOfFiles;
        }

        public void increaseItemCount(int items) {
            this.numOfItems += items;
        }

        public int getFileCount() {
            return this.numOfFiles;
        }

        public int getItemCount() {
            return this.numOfItems;
        }
    }
}

