/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.Version;
import coldfusion.util.RB;

public class CfinfoMain {
    public static void main(String[] args) {
        int argCount = args.length;
        if (argCount == 0) {
            CfinfoMain.printUsage();
        }
        for (int i = 0; i < argCount; ++i) {
            if ("-baseinfo".equals(args[i])) {
                System.out.println(CfinfoMain.getBaseInfo());
                break;
            }
            if ("-info".equals(args[i])) {
                System.out.println(CfinfoMain.getInfo());
                continue;
            }
            if ("-version".equals(args[i])) {
                System.out.println(Version.getVersionString(System.getProperty("CFUSION_HOME")));
                continue;
            }
            CfinfoMain.printUsage();
        }
    }

    public static String getInfo() {
        String info = Version.getProductName() + " " + Version.getVersionString(System.getProperty("CFUSION_HOME"));
        if (Version.getBuildDate() != null && Version.getBuildDate().trim().length() != 0) {
            info = info + " (" + Version.getBuildDate() + ")";
        }
        return info;
    }

    public static String getBaseInfo() {
        String info = System.getProperty("line.separator") + Version.getProductName() + " Base Version: " + Version.getBaseVersion() + "," + Version.getBuild();
        return info;
    }

    private static void printUsage() {
        System.out.println();
        System.out.print(RB.getString(CfinfoMain.class, "Cfinfo.USAGE"));
        System.exit(0);
    }
}

