/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.runtime.ApplicationException;
import coldfusion.tools.CfstatConstants;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CfstatClient
implements CfstatConstants {
    private Socket socket;
    private InputStream socketIn;
    private OutputStream socketOut;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    private Hashtable metricData;

    public CfstatClient(int port) {
        this.init(IPAddressUtils.getLocalHostIP(), port);
    }

    private void init(String host, int port) {
        try {
            this.socket = port == 0 ? new Socket(host, this.readPortFromXmlFile()) : new Socket(host, port);
            this.socketIn = this.socket.getInputStream();
            this.socketOut = this.socket.getOutputStream();
        }
        catch (ConnectException ex) {
            throw new CFServerNotFoundException();
        }
        catch (Exception ex) {
            throw new CfstatException((Throwable)ex);
        }
        this.ping();
    }

    private int readPortFromXmlFile() throws ParserConfigurationException {
        String neoMetricXmlPath = System.getProperty("CFUSION_HOME") + File.separator + "lib" + File.separator + "neo-metric.xml";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(neoMetricXmlPath);
            NodeList varNodeList = doc.getElementsByTagName("var");
            for (int s = 0; s < varNodeList.getLength(); ++s) {
                Node firstNode = varNodeList.item(s);
                Element firstElement = (Element)firstNode;
                String attributeName = firstElement.getAttribute("name");
                if (!attributeName.equalsIgnoreCase("cfstatport")) continue;
                NodeList stringNodeList = firstElement.getElementsByTagName("string");
                firstElement = (Element)stringNodeList.item(0);
                return Integer.parseInt(firstElement.getTextContent());
            }
        }
        catch (IOException | NumberFormatException | SAXException e) {
            throw new CfstatException((Throwable)e);
        }
        return 7989;
    }

    private void ping() {
        try {
            this.out = new ObjectOutputStream(this.socketOut);
            this.out.writeInt(4);
            this.out.flush();
            this.in = new ObjectInputStream(this.socketIn);
            int status = this.in.readInt();
            if (status == -1) {
                throw new CfstatException((Throwable)new Exception(this.in.readUTF()));
            }
            this.in.readInt();
        }
        catch (Exception ioe) {
            if (ioe.getMessage() != null) {
                throw new CfstatException((Throwable)ioe);
            }
            throw new CfstatException(RB.getString(this, "CfstatClient.NoCfstatServer"), ioe);
        }
    }

    public Hashtable getMetricData() {
        try {
            this.out.writeInt(2);
            this.out.flush();
            int status = this.in.readInt();
            if (status == -1) {
                throw new CfstatException(this.in.readUTF());
            }
            this.metricData = (Hashtable)this.in.readObject();
        }
        catch (Exception ex) {
            if (ex instanceof CfstatException) {
                throw (CfstatException)ex;
            }
            throw new CfstatException((Throwable)ex);
        }
        return this.metricData;
    }

    public void destroy() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socketIn != null) {
                this.socketIn.close();
            }
            if (this.socketOut != null) {
                this.socketOut.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class CFServerNotFoundException
    extends ApplicationException {
    }

    public class CfstatException
    extends ApplicationException {
        public String errorDetail;

        public CfstatException(Throwable rootCause) {
            super(rootCause);
            this.errorDetail = rootCause.getMessage();
        }

        public CfstatException(String message, Throwable rootCause) {
            super(rootCause);
            this.errorDetail = message;
        }

        public CfstatException(String message) {
            this.errorDetail = message;
        }

        @Override
        public String getMessage() {
            return this.errorDetail;
        }
    }
}

