/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.runtime.ApplicationException;
import coldfusion.tools.CfstatClient;
import coldfusion.util.RB;
import java.util.Hashtable;

public class CfstatMain {
    private boolean printHeader = true;
    private boolean singleLine = false;
    private int interval = 0;
    private boolean extended = false;
    private Hashtable prevData;
    private Hashtable curData;
    private int pageHits;
    private int dbHits;
    private long bytesIn;
    private long bytesOut;
    private String cachePop = "-1";
    private int pageHitsMax;
    private int dbHitsMax;
    private String cachePopMax = "-1";
    private int rowCount = 22;
    private final int REPEAT_HEADER = 22;
    private CfstatClient client;
    private int port;

    public static void main(String[] args) {
        CfstatMain worker = new CfstatMain();
        worker.processArgs(args);
        try {
            worker.doDisplay();
        }
        catch (Throwable error) {
            System.out.println(error.toString());
        }
        finally {
            worker.cleanup();
        }
    }

    public void processArgs(String[] args) {
        int argCount = args.length;
        boolean isPort = false;
        for (int i = 0; i < argCount; ++i) {
            if ("-n".equals(args[i])) {
                this.printHeader = false;
                continue;
            }
            if ("-s".equals(args[i])) {
                this.singleLine = true;
                continue;
            }
            if ("-port".equals(args[i])) {
                isPort = true;
                continue;
            }
            if ("-x".equals(args[i])) {
                this.extended = true;
                continue;
            }
            if (isPort) {
                isPort = false;
                this.port = this.parseInt(args[i]);
                if (this.port != -1) continue;
                this.printUsage();
                continue;
            }
            this.interval = this.parseInt(args[i]);
            if (this.interval != -1) continue;
            this.printUsage();
        }
    }

    public void cleanup() {
        if (this.client != null) {
            this.client.destroy();
        }
    }

    private int parseInt(String arg) {
        int temp = -1;
        try {
            temp = Integer.parseInt(arg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return temp;
    }

    public void doDisplay() throws Exception {
        try {
            this.client = new CfstatClient(this.port);
        }
        catch (ApplicationException ex) {
            System.out.println();
            System.out.println(ex.getMessage());
            System.out.println();
            System.exit(0);
        }
        this.curData = this.client.getMetricData();
        this.processData();
        if (this.extended && !this.curData.containsKey("TemplateReqRunning")) {
            this.extended = false;
        }
        if (this.singleLine) {
            int firstInterval = this.interval > 0 ? this.interval : 3;
            Thread.sleep(firstInterval * 1000);
        }
        while (true) {
            this.curData = this.client.getMetricData();
            this.processData();
            this.displayData();
            if (this.singleLine || this.interval <= 0) break;
            Thread.sleep(this.interval * 1000);
        }
    }

    private void printUsage() {
        System.out.println();
        System.out.print(RB.getString(this, "Cfstat.USAGE"));
        System.exit(0);
    }

    private void processData() {
        if (this.prevData == null) {
            this.prevData = this.curData;
        } else {
            long elapseTime = Long.parseLong(this.curData.get("SnapshotTime").toString()) - Long.parseLong(this.prevData.get("SnapshotTime").toString());
            float dtime = (float)elapseTime / 1000.0f;
            if (elapseTime != 0L) {
                int old = Integer.parseInt(this.prevData.get("PageHits").toString());
                int cur = Integer.parseInt(this.curData.get("PageHits").toString());
                this.pageHits = Math.round((float)(cur - old) / dtime);
                if (this.pageHits > this.pageHitsMax) {
                    this.pageHitsMax = this.pageHits;
                }
                try {
                    old = Integer.parseInt(this.prevData.get("DBHits").toString());
                    cur = Integer.parseInt(this.curData.get("DBHits").toString());
                    this.dbHits = Math.round((float)(cur - old) / dtime);
                    if (this.dbHits > this.dbHitsMax) {
                        this.dbHitsMax = this.dbHits;
                    }
                }
                catch (Exception e) {
                    this.dbHits = 0;
                    this.dbHitsMax = 0;
                }
                long l_old = Long.parseLong(this.prevData.get("BytesIn").toString());
                long l_cur = Long.parseLong(this.curData.get("BytesIn").toString());
                if (l_cur < l_old) {
                    l_old = 0L;
                }
                this.bytesIn = Math.round((float)(l_cur - l_old) / dtime);
                l_old = Long.parseLong(this.prevData.get("BytesOut").toString());
                l_cur = Long.parseLong(this.curData.get("BytesOut").toString());
                if (l_cur < l_old) {
                    l_old = 0L;
                }
                this.bytesOut = Math.round((float)(l_cur - l_old) / dtime);
            }
            this.prevData = this.curData;
        }
    }

    private void displayData() {
        if (this.printHeader && this.rowCount++ >= 22) {
            this.rowCount = 0;
            System.out.println();
            if (this.extended) {
                System.out.println(RB.getString(this, "Cfstat.extended"));
            } else {
                System.out.println(RB.getString(this, "Cfstat.HEADER"));
            }
        }
        System.out.print(this.format(Integer.toString(this.pageHits), 4));
        System.out.print(this.format(Integer.toString(this.pageHitsMax), 4));
        System.out.print(this.format(Integer.toString(this.dbHits), 4));
        System.out.print(this.format(Integer.toString(this.dbHitsMax), 4));
        System.out.print(this.format(this.cachePop, 4));
        System.out.print(this.format(this.cachePopMax, 4));
        System.out.print(this.format(this.curData.get("ReqQueued").toString(), 6));
        System.out.print(this.format(this.curData.get("ReqRunning").toString(), 6));
        System.out.print(this.format(this.curData.get("errorCount").toString(), 6));
        if (this.extended) {
            System.out.print(this.format(this.curData.get("TemplateReqQueued").toString(), 6));
            System.out.print(this.format(this.curData.get("TemplateReqRunning").toString(), 6));
            System.out.print(this.format(this.curData.get("TemplateReqTimedOut").toString(), 7));
            System.out.print(this.format(this.curData.get("CfcReqQueued").toString(), 6));
            System.out.print(this.format(this.curData.get("CfcReqRunning").toString(), 6));
            System.out.print(this.format(this.curData.get("CfcReqTimedOut").toString(), 6));
            System.out.print(this.format(this.curData.get("WsReqQueued").toString(), 6));
            System.out.print(this.format(this.curData.get("WsReqRunning").toString(), 6));
            System.out.print(this.format(this.curData.get("WsReqTimedOut").toString(), 6));
        }
        String s = !((String)this.curData.get("AvgQueueTime")).equalsIgnoreCase("") ? this.curData.get("AvgQueueTime").toString() : "0";
        System.out.print(this.format(s, 7));
        s = !((String)this.curData.get("AvgReqTime")).equalsIgnoreCase("") ? this.curData.get("AvgReqTime").toString() : "0";
        System.out.print(this.format(s, 7));
        s = !((String)this.curData.get("AvgDBTime")).equalsIgnoreCase("") ? this.curData.get("AvgDBTime").toString() : "0";
        System.out.print(this.format(s, 7));
        System.out.print(this.format(Long.toString(this.bytesIn), 7));
        System.out.println(this.format(Long.toString(this.bytesOut), 6));
    }

    private String format(String data, int allowedSpace) {
        StringBuffer buf = new StringBuffer(data);
        for (int space = allowedSpace - data.length(); space > 0; --space) {
            buf.append(" ");
        }
        return buf.toString();
    }
}

