/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.Version;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ListFunc;
import coldfusion.tools.CodeAnalyzerException;
import coldfusion.tools.CompatibilityIssue;
import coldfusion.tools.ComplexCompatibilityIssue;
import coldfusion.tools.FunctionCompatibilityIssue;
import coldfusion.tools.TagCompatibilityIssue;
import coldfusion.util.FastHashtable;
import coldfusion.wddx.WddxDeserializer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.InputSource;

public class CompatibilityMetaInfo
implements Serializable {
    private static final String CUR_REV = Version.getMajor();
    private static final String PREV_REV = "2023";
    private static final String PREV2_REV = "2021";
    private static final String SEV_ALL = "all";
    private static final String SEV_ERR = "Error";
    private static final String SEV_INFO = "Info";
    private static final long serialVersionUID = 1L;
    private Map metaInfo;
    private String allTagFeatures;
    private String allFuncFeatures;
    private String allOtherFeatures;
    private String lastRevTagFeatures;
    private String lastRevFuncFeatures;
    private String lastRevOtherFeatures;
    private String lastRevTagFeatures_sevERR;
    private String lastRevFuncFeatures_sevERR;
    private String lastRevOtherFeatures_sevERR;
    private String lastRevTagFeatures_sevINFO;
    private String lastRevFuncFeatures_sevINFO;
    private String lastRevOtherFeatures_sevINFO;
    private String last2RevTagFeatures;
    private String last2RevFuncFeatures;
    private String last2RevOtherFeatures;
    private String last2RevTagFeatures_sevERR;
    private String last2RevFuncFeatures_sevERR;
    private String last2RevOtherFeatures_sevERR;
    private String last2RevTagFeatures_sevINFO;
    private String last2RevFuncFeatures_sevINFO;
    private String last2RevOtherFeatures_sevINFO;
    private String last3RevTagFeatures;
    private String last3RevFuncFeatures;
    private String last3RevOtherFeatures;
    private String last3RevTagFeatures_sevERR;
    private String last3RevFuncFeatures_sevERR;
    private String last3RevOtherFeatures_sevERR;
    private String last3RevTagFeatures_sevINFO;
    private String last3RevFuncFeatures_sevINFO;
    private String last3RevOtherFeatures_sevINFO;
    private static CompatibilityMetaInfo metaObject;

    public static CompatibilityMetaInfo instance(String uri) {
        if (metaObject == null) {
            try {
                WddxDeserializer deserializer = new WddxDeserializer();
                FileInputStream input = new FileInputStream(uri);
                InputSource source = new InputSource(new InputStreamReader((InputStream)input, "UTF-8"));
                Vector xmlData = (Vector)deserializer.deserialize(source);
                ((InputStream)input).close();
                metaObject = new CompatibilityMetaInfo(CompatibilityMetaInfo.createMetaInfoObjects(xmlData));
            }
            catch (Exception ex) {
                throw new CodeAnalyzerException(ex);
            }
        }
        return metaObject;
    }

    private CompatibilityMetaInfo(Map metaInfo) {
        this.metaInfo = metaInfo;
        StringBuffer tag = new StringBuffer();
        StringBuffer func = new StringBuffer();
        StringBuffer other = new StringBuffer();
        StringBuffer lastRevTag = new StringBuffer();
        StringBuffer lastRevFunc = new StringBuffer();
        StringBuffer lastRevOther = new StringBuffer();
        StringBuffer lastRevTag_sevERR = new StringBuffer();
        StringBuffer lastRevFunc_sevERR = new StringBuffer();
        StringBuffer lastRevOther_sevERR = new StringBuffer();
        StringBuffer lastRevTag_sevINFO = new StringBuffer();
        StringBuffer lastRevFunc_sevINFO = new StringBuffer();
        StringBuffer lastRevOther_sevINFO = new StringBuffer();
        StringBuffer last2RevTag = new StringBuffer();
        StringBuffer last2RevFunc = new StringBuffer();
        StringBuffer last2RevOther = new StringBuffer();
        StringBuffer last2RevTag_sevERR = new StringBuffer();
        StringBuffer last2RevFunc_sevERR = new StringBuffer();
        StringBuffer last2RevOther_sevERR = new StringBuffer();
        StringBuffer last2RevTag_sevINFO = new StringBuffer();
        StringBuffer last2RevFunc_sevINFO = new StringBuffer();
        StringBuffer last2RevOther_sevINFO = new StringBuffer();
        StringBuffer last3RevTag = new StringBuffer();
        StringBuffer last3RevFunc = new StringBuffer();
        StringBuffer last3RevOther = new StringBuffer();
        StringBuffer last3RevTag_sevERR = new StringBuffer();
        StringBuffer last3RevFunc_sevERR = new StringBuffer();
        StringBuffer last3RevOther_sevERR = new StringBuffer();
        StringBuffer last3RevTag_sevINFO = new StringBuffer();
        StringBuffer last3RevFunc_sevINFO = new StringBuffer();
        StringBuffer last3RevOther_sevINFO = new StringBuffer();
        Iterator keys = metaInfo.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            CompatibilityIssue value = (CompatibilityIssue)metaInfo.get(key);
            String category = value.getCategory();
            String version = value.getVersion();
            String keyWithoutVersion = key.split(version)[0];
            String severity = value.getSeverity();
            if (category.equalsIgnoreCase("Tag") || category.equalsIgnoreCase("TagAttribute")) {
                tag.append(keyWithoutVersion).append(',');
                if (version.compareTo(CUR_REV) == 0) {
                    lastRevTag.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0) {
                    last2RevTag.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV2_REV) == 0) {
                    last3RevTag.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    lastRevTag_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    last2RevTag_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    last3RevTag_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                    lastRevTag_sevINFO.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                    last2RevTag_sevINFO.append(keyWithoutVersion).append(',');
                }
                if (!(version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_INFO) == 0)) continue;
                last3RevTag_sevINFO.append(keyWithoutVersion).append(',');
                continue;
            }
            if (category.equalsIgnoreCase("Function")) {
                func.append(keyWithoutVersion).append(',');
                if (version.compareTo(CUR_REV) == 0) {
                    lastRevFunc.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0) {
                    last2RevFunc.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV2_REV) == 0) {
                    last3RevFunc.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    lastRevFunc_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    last2RevFunc_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                    last3RevFunc_sevERR.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                    lastRevFunc_sevINFO.append(keyWithoutVersion).append(',');
                }
                if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                    last2RevFunc_sevINFO.append(keyWithoutVersion).append(',');
                }
                if (!(version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_INFO) == 0)) continue;
                last3RevFunc_sevINFO.append(keyWithoutVersion).append(',');
                continue;
            }
            other.append(keyWithoutVersion).append(',');
            if (version.compareTo(CUR_REV) == 0) {
                lastRevOther.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(PREV_REV) == 0) {
                last2RevOther.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(PREV2_REV) == 0) {
                last3RevOther.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                lastRevOther_sevERR.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                last2RevOther_sevERR.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_ERR) == 0) {
                last3RevOther_sevERR.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(CUR_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                lastRevOther_sevINFO.append(keyWithoutVersion).append(',');
            }
            if (version.compareTo(PREV_REV) == 0 & severity.compareTo(SEV_INFO) == 0) {
                last2RevOther_sevINFO.append(keyWithoutVersion).append(',');
            }
            if (!(version.compareTo(PREV2_REV) == 0 & severity.compareTo(SEV_INFO) == 0)) continue;
            last3RevOther_sevINFO.append(keyWithoutVersion).append(',');
        }
        if (func.length() > 0) {
            func.deleteCharAt(func.length() - 1);
        }
        if (tag.length() > 0) {
            tag.deleteCharAt(tag.length() - 1);
        }
        if (other.length() > 0) {
            other.deleteCharAt(other.length() - 1);
        }
        this.allTagFeatures = tag.toString();
        this.allFuncFeatures = func.toString();
        this.allOtherFeatures = other.toString();
        this.lastRevTagFeatures = lastRevTag.toString();
        this.lastRevFuncFeatures = lastRevFunc.toString();
        this.lastRevOtherFeatures = lastRevOther.toString();
        this.lastRevTagFeatures_sevERR = lastRevTag_sevERR.toString();
        this.lastRevFuncFeatures_sevERR = lastRevFunc_sevERR.toString();
        this.lastRevOtherFeatures_sevERR = lastRevOther_sevERR.toString();
        this.lastRevTagFeatures_sevINFO = lastRevTag_sevINFO.toString();
        this.lastRevFuncFeatures_sevINFO = lastRevFunc_sevINFO.toString();
        this.lastRevOtherFeatures_sevINFO = lastRevOther_sevINFO.toString();
        this.last2RevTagFeatures = lastRevTag.toString() + last2RevTag.toString();
        this.last2RevFuncFeatures = lastRevFunc.toString() + last2RevFunc.toString();
        this.last2RevOtherFeatures = lastRevOther.toString() + last2RevOther.toString();
        this.last2RevTagFeatures_sevERR = lastRevTag_sevERR.toString() + last2RevTag_sevERR.toString();
        this.last2RevFuncFeatures_sevERR = lastRevFunc_sevERR.toString() + last2RevFunc_sevERR.toString();
        this.last2RevOtherFeatures_sevERR = lastRevOther_sevERR.toString() + last2RevOther_sevERR.toString();
        this.last2RevTagFeatures_sevINFO = lastRevTag_sevINFO.toString() + last2RevTag_sevINFO.toString();
        this.last2RevFuncFeatures_sevINFO = lastRevFunc_sevINFO.toString() + last2RevFunc_sevINFO.toString();
        this.last2RevOtherFeatures_sevINFO = lastRevOther_sevINFO.toString() + last2RevOther_sevINFO.toString();
        this.last3RevTagFeatures = this.last2RevTagFeatures + last3RevTag.toString();
        this.last3RevFuncFeatures = this.last2RevFuncFeatures + last3RevFunc.toString();
        this.last3RevOtherFeatures = this.last2RevOtherFeatures + last3RevOther.toString();
        this.last3RevTagFeatures_sevERR = this.last2RevTagFeatures_sevERR + last3RevTag_sevERR.toString();
        this.last3RevFuncFeatures_sevERR = this.last2RevFuncFeatures_sevERR + last3RevFunc_sevERR.toString();
        this.last3RevOtherFeatures_sevERR = this.last2RevOtherFeatures_sevERR + last3RevOther_sevERR.toString();
        this.last3RevTagFeatures_sevINFO = this.last2RevTagFeatures_sevINFO + last3RevTag_sevINFO.toString();
        this.last3RevFuncFeatures_sevINFO = this.last2RevFuncFeatures_sevINFO + last3RevFunc_sevINFO.toString();
        this.last3RevOtherFeatures_sevINFO = this.last2RevOtherFeatures_sevINFO + last3RevOther_sevINFO.toString();
    }

    public List<CompatibilityIssue> lookup(String feature, String codeVersion) {
        ArrayList<CompatibilityIssue> list = new ArrayList<CompatibilityIssue>();
        if (Integer.valueOf(CUR_REV) > Integer.valueOf(codeVersion)) {
            list.add((CompatibilityIssue)this.metaInfo.get(feature + CUR_REV));
        }
        if (Integer.valueOf(PREV_REV) > Integer.valueOf(codeVersion)) {
            list.add((CompatibilityIssue)this.metaInfo.get(feature + PREV_REV));
        }
        if (Integer.valueOf(PREV2_REV) > Integer.valueOf(codeVersion)) {
            list.add((CompatibilityIssue)this.metaInfo.get(feature + PREV2_REV));
        }
        return list;
    }

    public String getAllTagFeatures() {
        return CFPage.ListSort(this.allTagFeatures, "Text", "asc", ",");
    }

    public String getAllFuncFeatures() {
        return CFPage.ListSort(this.allFuncFeatures, "Text", "asc", ",");
    }

    public String getAllOtherFeatures() {
        return CFPage.ListSort(this.allOtherFeatures, "Text", "asc", ",");
    }

    public String getLastRevTagFeatures() {
        return CFPage.ListSort(this.lastRevTagFeatures, "Text", "asc", ",");
    }

    public String getLastRevFuncFeatures() {
        return CFPage.ListSort(this.lastRevFuncFeatures, "Text", "asc", ",");
    }

    public String getLastRevOtherFeatures() {
        return CFPage.ListSort(this.lastRevOtherFeatures, "Text", "asc", ",");
    }

    public String getLastRevTagFeaturesERR() {
        return CFPage.ListSort(this.lastRevTagFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLastRevFuncFeaturesERR() {
        return CFPage.ListSort(this.lastRevFuncFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLastRevOtherFeaturesERR() {
        return CFPage.ListSort(this.lastRevOtherFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLastRevTagFeaturesINFO() {
        return CFPage.ListSort(this.lastRevTagFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLastRevFuncFeaturesINFO() {
        return CFPage.ListSort(this.lastRevFuncFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLastRevOtherFeaturesINFO() {
        return CFPage.ListSort(this.lastRevOtherFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast2RevTagFeatures() {
        return CFPage.ListSort(this.last2RevTagFeatures, "Text", "asc", ",");
    }

    public String getLast2RevFuncFeatures() {
        return CFPage.ListSort(this.last2RevFuncFeatures, "Text", "asc", ",");
    }

    public String getLast2RevOtherFeatures() {
        return CFPage.ListSort(this.last2RevOtherFeatures, "Text", "asc", ",");
    }

    public String getLast2RevTagFeaturesERR() {
        return CFPage.ListSort(this.last2RevTagFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast2RevFuncFeaturesERR() {
        return CFPage.ListSort(this.last2RevFuncFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast2RevOtherFeaturesERR() {
        return CFPage.ListSort(this.last2RevOtherFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast2RevTagFeaturesINFO() {
        return CFPage.ListSort(this.last2RevTagFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast2RevFuncFeaturesINFO() {
        return CFPage.ListSort(this.last2RevFuncFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast2RevOtherFeaturesINFO() {
        return CFPage.ListSort(this.last2RevOtherFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast3RevTagFeatures() {
        return CFPage.ListSort(this.last3RevTagFeatures, "Text", "asc", ",");
    }

    public String getLast3RevFuncFeatures() {
        return CFPage.ListSort(this.last3RevFuncFeatures, "Text", "asc", ",");
    }

    public String getLast3RevOtherFeatures() {
        return CFPage.ListSort(this.last3RevOtherFeatures, "Text", "asc", ",");
    }

    public String getLast3RevTagFeaturesERR() {
        return CFPage.ListSort(this.last3RevTagFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast3RevFuncFeaturesERR() {
        return CFPage.ListSort(this.last3RevFuncFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast3RevOtherFeaturesERR() {
        return CFPage.ListSort(this.last3RevOtherFeatures_sevERR, "Text", "asc", ",");
    }

    public String getLast3RevTagFeaturesINFO() {
        return CFPage.ListSort(this.last3RevTagFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast3RevFuncFeaturesINFO() {
        return CFPage.ListSort(this.last3RevFuncFeatures_sevINFO, "Text", "asc", ",");
    }

    public String getLast3RevOtherFeaturesINFO() {
        return CFPage.ListSort(this.last3RevOtherFeatures_sevINFO, "Text", "asc", ",");
    }

    private static Map createMetaInfoObjects(Vector<Vector<String>> xmlData) throws SQLException {
        FastHashtable map = new FastHashtable();
        for (Vector<String> isueItem : xmlData) {
            if (isueItem.get(0) == null) break;
            String desc = isueItem.get(0);
            String remedy = isueItem.get(1);
            String severity = isueItem.get(2);
            String featureName = isueItem.get(3).trim().toUpperCase();
            String category = isueItem.get(4);
            String attributes = isueItem.get(5);
            String attrvalues = isueItem.get(6);
            String version = isueItem.get(7);
            if (category.equals("Tag") || category.equals("TagAttribute")) {
                if (attributes.equals("N/A")) {
                    attributes = null;
                }
                if (attrvalues.equals("N/A")) {
                    attrvalues = null;
                }
                CompatibilityMetaInfo.createTagIssues(desc, remedy, severity, featureName, category, version, attributes, attrvalues, map);
                continue;
            }
            if (!category.equals("Function")) {
                category = "Others";
            }
            CompatibilityMetaInfo.createFunctionIssues(desc, remedy, severity, featureName, category, version, map, attributes, attrvalues);
        }
        Locale locale = Locale.getDefault();
        if (!locale.equals(Locale.JAPAN) && !locale.equals(Locale.JAPANESE)) {
            map.remove("parsedatetime");
        }
        return map;
    }

    private static void createTagIssues(String desc, String remedy, String severity, String featureName, String category, String version, String attributes, String attrvalues, Map map) {
        Array features = ListFunc.ListToArray(featureName, ",");
        Iterator i = features.iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            TagCompatibilityIssue issue = new TagCompatibilityIssue(desc, remedy, severity, name, category, version, attributes, attrvalues);
            CompatibilityMetaInfo.putIssue(issue, map, name, version, attributes, attrvalues);
        }
    }

    private static void putIssue(TagCompatibilityIssue issue, Map map, String featureName, String version, String attributes, String attrValues) {
        TagCompatibilityIssue oldIssue = (TagCompatibilityIssue)map.get(featureName);
        if (oldIssue == null) {
            map.put(featureName + version, issue);
            return;
        }
        if (oldIssue instanceof ComplexCompatibilityIssue) {
            ((ComplexCompatibilityIssue)oldIssue).addIssue(attributes, attrValues, issue);
        } else {
            ComplexCompatibilityIssue complex = new ComplexCompatibilityIssue();
            complex.setSeverity(issue.severity);
            complex.addIssue(oldIssue.getAttributes(), oldIssue.getAttributeValues(), oldIssue);
            complex.addIssue(attributes, attrValues, issue);
            map.put(featureName + version, complex);
        }
    }

    private static void createFunctionIssues(String desc, String remedy, String severity, String featureName, String category, String version, Map map, String attributes, String attrvalues) {
        Array features = ListFunc.ListToArray(featureName, ",");
        Iterator i = features.iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            FunctionCompatibilityIssue issue = new FunctionCompatibilityIssue(desc, remedy, severity, name, category, version, attributes, attrvalues);
            map.put(name + version, issue);
        }
    }
}

