/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.validation.CFMLCompileError;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.license.LicenseManager;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tools.CompilerContext;
import coldfusion.util.IOUtils;
import coldfusion.util.Utils;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Compiler {
    private static final boolean stripBuildPathFromAdminPages = Boolean.getBoolean("coldfusion.build.stripbuildpathfromadminpages");

    public static void main(String[] args) throws IOException {
        ArrayList<File> templateCanonicalFiles = new ArrayList<File>();
        CompilerContext application = new CompilerContext();
        application.setInitParameter("coldfusion.compiler.errorAggregate", "true");
        boolean optionsOk = true;
        String webroot = null;
        String webinf = null;
        boolean debug = false;
        boolean force = false;
        boolean deploy = false;
        String deployDir = null;
        String srcDir = null;
        String cf_root = null;
        List<CompileError> errors = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            int equals = args[i].indexOf("=");
            if (optionsOk && equals != -1) {
                String name = args[i].substring(0, equals);
                String value = args[i].substring(equals + 1);
                application.setInitParameter(name, value);
                continue;
            }
            if (optionsOk && args[i].equals("-help")) {
                System.out.println("Usage: java " + Compiler.class.getName() + " [options] files ...");
                System.out.println("   -webroot path            path containing WEB-INF");
                System.out.println("   -webinf path             location of WEB-INF dir");
                System.out.println("   -f or -force             force compilation");
                System.out.println("   -v or -verbose           print compiler performance stats");
                System.out.println("   -g or -debug             enable debug symbols and save java");
                System.out.println("   -d or -deploy            compile for source-less deployment");
                System.out.println("   -srcdir path             the directory that contains the source to compile");
                System.out.println("   -deploydir path          the directory to place the deployable files in");
                System.out.println("   -cfroot path             the root directory where CF is installed");
                System.exit(0);
                continue;
            }
            if (optionsOk && args[i].equals("-webroot")) {
                File tempWebRoot;
                if (!(tempWebRoot = new File(args[++i])).exists()) {
                    Compiler.exit(1, "Webroot specified does not exist");
                }
                webroot = tempWebRoot.getCanonicalPath();
                application.setWebRoot(webroot);
                continue;
            }
            if (optionsOk && args[i].equals("-webinf")) {
                webinf = new File(args[++i]).getCanonicalPath();
                application.setWebInf(webinf);
                continue;
            }
            if (optionsOk && (args[i].equals("-v") || args[i].equals("-verbose"))) {
                NeoTranslator.verbose = true;
                continue;
            }
            if (optionsOk && (args[i].equals("-g") || args[i].equals("-debug"))) {
                debug = true;
                continue;
            }
            if (optionsOk && (args[i].equals("-f") || args[i].equals("-force"))) {
                force = true;
                continue;
            }
            if (optionsOk && args[i].equals("-list")) {
                System.out.println("list: " + args[i]);
                String fileName = args[++i];
                File list = new File(fileName);
                if (!list.exists()) {
                    throw new FileNotFoundException(fileName);
                }
                FileReader in = new FileReader(list);
                BufferedReader rin = new BufferedReader(in);
                String line = rin.readLine();
                while (line != null) {
                    File file = new File(line);
                    templateCanonicalFiles.add(file.getCanonicalFile());
                    line = rin.readLine();
                }
                continue;
            }
            if (optionsOk && args[i].equals("-d") || args[i].equals("-deploy")) {
                deploy = true;
                continue;
            }
            if (optionsOk && args[i].equals("-deploydir")) {
                deployDir = new File(args[++i]).getCanonicalPath();
                continue;
            }
            if (optionsOk && args[i].equals("-srcdir")) {
                srcDir = new File(args[++i]).getCanonicalPath();
                continue;
            }
            if (optionsOk && args[i].equals("-cfroot")) {
                cf_root = new File(args[++i]).getCanonicalPath();
                continue;
            }
            if (webroot == null) {
                webroot = Compiler.findWebRoot();
                if (webroot != null) {
                    application.setWebRoot(webroot);
                } else if (webinf != null) {
                    webroot = new File(".").getCanonicalPath();
                    if (webroot.endsWith(File.separator)) {
                        webroot = webroot.substring(0, webroot.length() - 1);
                    }
                    application.setWebRoot(webroot);
                } else {
                    Compiler.exit(1, "Error: web root was not set and could not be found.");
                }
            }
            optionsOk = false;
            File f = new File(args[i]);
            String template = f.getCanonicalPath();
            if (template.startsWith(webroot)) {
                if (f.isDirectory()) {
                    Compiler.addFiles(templateCanonicalFiles, f, webroot);
                    continue;
                }
                templateCanonicalFiles.add(f.getCanonicalFile());
                continue;
            }
            Compiler.exit(1, "error: " + template + " is not under the web root: " + webroot);
        }
        Compiler.readInitParameters(application);
        if (debug) {
            application.setInitParameter("neodebug", "true");
        }
        Thread.currentThread().setContextClassLoader(Compiler.getClassLoader(application));
        FusionContext context = new FusionContext();
        context.application = application;
        FusionContext.setCurrent(context);
        NeoTranslator translator = new NeoTranslator(application);
        long batchStart = System.currentTimeMillis();
        int totalFiles = 0;
        int successFiles = 0;
        if (deploy) {
            if (cf_root != null) {
                RuntimeServiceImpl rtm = new RuntimeServiceImpl(new File(cf_root + File.separatorChar + "lib/neo-runtime.xml"), cf_root, true);
                try {
                    rtm.start();
                }
                catch (ServiceException ex) {
                    Compiler.exit(1, ex.getMessage());
                }
                ServiceFactory.setRuntimeService(rtm);
            }
            try {
                successFiles = totalFiles = Compiler.compileForSourcelessDeploy(srcDir, deployDir, ".cfm,.cfc,.cfr", true, translator, null, "");
            }
            catch (SourcelessDeployErrorsException ex) {
                errors = ex.getErrors();
                totalFiles = ex.getTotalFiles();
                successFiles = totalFiles - errors.size();
            }
            catch (LicenseManager.LicenseIllegalAccessException licEx) {
                Compiler.exit(1, licEx.getMessage() + ":  " + licEx.getDetail());
            }
        } else {
            if (templateCanonicalFiles.size() == 0) {
                Compiler.exit(1, "error: no source files given");
            }
            int successCount = 0;
            for (File canonicalFile : templateCanonicalFiles) {
                try {
                    Map classes;
                    if (templateCanonicalFiles.size() > 0) {
                        System.out.print(canonicalFile + "... ");
                    }
                    if ((classes = translator.translateJava(canonicalFile.getPath(), force)) != null) {
                        if (force) {
                            translator.saveClasses(classes);
                        }
                        Compiler.verify(canonicalFile, classes);
                    }
                    ++successCount;
                }
                catch (ParseException ex) {
                    Throwable t = Compiler.unwrap(ex);
                    if (t instanceof CFMLCompileError) {
                        Collection exceptions = ((CFMLCompileError)t).getValidationResult();
                        Iterator it = exceptions.iterator();
                        while (it.hasNext()) {
                            errors.add(new CompileError(canonicalFile, (Throwable)it.next()));
                        }
                    } else {
                        errors.add(new CompileError(canonicalFile, t));
                    }
                    System.out.println();
                    t.printStackTrace();
                }
                catch (Throwable ex) {
                    errors.add(new CompileError(canonicalFile, ex));
                    System.out.println();
                    ex.printStackTrace();
                }
            }
            if (templateCanonicalFiles.size() > 0) {
                successFiles = successCount;
                totalFiles = templateCanonicalFiles.size();
            }
        }
        if (totalFiles > 0) {
            System.out.println("successful " + successFiles);
            System.out.println("total " + totalFiles);
        }
        double elapsed = System.currentTimeMillis() - batchStart;
        System.out.println("elapsed " + elapsed / 1000.0 + " sec");
        if (errors.size() > 0) {
            System.err.println();
            System.err.println("Errors found: " + errors.size());
            for (int i = 0; i < errors.size(); ++i) {
                CompileError e = (CompileError)errors.get(i);
                System.err.println("Error " + (i + 1) + ": " + e.templateFile);
                if (e.ex instanceof CFMLValidationException) {
                    System.out.println("Location: " + ((CFMLValidationException)e.ex).location);
                }
                System.err.println(e.ex.getMessage());
                System.err.println();
            }
            Compiler.exit(1, "Errors found in " + errors.size() + " of " + totalFiles + " templates");
        } else {
            Compiler.exit(0, "");
        }
    }

    public static int compileForSourcelessDeploy(String srcDir, String outDir, String extensions, boolean copyNonCompileFiles, Writer out, String excludes) throws IOException {
        NeoTranslator translator = new NeoTranslator(FusionContext.getCurrent().application);
        return Compiler.compileForSourcelessDeploy(srcDir, outDir, extensions, copyNonCompileFiles, translator, out, excludes);
    }

    private static int compileForSourcelessDeploy(String srcDir, String outDir, String extensions, boolean copyNonCompileFiles, NeoTranslator translator, Writer writer, String excludes) throws IOException {
        if (writer == null) {
            writer = new OutputStreamWriter(System.out);
        }
        PrintWriter pw = new PrintWriter(writer);
        File srcDirFile = new File(srcDir);
        File outDirFile = new File(outDir);
        if (!srcDirFile.exists()) {
            throw new SourceDirectoryNonExistantException(srcDir);
        }
        if (srcDirFile.equals(outDirFile)) {
            throw new InvalidOutputDirectoryException(srcDir, outDir);
        }
        ArrayList<File> templateCanonicalFiles = new ArrayList<File>();
        ArrayList<File> filesToCopy = new ArrayList<File>();
        ArrayList<CompileError> errors = null;
        if (errors == null) {
            errors = new ArrayList<CompileError>();
        }
        Array extens = ListFunc.ListToArray(extensions, ",");
        File[] xclds = null;
        if (excludes != null && !excludes.trim().equals("")) {
            Array xcld = ListFunc.ListToArray(excludes, ",");
            Object srcDirPath = srcDirFile.getCanonicalPath();
            if (!((String)srcDirPath).endsWith(File.separator)) {
                srcDirPath = (String)srcDirPath + File.separator;
            }
            xclds = new File[xcld.size()];
            for (int i = 0; i < xcld.size(); ++i) {
                String curExcld = (String)xcld.get(i);
                File curFile = new File(curExcld.trim());
                xclds[i] = curFile.isAbsolute() ? curFile : new File((String)srcDirPath + curExcld.trim());
            }
        }
        if (srcDirFile.isDirectory()) {
            Compiler.addFiles(templateCanonicalFiles, filesToCopy, srcDirFile, extens, xclds);
        } else if (excludes == null || excludes.trim().equals("") || !Compiler.isExcluded(srcDirFile, xclds)) {
            String lower = srcDirFile.getName().toLowerCase();
            boolean compileTemplate = false;
            for (int q = 0; q < extens.size(); ++q) {
                if (!lower.endsWith((String)extens.get(q))) continue;
                compileTemplate = true;
                break;
            }
            if (compileTemplate) {
                templateCanonicalFiles.add(srcDirFile.getCanonicalFile());
            } else {
                filesToCopy.add(srcDirFile.getCanonicalFile());
            }
        }
        translator.setSaveClasses(false);
        String srcPath = new File(srcDir).getPath();
        for (File canonicalFile : templateCanonicalFiles) {
            try {
                File outputFile;
                File parentFile;
                Map classes;
                if (templateCanonicalFiles.size() > 0) {
                    pw.println(canonicalFile + "... ");
                }
                if ((classes = translator.translateJava(canonicalFile.getPath(), true)) == null) continue;
                String filePathName = canonicalFile.getPath();
                String fileName = canonicalFile.getName();
                if (filePathName.startsWith(srcPath)) {
                    fileName = filePathName.substring(srcDir.length(), filePathName.length());
                }
                if (!(parentFile = (outputFile = new File(outDir + File.separatorChar + fileName)).getParentFile()).exists()) {
                    parentFile.mkdirs();
                }
                if (classes.containsKey("MainClassName")) {
                    classes.remove("MainClassName");
                }
                if (classes.size() > 0) {
                    translator.saveClasses(classes, outputFile);
                }
                Compiler.verify(canonicalFile, classes);
            }
            catch (ParseException ex) {
                Throwable t = Compiler.unwrap(ex);
                if (t instanceof CFMLCompileError) {
                    Collection exceptions = ((CFMLCompileError)t).getValidationResult();
                    Iterator it = exceptions.iterator();
                    while (it.hasNext()) {
                        CompileError compileError = new CompileError(canonicalFile, (Throwable)it.next());
                        compileError.setMessage(t.getMessage());
                        errors.add(compileError);
                    }
                } else {
                    CompileError compileError = new CompileError(canonicalFile, t);
                    compileError.setMessage(t.getMessage());
                    errors.add(compileError);
                }
                pw.println();
                t.printStackTrace();
            }
            catch (Throwable ex) {
                CompileError e = new CompileError(canonicalFile, ex);
                e.setMessage(ex.getMessage());
                errors.add(e);
                pw.println();
                ex.printStackTrace();
            }
        }
        if (copyNonCompileFiles) {
            for (File canonicalFile : filesToCopy) {
                File outputFile;
                File parentFile;
                String filePathName = canonicalFile.getPath();
                String fileName = canonicalFile.getName();
                if (filePathName.startsWith(srcPath)) {
                    fileName = filePathName.substring(srcDir.length(), filePathName.length());
                }
                if (!(parentFile = (outputFile = new File(outDir + File.separatorChar + fileName)).getParentFile()).exists()) {
                    parentFile.mkdirs();
                }
                FileInputStream fin = new FileInputStream(canonicalFile);
                IOUtils.saveFile(outputFile, fin);
            }
        }
        if (errors.size() > 0) {
            throw new SourcelessDeployErrorsException(errors, templateCanonicalFiles.size());
        }
        return templateCanonicalFiles.size();
    }

    private static void verify(File canonicalFile, Map classMap) {
        for (Map.Entry entry : classMap.entrySet()) {
            String className = (String)entry.getKey();
            if (className.indexOf(36) != -1 || className.equals("MainClassName")) continue;
            byte[] bytes = (byte[])entry.getValue();
            try {
                CodeSource cs = new CodeSource(canonicalFile.toURL(), (Certificate[])null);
                new TemplateClassLoader(classMap, cs, canonicalFile.getPath()).loadClass(className);
                break;
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
    }

    private static ClassLoader getClassLoader(ServletContext application) {
        int i;
        Vector<String> v = new Vector<String>();
        v.addElement(application.getRealPath("/WEB-INF/classes"));
        String webInfPath = application.getRealPath("/WEB-INF/lib");
        if (webInfPath != null) {
            String[] list = new File(webInfPath).list();
            for (i = 0; list != null && i < list.length; ++i) {
                if (!list[i].endsWith(".jar")) continue;
                v.addElement(application.getRealPath("/WEB-INF/lib/" + list[i]));
            }
        }
        URL[] urls = new URL[v.size()];
        for (i = 0; i < v.size(); ++i) {
            try {
                urls[i] = new File(v.elementAt(i).toString()).toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return new URLClassLoader(urls, Compiler.class.getClassLoader());
    }

    private static void addFiles(List templates, File dir, String webroot) throws IOException {
        File[] list = dir.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String lower = list[i].toString().toLowerCase();
                if (list[i].isDirectory()) {
                    Compiler.addFiles(templates, list[i], webroot);
                    continue;
                }
                if (!lower.endsWith(".cfm") && !lower.endsWith(".cfc") && !lower.endsWith(".cfr")) continue;
                templates.add(list[i]);
            }
        }
    }

    private static void addFiles(List templates, List copyFiles, File dir, Array extensions, File[] excludes) throws IOException {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (excludes != null && Compiler.isExcluded(list[i], excludes)) continue;
            if (list[i].isDirectory()) {
                Compiler.addFiles(templates, copyFiles, list[i], extensions, excludes);
                continue;
            }
            String lower = list[i].toString().toLowerCase();
            boolean compileTemplate = false;
            for (int q = 0; q < extensions.size(); ++q) {
                if (!lower.endsWith((String)extensions.get(q))) continue;
                compileTemplate = true;
                break;
            }
            if (compileTemplate) {
                templates.add(list[i]);
                continue;
            }
            copyFiles.add(list[i]);
        }
    }

    private static boolean isExcluded(File f, File[] excludes) {
        for (int i = 0; i < excludes.length; ++i) {
            if (!f.equals(excludes[i])) continue;
            return true;
        }
        return false;
    }

    private static void readInitParameters(CompilerContext application) {
        Utils.parseWebXml(application);
        Document webxml = (Document)application.getAttribute("coldfusion.web.xml");
        if (webxml != null) {
            NodeList nodes = webxml.getElementsByTagName("context-param");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("context-param")) continue;
                String name = null;
                String value = null;
                NodeList list = node.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node n;
                    node = list.item(j);
                    if (node.getNodeName().equals("param-name")) {
                        n = node.getFirstChild();
                        name = n != null ? n.getNodeValue().toString().trim() : null;
                        continue;
                    }
                    if (!node.getNodeName().equals("param-value")) continue;
                    n = node.getFirstChild();
                    value = n != null ? n.getNodeValue().toString().trim() : null;
                }
                if (name == null) continue;
                application.setInitParameter(name, value);
            }
        } else {
            application.setInitParameter("coldfusion.compiler.outputDir", "/WEB-INF/cfclasses");
        }
    }

    private static String findWebRoot() throws IOException {
        File cwd = new File(".").getCanonicalFile();
        do {
            if (!new File(cwd + File.separator + "WEB-INF" + File.separatorChar + "web.xml").exists()) continue;
            return cwd.getPath();
        } while ((cwd = cwd.getParentFile()) != null);
        return null;
    }

    private static void exit(int code, String message) {
        if (code != 0) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
        System.exit(code);
    }

    private static Throwable unwrap(Throwable ex) {
        if (ex instanceof AbstractParseException && ((AbstractParseException)ex).getRootCause() != null) {
            return Compiler.unwrap(((AbstractParseException)ex).getRootCause());
        }
        return ex;
    }

    public static String removeAndGetBuildPathIfAdminPage(String sourceFileName) {
        if (!stripBuildPathFromAdminPages) {
            return sourceFileName;
        }
        return AdminPagesSourceFileBuildPathRemover.getInstance().removeBuildPath(sourceFileName);
    }

    public static class SourcelessDeployErrorsException
    extends ApplicationException {
        private List errors;
        private int totalFiles = 0;

        SourcelessDeployErrorsException(List errors, int totalFiles) {
            this.errors = errors;
            this.totalFiles = totalFiles;
        }

        public List getErrors() {
            return this.errors;
        }

        public int getTotalFiles() {
            return this.totalFiles;
        }
    }

    public static class CompileError
    extends Exception {
        private File templateFile;
        private Throwable ex;
        private String msg;

        CompileError(File templateFile, Throwable ex) {
            this.templateFile = templateFile;
            this.ex = ex;
        }

        public String getTemplateFile() {
            return this.templateFile.getPath();
        }

        public Throwable getException() {
            return this.ex;
        }

        public void setMessage(String msg) {
            this.msg = msg;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }

    public static class SourceDirectoryNonExistantException
    extends ApplicationException {
        private String srcDir;

        SourceDirectoryNonExistantException(String dir) {
            this.srcDir = dir;
        }

        public String getSourceDir() {
            return this.srcDir;
        }
    }

    public static class InvalidOutputDirectoryException
    extends ApplicationException {
        private String srcDir;
        private String outDir;

        InvalidOutputDirectoryException(String dir, String outDir) {
            this.srcDir = dir;
            this.outDir = outDir;
        }

        public String getSourceDir() {
            return this.srcDir;
        }

        public String getOutputDir() {
            return this.outDir;
        }
    }

    static class AdminPagesSourceFileBuildPathRemover {
        private String[] paths;
        private static AdminPagesSourceFileBuildPathRemover adjuster;
        private static String webRootPath;

        public AdminPagesSourceFileBuildPathRemover() {
            FusionContext context = FusionContext.getCurrent();
            ServletContext servletContext = context.getServletContext();
            if (servletContext instanceof CompilerContext) {
                CompilerContext compilerContext = (CompilerContext)servletContext;
                webRootPath = compilerContext.getWebRoot();
                try {
                    webRootPath = new File(webRootPath).getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (webRootPath != null) {
                    if (!webRootPath.endsWith(File.separator)) {
                        webRootPath = webRootPath + File.separator;
                    }
                    String CFIDEPath = webRootPath + "CFIDE" + File.separator;
                    String webInfPath = webRootPath + "WEB-INF" + File.separator;
                    this.paths = new String[]{CFIDEPath, webInfPath};
                }
            }
        }

        static AdminPagesSourceFileBuildPathRemover getInstance() {
            if (adjuster == null) {
                adjuster = new AdminPagesSourceFileBuildPathRemover();
            }
            return adjuster;
        }

        String removeBuildPath(String sourceFileName) {
            try {
                sourceFileName = new File(sourceFileName).getCanonicalPath();
            }
            catch (IOException e) {
                return sourceFileName;
            }
            if (this.paths != null) {
                for (String adminPath : this.paths) {
                    if (!sourceFileName.startsWith(adminPath)) continue;
                    sourceFileName = sourceFileName.substring(webRootPath.length() - 1);
                    sourceFileName = sourceFileName.replace("\\", "/");
                    return sourceFileName;
                }
            }
            return sourceFileName;
        }
    }

    public static class InvalidFileException
    extends ApplicationException {
        private String canonicalFileName;
        private String filePathName;

        InvalidFileException(String canonicalFileName, String filePathName) {
            this.canonicalFileName = canonicalFileName;
            this.filePathName = filePathName;
        }

        public String getCanonicalFileName() {
            return this.canonicalFileName;
        }

        public String getFilePathName() {
            return this.filePathName;
        }
    }
}

