/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class IPUtils {
    static Method getIA;
    static Method getNI;
    static InetAddress ipv6LocalHost;
    static InetAddress ipv6UnboundAddress;
    private static final LocalIPSearchSettings localAddressSearchSettings;

    private static InetAddress getInetAddressIgnoreException(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static InetAddress[] getAllLocalIPs() {
        Vector InetAddrs = new Vector();
        try {
            if (getNI != null && getIA != null) {
                Object[] emptyObj = new Object[]{};
                Enumeration e = (Enumeration)getNI.invoke(null, emptyObj);
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    Enumeration enum2 = (Enumeration)getIA.invoke(o, emptyObj);
                    while (enum2.hasMoreElements()) {
                        InetAddrs.add(enum2.nextElement());
                    }
                }
                InetAddress[] ret = new InetAddress[InetAddrs.size()];
                for (int i = 0; i < InetAddrs.size(); ++i) {
                    ret[i] = (InetAddress)InetAddrs.get(i);
                }
                return ret;
            }
            InetAddress local = InetAddress.getLocalHost();
            String localHostName = local.getHostName();
            return InetAddress.getAllByName(localHostName);
        }
        catch (Exception e) {
            return new InetAddress[0];
        }
    }

    public static boolean isIPV6Address(String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        return (host = host.trim()).indexOf(":") != -1;
    }

    public static boolean isIPV6Localhost(String host) {
        if (IPUtils.isIPV6Address(host)) {
            try {
                if (ipv6LocalHost.equals(InetAddress.getByName(host))) {
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isIPV6UnboundedAddress(String host) {
        if (IPUtils.isIPV6Address(host)) {
            try {
                if (ipv6UnboundAddress.equals(InetAddress.getByName(host))) {
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLocalHost(String host) {
        if (host != null) {
            if ((host = host.trim().toLowerCase()).equalsIgnoreCase("localhost") || host.equals("127.0.0.1")) {
                return true;
            }
            if (IPUtils.isIPV6Localhost(host)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnboundedAddress(String host) {
        return "0.0.0.0".equals(host) || IPUtils.isIPV6UnboundedAddress(host);
    }

    public static String getValidLocalAddress() {
        return IPUtils.getValidLocalAddress(localAddressSearchSettings);
    }

    public static String getValidLocalAddress(LocalIPSearchSettings settings) {
        try {
            Enumeration<NetworkInterface> nwIfs = NetworkInterface.getNetworkInterfaces();
            while (nwIfs.hasMoreElements()) {
                NetworkInterface nwIf = nwIfs.nextElement();
                if (nwIf.isLoopback() && settings.noLoopback || !nwIf.isUp()) continue;
                Enumeration<InetAddress> inetAddrs = nwIf.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    int scopeIndex;
                    InetAddress inetAddr = inetAddrs.nextElement();
                    String ipAddress = inetAddr.getHostAddress();
                    if (inetAddr instanceof Inet6Address && (scopeIndex = ipAddress.indexOf("%")) != -1) {
                        ipAddress = ipAddress.substring(0, scopeIndex);
                    }
                    if (IPUtils.isUnboundedAddress(ipAddress) || inetAddr.isLoopbackAddress() && settings.noLoopback || inetAddr.isLinkLocalAddress() && settings.noLinkLocal || inetAddr.isMulticastAddress() && settings.noMulticast) continue;
                    if (inetAddr instanceof Inet6Address) {
                        String ipv6Address = settings.stripScopeId ? IPUtils.getScopeFreeInetAddress(inetAddr) : inetAddr.getHostAddress();
                        if (settings.appendBracesAround) {
                            return "[" + ipv6Address + "]";
                        }
                        return ipv6Address;
                    }
                    return inetAddr.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private static String getScopeFreeInetAddress(InetAddress address) {
        String ipv6Address = address.getHostAddress();
        int scopeIndex = ipv6Address.indexOf("%");
        if (scopeIndex != -1) {
            return ipv6Address.substring(0, scopeIndex);
        }
        return ipv6Address;
    }

    static {
        Class<?> niCls = null;
        try {
            niCls = Class.forName("java.net.NetworkInterface");
            getIA = niCls.getMethod("getInetAddresses", new Class[0]);
            getNI = niCls.getMethod("getNetworkInterfaces", new Class[0]);
        }
        catch (Exception e) {
            getNI = null;
            getIA = null;
        }
        ipv6LocalHost = IPUtils.getInetAddressIgnoreException("::1");
        ipv6UnboundAddress = IPUtils.getInetAddressIgnoreException("::");
        localAddressSearchSettings = new LocalIPSearchSettings();
    }

    static class LocalIPSearchSettings {
        boolean noLoopback = true;
        boolean noLinkLocal = true;
        boolean noMulticast = true;
        boolean stripScopeId = true;
        boolean appendBracesAround = true;

        LocalIPSearchSettings() {
        }
    }
}

