/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.tools.ResourceDocletConfiguration;
import coldfusion.tools.ResourceDocletProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class ResourceDoclet
implements Doclet {
    static ResourceDocletConfiguration configuration;
    private Reporter reporter;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
        configuration = new ResourceDocletConfiguration();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option outputDirOption = new Doclet.Option(){

            @Override
            public int getArgumentCount() {
                return 1;
            }

            @Override
            public String getDescription() {
                return "Specify the output directory";
            }

            @Override
            public Doclet.Option.Kind getKind() {
                return Doclet.Option.Kind.STANDARD;
            }

            @Override
            public List<String> getNames() {
                return Collections.singletonList("-d");
            }

            @Override
            public String getParameters() {
                return "outputdir";
            }

            @Override
            public boolean process(String option, List<String> arguments) {
                ResourceDoclet.configuration.outputdir = arguments.get(0);
                return true;
            }
        };
        Doclet.Option noDocsWarningOption = new Doclet.Option(){

            @Override
            public int getArgumentCount() {
                return 0;
            }

            @Override
            public String getDescription() {
                return "Enable warnings about exceptions that have not been documented";
            }

            @Override
            public Doclet.Option.Kind getKind() {
                return Doclet.Option.Kind.STANDARD;
            }

            @Override
            public List<String> getNames() {
                return Collections.singletonList("-nodocswarning");
            }

            @Override
            public String getParameters() {
                return null;
            }

            @Override
            public boolean process(String option, List<String> arguments) {
                ResourceDoclet.configuration.noDocsWarning = true;
                return true;
            }
        };
        return new HashSet<Doclet.Option>(Arrays.asList(outputDirOption, noDocsWarningOption));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.reporter.print(Diagnostic.Kind.NOTE, "Generating exception resources...");
        try {
            ResourceDocletProcessor processor = new ResourceDocletProcessor(ResourceDoclet.configuration());
            processor.process(environment, this.reporter);
        }
        catch (IOException ex) {
            this.reporter.print(Diagnostic.Kind.ERROR, ex.toString());
            this.reporter.print(Diagnostic.Kind.NOTE, "Resources not created; I/O errors occurred.");
            return false;
        }
        catch (Exception e) {
            this.reporter.print(Diagnostic.Kind.ERROR, e.toString());
            this.reporter.print(Diagnostic.Kind.NOTE, "Tag library descriptor not created; errors occurred.");
            return false;
        }
        this.reporter.print(Diagnostic.Kind.NOTE, "Resources created.");
        return true;
    }

    public static int optionLength(String option) {
        return ResourceDoclet.configuration().optionLength(option);
    }

    public static boolean validOptions(String[][] options, Reporter reporter) {
        return ResourceDoclet.configuration().validOptions(options, reporter);
    }

    static ResourceDocletConfiguration configuration() {
        if (configuration == null) {
            configuration = new ResourceDocletConfiguration();
        }
        return configuration;
    }
}

