/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.tools.ResourceDoclet;
import coldfusion.tools.ResourceDocletConfiguration;
import coldfusion.util.FastHashtable;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.DocTrees;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

class ResourceDocletProcessor {
    private ResourceDocletConfiguration configuration;
    private List undocWarnings;
    private DocletEnvironment environment;
    private Reporter reporter;
    private DocTrees treeUtils;

    public ResourceDocletProcessor(ResourceDocletConfiguration configuration) {
        this.configuration = configuration;
        this.undocWarnings = new ArrayList();
    }

    public void process(DocletEnvironment environment, Reporter reporter) throws IOException {
        this.reporter = reporter;
        this.environment = environment;
        this.treeUtils = environment.getDocTrees();
        for (Element element : environment.getIncludedElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            if (!environment.getTypeUtils().isAssignable(typeElement.asType(), environment.getElementUtils().getTypeElement(Exception.class.getName()).asType()) && !environment.getTypeUtils().isAssignable(typeElement.asType(), environment.getElementUtils().getTypeElement(Error.class.getName()).asType()) || this.dumpException(typeElement)) continue;
            this.undocWarnings.add("Class " + typeElement.getQualifiedName() + " appears to be an undocumented exception");
        }
        if (this.configuration.getNoDocsWarning()) {
            for (String string : this.undocWarnings) {
                reporter.print(Diagnostic.Kind.WARNING, string);
            }
        } else if (this.undocWarnings.size() != 0) {
            reporter.print(Diagnostic.Kind.WARNING, "Some exceptions are not documented. Rerun using -nodocswarning for further details.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean dumpException(TypeElement typeElement) throws IOException {
        String MESSAGE = "message";
        String DETAIL = "detail";
        DocCommentTree commentTree = this.treeUtils.getDocCommentTree(typeElement);
        if (commentTree == null) {
            return false;
        }
        List<? extends DocTree> tags = commentTree.getBlockTags();
        ArrayList<BlockTagTree> messageTags = new ArrayList<BlockTagTree>();
        for (DocTree docTree : tags) {
            BlockTagTree blockTag;
            if (!(docTree instanceof BlockTagTree) || !(blockTag = (BlockTagTree)docTree).getTagName().equals("message")) continue;
            messageTags.add(blockTag);
        }
        boolean isTaggedFormat = messageTags.size() > 0;
        String string = "";
        List<? extends DocTree> fullBody = commentTree.getFullBody();
        StringBuilder sb = new StringBuilder();
        for (DocTree docTree : fullBody) {
            sb.append(docTree.toString());
        }
        String string2 = sb.toString();
        if (string2.trim().length() == 0 && !isTaggedFormat) {
            return false;
        }
        Object filename = typeElement.getQualifiedName().toString();
        String string3 = this.getFileName(typeElement);
        filename = ((String)filename).substring(0, ((String)filename).length() - string3.length());
        filename = this.configuration.getOutputdir() + "/" + ((String)filename).replace('.', '/') + string3 + ".properties";
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter((String)filename)));){
            out.println("# Do not edit.  " + ResourceDoclet.class.getName() + " generated this ");
            out.println("# from class comments in " + string3 + ".java");
            out.println();
            if (isTaggedFormat) {
                boolean foundDetail = false;
                for (DocTree docTree : tags) {
                    Object tagContent;
                    StringBuilder tagContentBuilder;
                    String suffix;
                    if (docTree.getKind() != DocTree.Kind.UNKNOWN_BLOCK_TAG || !(docTree instanceof UnknownBlockTagTree)) continue;
                    UnknownBlockTagTree blockTagTree = (UnknownBlockTagTree)docTree;
                    String tagName = blockTagTree.getTagName();
                    if (tagName.length() >= "message".length() && tagName.substring(0, "message".length()).equals("message")) {
                        suffix = tagName.length() > "message".length() ? tagName.substring("message".length()) : "";
                        out.print("message" + suffix + "=");
                        tagContentBuilder = new StringBuilder();
                        for (DocTree docTree2 : blockTagTree.getContent()) {
                            tagContentBuilder.append(docTree2.toString());
                        }
                        tagContent = tagContentBuilder.toString();
                        this.checkVars(typeElement, (String)tagContent);
                        this.formatProperty((String)tagContent, out);
                        out.println();
                        out.println();
                        continue;
                    }
                    if (tagName.length() < "detail".length() || !tagName.substring(0, "detail".length()).equals("detail")) continue;
                    suffix = tagName.length() > "detail".length() ? tagName.substring("detail".length()) : "";
                    out.print("detail" + suffix + "=");
                    tagContentBuilder = new StringBuilder();
                    for (DocTree docTree3 : blockTagTree.getContent()) {
                        tagContentBuilder.append(docTree3.toString());
                    }
                    tagContent = tagContentBuilder.toString();
                    this.checkVars(typeElement, (String)tagContent);
                    this.formatProperty((String)tagContent, out);
                    out.println();
                    out.println();
                    if (!tagName.equals("detail")) continue;
                    foundDetail = true;
                }
                if (!foundDetail) {
                    out.println("detail=");
                }
            } else {
                void var16_25;
                char beforeDotChar;
                String inlineText = string2;
                Object message = null;
                int messageEnd = inlineText.indexOf(".");
                if (messageEnd > 0 && (beforeDotChar = inlineText.charAt(messageEnd - 1)) == '\\') {
                    int beforeDotCharIndex = messageEnd - 1;
                    messageEnd = inlineText.indexOf(".", messageEnd + 1);
                    message = inlineText.substring(0, beforeDotCharIndex).trim();
                    if (inlineText.length() > beforeDotCharIndex + 2) {
                        message = messageEnd != -1 ? (String)message + inlineText.substring(beforeDotCharIndex + 1, messageEnd).trim() : (String)message + inlineText.substring(beforeDotCharIndex + 1);
                    }
                }
                if (message == null) {
                    message = messageEnd != -1 ? inlineText.substring(0, messageEnd + 1).trim() : inlineText;
                }
                if (messageEnd != -1 && inlineText.length() > messageEnd + 1) {
                    String string4 = inlineText.substring(messageEnd + 1).trim();
                } else {
                    String string5 = "";
                }
                out.print("message=");
                this.checkVars(typeElement, (String)message);
                this.formatProperty((String)message, out);
                out.println();
                out.println();
                out.print("detail=");
                this.checkVars(typeElement, (String)var16_25);
                this.formatProperty((String)var16_25, out);
                out.println();
            }
        }
        return true;
    }

    private void formatProperty(String text, PrintWriter out) {
        boolean linebreak = false;
        block5: for (int j = 0; j < text.length(); ++j) {
            char c = text.charAt(j);
            switch (c) {
                case '\r': {
                    continue block5;
                }
                case '\n': {
                    linebreak = true;
                    continue block5;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    out.print(c);
                    continue block5;
                }
                default: {
                    if (linebreak) {
                        out.println('\\');
                        linebreak = false;
                    }
                    out.print(c);
                }
            }
        }
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (value.length() == 0) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    private void checkVars(TypeElement typeElement, String text) {
        int j;
        int i = 0;
        int len = text.length();
        FastHashtable props = new FastHashtable();
        ArrayList fields = new ArrayList();
        ArrayList methods = new ArrayList();
        TypeElement currentElement = typeElement;
        while (currentElement != null) {
            fields.addAll(currentElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.FIELD).map(element -> (VariableElement)element).collect(Collectors.toList()));
            methods.addAll(currentElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(element -> (ExecutableElement)element).collect(Collectors.toList()));
            TypeMirror superclassMirror = currentElement.getSuperclass();
            Object basedoc = null;
            if (superclassMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)superclassMirror;
                currentElement = (TypeElement)declaredType.asElement();
                continue;
            }
            currentElement = null;
        }
        while ((j = text.indexOf(123, i)) != -1) {
            i = text.indexOf(125, j);
            if (i == -1) {
                this.reporter.print(Diagnostic.Kind.ERROR, "Class" + typeElement.getQualifiedName() + " contains an unterminated property name: " + text.substring(j));
                break;
            }
            String name = text.substring(j + 1, i);
            boolean found = false;
            boolean nonpublic = false;
            for (int f = 0; !found && f < fields.size(); ++f) {
                VariableElement fd = (VariableElement)fields.get(f);
                if (!fd.getSimpleName().toString().equalsIgnoreCase(name)) continue;
                if (!fd.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    nonpublic = true;
                    break;
                }
                found = true;
                props.put(name, fd);
                break;
            }
            boolean signature = false;
            for (int m = 0; !found && m < methods.size(); ++m) {
                ExecutableElement md = (ExecutableElement)methods.get(m);
                if (!md.getSimpleName().toString().equalsIgnoreCase("get" + name)) continue;
                signature = true;
                if (md.getParameters().size() != 0) continue;
                if (md.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    found = true;
                    props.put(name, md);
                    break;
                }
                nonpublic = true;
                break;
            }
            if (!found) {
                if (signature) {
                    if (nonpublic) {
                        this.reporter.print(Diagnostic.Kind.ERROR, "Class" + typeElement.getQualifiedName() + " has a non-public " + name + " get method");
                        break;
                    }
                    this.reporter.print(Diagnostic.Kind.ERROR, "Class" + typeElement.getQualifiedName() + " needs a public get" + name + "() method.");
                    break;
                }
                if (nonpublic) {
                    this.reporter.print(Diagnostic.Kind.ERROR, "Class" + typeElement.getQualifiedName() + " has a non-public " + name + " field, and no public get" + name + "() method");
                    break;
                }
                this.reporter.print(Diagnostic.Kind.ERROR, "Class" + typeElement.getQualifiedName() + " references an unknown property: " + name);
                break;
            }
            if (++i < len) continue;
        }
    }

    private String getFileName(TypeElement typeElement) {
        Object filename = typeElement.getSimpleName().toString();
        Element parent = typeElement.getEnclosingElement();
        String kind = parent.getKind().toString();
        while (kind.equals("CLASS") || kind.equals("INTERFACE") || kind.equals("ENUM")) {
            filename = parent.getSimpleName().toString() + "." + (String)filename;
            parent = parent.getEnclosingElement();
            kind = parent.getKind().toString();
        }
        return filename;
    }
}

