/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.compiler.ConflictingEncodingSpecificationException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;

public class BOMReader
extends Reader {
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final String UTF8_CANONICAL_ENCODING = "UTF8";
    public static final String UTF16LE_CANONICAL_ENCODING = "UnicodeLittleUnmarked";
    public static final String UTF16BE_CANONICAL_ENCODING = "UnicodeBigUnmarked";
    protected BufferedInputStream in;
    protected InputStreamReader reader;
    protected boolean explicitEncodingSet = false;

    protected BOMReader() {
    }

    public BOMReader(BufferedInputStream in) throws IOException {
        this(in, null, true);
    }

    public BOMReader(BufferedInputStream in, String encoding) throws IOException {
        this(in, encoding, true);
    }

    public BOMReader(BufferedInputStream in, String encoding, boolean bomOverride) throws ConflictingEncodingSpecificationException, IOException {
        String bomEncoding = this.getBOMEncoding(in);
        if (bomEncoding != null) {
            if (!bomOverride && encoding != null && !BOMReader.isEncodingMatch(encoding, bomEncoding)) {
                throw new ConflictingEncodingSpecificationException(encoding, bomEncoding);
            }
            encoding = bomEncoding;
            this.explicitEncodingSet = true;
        }
        this.reader = encoding != null ? new InputStreamReader((InputStream)in, encoding) : new InputStreamReader(in);
        this.in = in;
    }

    public static boolean isEncodingMatch(String enc1, String enc2) throws UnsupportedEncodingException {
        if (BOMReader.getCanonicalEncoding(enc1).equals(enc2)) {
            return true;
        }
        return !(!enc1.equalsIgnoreCase("utf16") && !enc1.equalsIgnoreCase("utf-16") || !enc2.equalsIgnoreCase(UTF16LE_CANONICAL_ENCODING) && !enc2.equalsIgnoreCase(UTF16BE_CANONICAL_ENCODING));
    }

    protected boolean startsWith(InputStream in, byte[] b) throws IOException {
        int count = b.length;
        if (in.available() >= count) {
            in.mark(count);
            for (int i = 0; i < count; ++i) {
                if (in.read() == (b[i] & 0xFF)) continue;
                in.reset();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean explicitEncodingSet() {
        return this.explicitEncodingSet;
    }

    protected String getBOMEncoding(InputStream in) throws IOException {
        if (this.startsWith(in, UTF8_BOM)) {
            return UTF8_CANONICAL_ENCODING;
        }
        if (this.startsWith(in, UTF16LE_BOM)) {
            return UTF16LE_CANONICAL_ENCODING;
        }
        if (this.startsWith(in, UTF16BE_BOM)) {
            return UTF16BE_CANONICAL_ENCODING;
        }
        return null;
    }

    public static String getCanonicalEncoding(String encoding) throws UnsupportedEncodingException {
        String fixedEncoding = encoding.toUpperCase().startsWith("UTF") ? encoding.toUpperCase() : encoding.toString();
        return new InputStreamReader((InputStream)new StringBufferInputStream(""), fixedEncoding).getEncoding();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    public String getEncoding() {
        return this.reader.getEncoding();
    }
}

