/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.LogService;
import coldfusion.log.Logger;
import coldfusion.server.ServiceFactory;
import java.util.ArrayList;
import java.util.List;

public class CFPerformanceLogger {
    public static PerfStat _CFJSPPage_arraySet = new PerfStat("CfjspPage._arraySet");
    public static PerfStat _CFJSPPage_arrayGet = new PerfStat("CfjspPage._arrayGet");
    public static StringBuffer log = new StringBuffer();
    public static List<PerfStat> stats = new ArrayList<PerfStat>();
    public static boolean captureStats = true;

    public static void writeStats(String logFileName) {
        LogService logService = (LogService)ServiceFactory.getLoggingService();
        Logger log = logService.getUserLog(logFileName);
        log.applog("information", "performance_stats", "----------------------------start-----------------------------------------");
        for (int i = 0; i < stats.size(); ++i) {
            PerfStat p = stats.get(i);
            long avg = p.overallTime / (long)p.counter;
            log.applog("information", "performance_stats", p.codeBlockLabel + " - avg - " + avg + " total - " + p.overallTime + " counter - " + p.counter);
        }
        log.applog("information", "performance_stats", "----------------------------end-----------------------------------------");
    }

    public static void clear() {
        for (PerfStat p : stats) {
            p.overallTime = 0L;
            p.counter = 0;
        }
    }

    static {
        stats.add(_CFJSPPage_arraySet);
        stats.add(_CFJSPPage_arrayGet);
    }

    public static class PerfStat {
        private String codeBlockLabel;
        public int counter = 0;
        public long overallTime = 0L;

        public PerfStat(String label) {
            this.codeBlockLabel = label;
        }

        public void log(long executionTime) {
            if (captureStats) {
                this.overallTime += executionTime;
                ++this.counter;
            }
        }
    }
}

