/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.CloneableMap;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.util.CaseKey;
import coldfusion.util.IteratorEnumeration;
import coldfusion.util.Key;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class CaseInsensitiveMap
implements CloneableMap,
Serializable {
    protected MemoryTrackerProxy mtProxy;
    protected Map<Key, Object> map;
    private Set scopeSet;
    private Set keySet;
    private static final Object NULL_PILL = new Object();

    public CaseInsensitiveMap() {
        this.map = new HashMap<Key, Object>();
    }

    public CaseInsensitiveMap(int capacity) {
        this.map = new HashMap<Key, Object>(capacity);
    }

    public CaseInsensitiveMap(boolean concurrent, int capacity) {
        this.map = concurrent ? new CFConcurrentHashMap(capacity) : new HashMap(capacity);
    }

    public CaseInsensitiveMap(boolean concurrent) {
        this.map = concurrent ? new CFConcurrentHashMap() : new HashMap();
    }

    public Object get(Object key) {
        if (key != null) {
            if (key instanceof String) {
                return this.map.get(Key.getInstance((String)key));
            }
            return this.map.get(Key.getInstance(key.toString()));
        }
        return null;
    }

    public Object get(Key key) {
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            key = "null";
        } else if (key instanceof Key) {
            return this.put((Key)key, value);
        }
        return this.put(Key.getInstance(key.toString()), value);
    }

    public Object put(Key key, Object value) {
        Object oldVal = this.map.put(key, value);
        if (this.mtProxy != null) {
            this.mtProxy.onPut(key.getKeyString(), value, oldVal, oldVal != null);
        }
        return oldVal;
    }

    public Object remove(Object key) {
        return this.remove(Key.getInstance(key.toString()));
    }

    public Object remove(Key key) {
        Object old = this.map.remove(key);
        if (this.mtProxy != null) {
            this.mtProxy.onRemove(key.getKeyString(), old, old != null);
        }
        return old;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            if (key instanceof Key) {
                return this._containsKey((Key)key);
            }
            return this._containsKey(Key.getInstance(key.toString()));
        }
        return false;
    }

    public boolean _containsKey(Key key) {
        return this.map.containsKey(key);
    }

    public boolean contains(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public void clear() {
        this.map.clear();
        if (this.mtProxy != null) {
            this.mtProxy.resetMemory();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Enumeration keys() {
        return new FastHashKeyEnumerator(this.map);
    }

    public Enumeration elements() {
        return new IteratorEnumeration(this.map.values().iterator());
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('{');
        for (Map.Entry<Key, Object> entry : this.map.entrySet()) {
            if (out.length() > 1) {
                out.append(',');
            }
            out.append(entry.getKey().getKeyString());
            out.append("={");
            out.append(String.valueOf(entry.getValue()));
            out.append('}');
        }
        out.append('}');
        return out.toString();
    }

    public Set entrySet() {
        if (null == this.scopeSet) {
            this.scopeSet = new ScopeSet();
        }
        return this.scopeSet;
    }

    public Set caseHandledEntrySet() {
        return new ScopeCaseHandledSet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set caseHandledKeySet() {
        return new CaseHandledKeySet();
    }

    public void putAll(Map t) {
        for (Object key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    @Override
    public Map duplicate() throws IllegalAccessException {
        return this.duplicate(null);
    }

    public Map duplicate(IdentityHashMap refCache) throws IllegalAccessException {
        CaseInsensitiveMap result = new CaseInsensitiveMap(this.size());
        if (null == refCache) {
            refCache = new IdentityHashMap<CaseInsensitiveMap, CaseInsensitiveMap>();
        }
        refCache.put(this, result);
        for (Map.Entry<Key, Object> entry : this.map.entrySet()) {
            result.put(entry.getKey(), ObjectDuplicator.duplicate(entry.getValue(), refCache));
        }
        return result;
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.map.containsValue(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CaseInsensitiveMap clonedMap = (CaseInsensitiveMap)super.clone();
        if (clonedMap.map instanceof HashMap) {
            clonedMap.map = (Map)((HashMap)clonedMap.map).clone();
        } else if (clonedMap.map instanceof TreeMap) {
            clonedMap.map = (Map)((TreeMap)clonedMap.map).clone();
        }
        clonedMap.keySet = null;
        return clonedMap;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                Object otherVal = t.get(key);
                if (value == null) {
                    if (otherVal == null && t.containsKey(key)) continue;
                    return false;
                }
                if (otherVal == null) {
                    return false;
                }
                if (!(value instanceof String && otherVal instanceof String ? !value.toString().equalsIgnoreCase(otherVal.toString()) : !value.equals(otherVal))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public static class CFConcurrentHashMap
    extends ConcurrentHashMap {
        public CFConcurrentHashMap() {
        }

        public CFConcurrentHashMap(int capacity) {
            super(capacity);
        }

        public CFConcurrentHashMap(Map settings) {
            if (settings != null) {
                settings.forEach(this::put);
            }
        }

        @Override
        public Object put(Object key, Object value) {
            return super.put(key, null != value ? value : NULL_PILL);
        }

        @Override
        public Object get(Object key) {
            Object temp = super.get(key);
            if (NULL_PILL == temp) {
                return null;
            }
            return temp;
        }

        @Override
        public boolean containsKey(Object key) {
            return super.get(key) != null;
        }

        @Override
        public boolean contains(Object value) {
            return super.containsValue(null != value ? value : NULL_PILL);
        }

        @Override
        public Collection values() {
            return new NullValuesCollectionDelegate(super.values());
        }
    }

    static class FastHashKeyEnumerator
    implements Enumeration,
    Iterator {
        private int index = 0;
        private Key[] keys;
        private Map map;

        public FastHashKeyEnumerator(Map<Key, Object> map) {
            this.map = map;
            this.keys = map.keySet().toArray(new Key[map.size()]);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        protected Key _next() {
            if (this.index < this.keys.length) {
                return this.keys[this.index++];
            }
            throw new NoSuchElementException();
        }

        public Object next() {
            return this._next().getKeyString();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.length;
        }

        @Override
        public void remove() {
            if (this.index == 0 || this.index > this.keys.length) {
                throw new IllegalStateException();
            }
            this.map.remove(this.keys[this.index - 1]);
        }
    }

    private class ScopeSet
    extends AbstractSet {
        private ScopeSet() {
        }

        @Override
        public Iterator iterator() {
            return new ScopeIterator(CaseInsensitiveMap.this.map);
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.size();
        }

        @Override
        public void clear() {
            CaseInsensitiveMap.this.clear();
        }
    }

    private class ScopeCaseHandledSet
    extends ScopeSet {
        private ScopeCaseHandledSet() {
        }

        @Override
        public Iterator iterator() {
            return new ScopeIterator(CaseInsensitiveMap.this.map, true);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new FastHashKeyEnumerator(CaseInsensitiveMap.this.map);
        }

        @Override
        public int size() {
            return CaseInsensitiveMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return CaseInsensitiveMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CaseInsensitiveMap.this.remove(o) != null;
        }
    }

    private class CaseHandledKeySet
    extends KeySet {
        private CaseHandledKeySet() {
        }

        @Override
        public Iterator iterator() {
            return new FastHashCaseHandledKeyEnumerator(CaseInsensitiveMap.this.map);
        }
    }

    static class NullSafeIteratorDelegate
    implements Iterator {
        private Iterator it;

        public NullSafeIteratorDelegate(Iterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            Object next = this.it.next();
            if (NULL_PILL == next) {
                return null;
            }
            return next;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    static class NullValuesCollectionDelegate
    implements Collection {
        private Collection values;

        public NullValuesCollectionDelegate(Collection values) {
            this.values = values;
        }

        public boolean add(Object arg0) {
            return this.values.add(arg0);
        }

        public boolean addAll(Collection arg0) {
            return this.values.addAll(arg0);
        }

        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.values.contains(null != value ? value : NULL_PILL);
        }

        public boolean containsAll(Collection arg0) {
            return this.values.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new NullSafeIteratorDelegate(this.values.iterator());
        }

        @Override
        public boolean remove(Object value) {
            return this.values.remove(null != value ? value : NULL_PILL);
        }

        public boolean removeAll(Collection arg0) {
            return this.values.removeAll(arg0);
        }

        public boolean retainAll(Collection arg0) {
            return this.values.retainAll(this.values);
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Object[] toArray() {
            return this.values.toArray();
        }

        public Object[] toArray(Object[] arg0) {
            return this.values.toArray(arg0);
        }
    }

    static class FastHashCaseHandledKeyEnumerator
    extends FastHashKeyEnumerator {
        public FastHashCaseHandledKeyEnumerator(Map<Key, Object> map) {
            super(map);
        }

        @Override
        public Object next() {
            Key key = this._next();
            if (key instanceof CaseKey) {
                return ((CaseKey)key).getValue();
            }
            return key.getKeyString();
        }
    }

    static class ScopeIterator
    implements Iterator {
        private Map<Key, Object> map;
        private int index;
        private Key[] keys;
        private boolean handlePreserveCase;

        ScopeIterator(Map<Key, Object> map) {
            this.map = map;
            this.keys = map.keySet().toArray(new Key[map.size()]);
        }

        ScopeIterator(Map<Key, Object> map, boolean handlePreserveCase) {
            this(map);
            this.handlePreserveCase = handlePreserveCase;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.length;
        }

        public Object next() {
            if (this.hasNext()) {
                Key key = this.keys[this.index++];
                return this.handlePreserveCase ? new ScopeCaseHandledEntry(key, this.map.get(key)) : new ScopeEntry(key, this.map.get(key));
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index == 0 || this.index > this.keys.length) {
                throw new IllegalStateException();
            }
            this.map.remove(this.keys[this.index - 1]);
        }

        private class ScopeCaseHandledEntry
        extends ScopeEntry {
            ScopeCaseHandledEntry(Key key, Object value) {
                super(key, value);
            }

            @Override
            public Object getKey() {
                if (this.key instanceof CaseKey) {
                    return ((CaseKey)this.key).getValue();
                }
                return this.key.getKeyString();
            }
        }

        private class ScopeEntry
        implements Map.Entry {
            protected Key key;
            private Object value;

            ScopeEntry(Key key, Object value) {
                this.key = key;
                this.value = value;
            }

            public Object getValue() {
                return this.value;
            }

            public Object setValue(Object value) {
                return ScopeIterator.this.map.put(this.key, value);
            }

            public Object getKey() {
                return this.key.getKeyString();
            }

            public String toString() {
                return "{ " + this.key.getKeyString() + " = " + "{" + this.value.toString() + "}}";
            }

            @Override
            public boolean equals(Object o) {
                Object v2;
                Object v1;
                Object k2;
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object k1 = this.getKey();
                return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2) || k1 instanceof String && k2 instanceof String && k1.toString().equalsIgnoreCase(k2.toString())) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2) || v1 instanceof String && v2 instanceof String && v1.toString().equalsIgnoreCase(v2.toString()));
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ (null == this.value ? 0 : (this.value instanceof String ? this.value.toString().toLowerCase().hashCode() : this.value.hashCode()));
            }
        }
    }
}

