/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.osgi.services.FTPService;
import coldfusion.server.DotNetService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CFDumpable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DumpHelper {
    private static final Pattern consPattern = Pattern.compile("[^.]+$");
    private static Set dotNetMethods = new HashSet();
    private static Comparator methodCompare;
    private static Comparator fieldCompare;

    public static Object getMetaData(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CFDumpable) {
            return ((CFDumpable)obj).getMetadata();
        }
        FTPService ftpService = ServiceFactory.getFTPService();
        if (ftpService != null && ftpService.isSFTPInstance(obj)) {
            Object ftpMetaData = ftpService.getFtpMetaData(obj);
            return ftpMetaData;
        }
        return null;
    }

    public static String getLabel(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CFDumpable) {
            return ((CFDumpable)obj).getLabel();
        }
        FTPService ftpService = ServiceFactory.getFTPService();
        if (ftpService != null && ftpService.isSFTPInstance(obj)) {
            return "SFTPConnection";
        }
        return null;
    }

    public static Constructor[] getPublicConstructors(Class clazz) {
        return clazz != null ? clazz.getConstructors() : null;
    }

    public static Method[] getPublicClassMethods(Class clazz) {
        if (clazz == null) {
            return null;
        }
        DotNetService dotNetService = ServiceFactory.getDotNetService();
        boolean isDotNetClass = false;
        if (dotNetService != null) {
            isDotNetClass = dotNetService.isDotNetClass(clazz);
        }
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isVolatile(method.getModifiers()) || isDotNetClass && dotNetMethods.contains(DumpHelper.getMethodSignature(method))) continue;
            methodList.add(method);
        }
        Collections.sort(methodList, methodCompare);
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static String getMethodSignature(Method method) {
        StringJoiner methodArgs = new StringJoiner(", ", "(", ")");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            methodArgs.add(DumpHelper.getTypeName(parameterTypes[i]));
        }
        return method.getName() + methodArgs.toString();
    }

    public static String getConstructorSignature(Constructor<?> constructor) {
        Class<?>[] parameterTypes;
        String packageName = constructor.getName();
        Matcher matcher = consPattern.matcher(packageName);
        String constructorName = matcher.find() ? matcher.group() : "";
        StringJoiner consArgs = new StringJoiner(", ", "(", ")");
        for (Class<?> parameterType : parameterTypes = constructor.getParameterTypes()) {
            consArgs.add(DumpHelper.getTypeName(parameterType));
        }
        return constructorName + consArgs.toString();
    }

    public static String getMethodExceptionType(Method methodName) {
        Class<?>[] exceptionTypes = methodName.getExceptionTypes();
        StringJoiner exceptions = new StringJoiner(", ");
        for (Class<?> exceptionType : exceptionTypes) {
            exceptions.add(exceptionType.getName());
        }
        return exceptions.toString();
    }

    public static String getConsExceptionType(Constructor consName) {
        Class<?>[] exceptionTypes = consName.getExceptionTypes();
        StringJoiner exceptions = new StringJoiner(", ");
        for (Class<?> exceptionType : exceptionTypes) {
            exceptions.add(exceptionType.getName());
        }
        return exceptions.toString();
    }

    public static String getTypeName(Class type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Field[] getAllFields(Class clazz) {
        DotNetService dotNetService = ServiceFactory.getDotNetService();
        Field[] fields = clazz.getFields();
        boolean dotNetClass = false;
        if (dotNetService != null) {
            dotNetClass = dotNetService.isDotNetClass(clazz);
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> declaringClass;
            Field field = fields[i];
            if (dotNetClass && dotNetService.isProxyParent(declaringClass = field.getDeclaringClass())) continue;
            fieldList.add(field);
        }
        Collections.sort(fieldList, fieldCompare);
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    public static boolean isAssignableFrom(Class a, Class b) {
        return a.isAssignableFrom(b);
    }

    public static boolean isCFClass(String className) {
        return className.startsWith("coldfusion.") || className.startsWith("com.adobe.coldfusion");
    }

    public static Class getSuperClass(Class clazz) {
        DotNetService dotNetService = ServiceFactory.getDotNetService();
        boolean isDotNetClass = false;
        if (dotNetService != null) {
            isDotNetClass = dotNetService.isDotNetClass(clazz);
        }
        if (isDotNetClass && clazz.getName().equals("System.Object")) {
            return null;
        }
        Class parent = clazz.getSuperclass();
        if (parent == null || "java.lang.Object".equals(parent.getName())) {
            return null;
        }
        return parent;
    }

    public static String getSuperClassMethods(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        if (parent == Object.class) {
            Method[] methods = parent.getMethods();
            StringJoiner methodList = new StringJoiner(", ");
            for (Method method : methods) {
                methodList.add(method.getName());
            }
            return methodList.toString();
        }
        return null;
    }

    static {
        dotNetMethods.add("GetDotNetClass()");
        dotNetMethods.add("toString()");
        methodCompare = new MethodCompare();
        fieldCompare = new FieldCompare();
    }

    private static class MethodCompare
    implements Comparator {
        private MethodCompare() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Method)o1).getName();
            String name2 = ((Method)o2).getName();
            return name1.compareTo(name2);
        }
    }

    private static class FieldCompare
    implements Comparator {
        private FieldCompare() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Field)o1).getName();
            String name2 = ((Field)o2).getName();
            return name1.compareTo(name2);
        }
    }
}

