/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.server.ServiceFactory;
import coldfusion.util.WrappedException;
import jakarta.servlet.ServletException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.NamingException;
import org.xml.sax.SAXException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String getStackTraceAsString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Throwable t = th;
        th.printStackTrace(out);
        out.close();
        return sw.toString();
    }

    public static String getFullStackTraceAsString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Throwable t = th;
        ExceptionUtils.printExceptionStack(t, out, 0);
        out.close();
        return sw.toString();
    }

    public static void printFullStack(Throwable th, PrintWriter out) {
        ExceptionUtils.printExceptionStack(th, out, 0);
    }

    public static void printFullStack(Throwable th, OutputStream out) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        ExceptionUtils.printExceptionStack(th, pw, 0);
        pw.flush();
    }

    public static Throwable getOriginalCause(Throwable th) {
        Throwable rootBackup;
        Throwable root = th;
        do {
            rootBackup = root;
        } while ((root = ExceptionUtils.getRootCause(root)) != null);
        return rootBackup;
    }

    public static Throwable[] listExceptions(Throwable th) {
        Vector<Throwable> v = new Vector<Throwable>();
        while (true) {
            v.addElement(th);
            Throwable root = ExceptionUtils.getRootCause(th);
            if (root == null) break;
            th = root;
        }
        Throwable[] array = new Throwable[v.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Throwable)v.elementAt(array.length - 1 - i);
        }
        return array;
    }

    private static void printExceptionStack(Throwable th, PrintWriter out, int depth) {
        boolean printStackDepth = depth > 0;
        Throwable root = ExceptionUtils.getRootCause(th);
        if (root != null) {
            printStackDepth = true;
            ExceptionUtils.printExceptionStack(root, out, depth + 1);
        }
        if (printStackDepth) {
            out.write("[" + depth + "]");
        }
        th.printStackTrace(out);
    }

    private static Throwable getRootCause(Throwable th) {
        Throwable root = null;
        if (th instanceof ServletException) {
            root = ((ServletException)th).getRootCause();
        } else if (th instanceof RemoteException) {
            root = ((RemoteException)th).detail;
        } else if (th instanceof SAXException) {
            root = ((SAXException)th).getException();
        } else if (th instanceof WrappedException) {
            root = ((WrappedException)((Object)th)).getRootCause();
        } else if (th instanceof NamingException) {
            root = ((NamingException)th).getRootCause();
        } else if (ServiceFactory.getMailSpoolService() != null && ServiceFactory.getMailSpoolService().isMessagingException(th)) {
            root = ServiceFactory.getMailSpoolService().getNextMessagingException(th);
        }
        return root;
    }

    public static Throwable unwrapRemoteExceptions(Throwable th) {
        Throwable rootBackup;
        Throwable root = th;
        do {
            rootBackup = root;
            if (!(root instanceof RemoteException)) {
                return root;
            }
            root = ExceptionUtils.getRootCause(root);
        } while (root != null);
        return rootBackup;
    }
}

