/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.RuntimeWrapper;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ExtensionFilter
implements FileFilter {
    private String ext = "";
    private Pattern filterPattern = null;
    private boolean acceptDirectory = false;

    private Pattern compilePattern(String regexpr) {
        try {
            return Pattern.compile(regexpr);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeWrapper(e);
        }
    }

    public ExtensionFilter(String cfFilter) {
        if (cfFilter == null || cfFilter.length() == 0) {
            return;
        }
        int index = cfFilter.lastIndexOf(".");
        this.ext = index == -1 ? "" : cfFilter.substring(index);
        int prevAsterisk = -2;
        Object regex = "";
        for (int i = 0; i < cfFilter.length(); ++i) {
            char c = cfFilter.charAt(i);
            if (c == '*') {
                if (prevAsterisk != i - 1) {
                    regex = (String)regex + ".*";
                }
                prevAsterisk = i;
                continue;
            }
            regex = c == '?' ? (String)regex + "." : (c == '.' || c == '+' || c == '{' || c == '}' || c == '(' || c == ')' || c == '[' || c == ']' || c == '\\' || c == '^' || c == '$' ? (String)regex + "\\" + String.valueOf(c) : (String)regex + String.valueOf(c));
        }
        if (File.separatorChar == '\\') {
            regex = ((String)regex).toLowerCase();
        }
        this.filterPattern = this.compilePattern((String)regex);
    }

    public ExtensionFilter(String filter, boolean acceptDirectory) {
        this(filter);
        this.acceptDirectory = acceptDirectory;
    }

    @Override
    public boolean accept(File file) {
        if (this.acceptDirectory && file.isDirectory()) {
            return true;
        }
        if (this.filterPattern == null) {
            return true;
        }
        String fileName = file.getName();
        if (File.separatorChar == '\\') {
            fileName = fileName.toLowerCase();
        }
        Matcher matcher = this.filterPattern.matcher(fileName);
        return matcher.matches();
    }

    public String toString() {
        return this.ext;
    }

    public boolean accept(String name) {
        if (File.separatorChar == '\\') {
            name = name.toLowerCase();
        }
        Matcher matcher = this.filterPattern.matcher(name);
        return matcher.matches();
    }
}

